/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.web.bean.repository.tenant;

import java.io.PrintWriter;
import java.io.Serializable;
import java.io.StringWriter;
import javax.faces.context.FacesContext;
import org.alfresco.repo.tenant.TenantInterpreter;
import org.alfresco.web.app.servlet.FacesHelper;

public class TenantAdminConsoleBean
implements Serializable {
    private static final long serialVersionUID = -9116623180660597894L;
    private String command = "";
    private String submittedCommand = "none";
    private long duration = 0L;
    private String result = null;
    private transient TenantInterpreter tenantInterpreter;

    public void setTenantInterpreter(TenantInterpreter tenantInterpreter) {
        this.tenantInterpreter = tenantInterpreter;
    }

    private TenantInterpreter geTenantInterpreter() {
        if (this.tenantInterpreter == null) {
            this.tenantInterpreter = (TenantInterpreter)FacesHelper.getManagedBean(FacesContext.getCurrentInstance(), "tenantInterpreter");
        }
        return this.tenantInterpreter;
    }

    public String getResult() {
        if (this.result == null) {
            this.interpretCommand("help");
        }
        return this.result;
    }

    public void setResult(String result) {
        this.result = result;
    }

    public String getCommand() {
        return this.command;
    }

    public void setCommand(String command) {
        this.command = command;
    }

    public String getSubmittedCommand() {
        return this.submittedCommand;
    }

    public void setSubmittedCommand(String submittedCommand) {
        this.submittedCommand = submittedCommand;
    }

    public long getDuration() {
        return this.duration;
    }

    public void setDuration(long duration) {
        this.duration = duration;
    }

    public String submitCommand() {
        this.interpretCommand(this.command);
        return "success";
    }

    public String getCurrentUserName() {
        return this.geTenantInterpreter() != null ? this.geTenantInterpreter().getCurrentUserName() : null;
    }

    private void interpretCommand(String command) {
        try {
            long startms = System.currentTimeMillis();
            String result = this.geTenantInterpreter() != null ? this.geTenantInterpreter().interpretCommand(command) : "Tenant AdminConsole is not available - check that multi-tenancy is enabled !";
            this.setDuration(System.currentTimeMillis() - startms);
            this.setResult(result);
            this.setCommand("");
            this.setSubmittedCommand(command);
        }
        catch (Exception e) {
            StringWriter stackTrace = new StringWriter();
            e.printStackTrace(new PrintWriter(stackTrace));
            this.setResult(stackTrace.toString());
        }
    }
}

