/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.web.bean.spaces;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.faces.context.FacesContext;
import javax.transaction.UserTransaction;
import org.alfresco.model.ContentModel;
import org.alfresco.service.cmr.dictionary.TypeDefinition;
import org.alfresco.service.cmr.repository.ChildAssociationRef;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.namespace.QName;
import org.alfresco.service.namespace.QNamePattern;
import org.alfresco.service.namespace.RegexQNamePattern;
import org.alfresco.service.transaction.TransactionService;
import org.alfresco.web.app.Application;
import org.alfresco.web.bean.content.DeleteContentDialog;
import org.alfresco.web.bean.dialog.BaseDialogBean;
import org.alfresco.web.bean.repository.Node;
import org.alfresco.web.bean.repository.Repository;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DeleteSpaceDialog
extends BaseDialogBean {
    private static final long serialVersionUID = 5960844637376808571L;
    private static final Log logger = LogFactory.getLog(DeleteContentDialog.class);
    private static final String DELETE_ALL = "all";
    private static final String DELETE_FILES = "files";
    private static final String DELETE_FOLDERS = "folders";
    private static final String DELETE_CONTENTS = "contents";
    private String deleteMode = "all";
    private boolean executeRules = true;
    private boolean archiveNodes = true;
    protected boolean hasMultipleParents = false;

    @Override
    public void init(Map<String, String> parameters) {
        super.init(parameters);
        this.hasMultipleParents = false;
        String strHasMultipleParents = (String)this.parameters.get("hasMultipleParents");
        if (strHasMultipleParents != null && "true".equals(strHasMultipleParents)) {
            this.hasMultipleParents = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    protected String finishImpl(FacesContext context, String outcome) throws Exception {
        boolean isAdmin = this.navigator.getCurrentUser().isAdmin();
        Node node = this.browseBean.getActionSpace();
        if (node != null) {
            node.getName();
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Trying to delete space: " + node.getId() + " using delete mode: " + this.deleteMode));
            }
            try {
                if (isAdmin && !this.executeRules) {
                    Repository.getServiceRegistry(context).getRuleService().disableRules();
                }
                if (DELETE_ALL.equals(this.deleteMode)) {
                    NodeRef nodeRef = node.getNodeRef();
                    if (!this.getNodeService().exists(nodeRef)) return outcome;
                    if (isAdmin && !this.archiveNodes) {
                        this.getNodeService().addAspect(node.getNodeRef(), ContentModel.ASPECT_TEMPORARY, null);
                    }
                    this.getNodeService().deleteNode(node.getNodeRef());
                    return outcome;
                }
                List childRefs = this.getNodeService().getChildAssocs(node.getNodeRef(), (QNamePattern)ContentModel.ASSOC_CONTAINS, RegexQNamePattern.MATCH_ALL);
                ArrayList<NodeRef> deleteRefs = new ArrayList<NodeRef>(childRefs.size());
                for (ChildAssociationRef ref : childRefs) {
                    NodeRef nodeRef = ref.getChildRef();
                    if (!this.getNodeService().exists(nodeRef)) continue;
                    if (DELETE_CONTENTS.equals(this.deleteMode)) {
                        deleteRefs.add(nodeRef);
                        continue;
                    }
                    QName type = this.getNodeService().getType(nodeRef);
                    TypeDefinition typeDef = this.getDictionaryService().getType(type);
                    if (typeDef == null) continue;
                    if (DELETE_FOLDERS.equals(this.deleteMode)) {
                        if (!this.getDictionaryService().isSubClass(type, ContentModel.TYPE_FOLDER) || this.getDictionaryService().isSubClass(type, ContentModel.TYPE_SYSTEM_FOLDER)) continue;
                        deleteRefs.add(nodeRef);
                        continue;
                    }
                    if (!DELETE_FILES.equals(this.deleteMode) || !this.getDictionaryService().isSubClass(type, ContentModel.TYPE_CONTENT)) continue;
                    deleteRefs.add(nodeRef);
                }
                TransactionService txService = Repository.getServiceRegistry(context).getTransactionService();
                for (NodeRef nodeRef : deleteRefs) {
                    UserTransaction tx = null;
                    try {
                        tx = txService.getNonPropagatingUserTransaction();
                        tx.begin();
                        if (isAdmin && !this.archiveNodes) {
                            this.getNodeService().addAspect(nodeRef, ContentModel.ASPECT_TEMPORARY, null);
                        }
                        this.getNodeService().deleteNode(nodeRef);
                        tx.commit();
                    }
                    catch (Throwable err) {
                        try {
                            if (tx == null) continue;
                            tx.rollback();
                        }
                        catch (Exception ex) {}
                    }
                }
                return outcome;
            }
            finally {
                if (isAdmin && !this.executeRules) {
                    Repository.getServiceRegistry(context).getRuleService().enableRules();
                }
            }
        } else {
            logger.warn((Object)"WARNING: delete called without a current Space!");
        }
        return outcome;
    }

    @Override
    protected String doPostCommitProcessing(FacesContext context, String outcome) {
        Node node = this.browseBean.getActionSpace();
        if (node != null && !this.getNodeService().exists(node.getNodeRef())) {
            this.browseBean.removeSpaceFromBreadcrumb(node);
            this.browseBean.setActionSpace(null);
            return "dialog:close:browse";
        }
        return outcome;
    }

    @Override
    protected String getErrorMessageId() {
        return "error_delete_space";
    }

    @Override
    public boolean getFinishButtonDisabled() {
        return false;
    }

    protected String getConfirmMessageId() {
        return "delete_space_confirm";
    }

    public String getConfirmMessage() {
        String fileConfirmMsg = Application.getMessage(FacesContext.getCurrentInstance(), this.getConfirmMessageId());
        Node node = this.browseBean.getActionSpace();
        if (node != null) {
            return MessageFormat.format(fileConfirmMsg, node.getName());
        }
        return Application.getMessage(FacesContext.getCurrentInstance(), "delete_node_not_found");
    }

    public String getDeleteMode() {
        return this.deleteMode;
    }

    public void setDeleteMode(String deleteMode) {
        this.deleteMode = deleteMode;
    }

    public boolean getHasMultipleParents() {
        return this.hasMultipleParents;
    }

    public boolean getExecuteRules() {
        return this.executeRules;
    }

    public void setExecuteRules(boolean executeRules) {
        this.executeRules = executeRules;
    }

    public boolean getArchiveNodes() {
        return this.archiveNodes;
    }

    public void setArchiveNodes(boolean archiveNodes) {
        this.archiveNodes = archiveNodes;
    }
}

