/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.web.bean.spaces;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import javax.faces.context.FacesContext;
import org.alfresco.model.ContentModel;
import org.alfresco.service.cmr.dictionary.DataTypeDefinition;
import org.alfresco.service.cmr.dictionary.PropertyDefinition;
import org.alfresco.service.cmr.repository.AssociationRef;
import org.alfresco.service.cmr.repository.ChildAssociationRef;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.namespace.QName;
import org.alfresco.web.app.Application;
import org.alfresco.web.bean.repository.Node;
import org.alfresco.web.bean.spaces.CreateSpaceDialog;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EditSpaceDialog
extends CreateSpaceDialog {
    private static final long serialVersionUID = 6090397957979372269L;
    protected Node editableNode;

    @Override
    public void init(Map<String, String> parameters) {
        super.init(parameters);
        this.editableNode = this.initEditableNode();
        this.spaceType = this.editableNode.getType().toString();
    }

    @Override
    public boolean getFinishButtonDisabled() {
        return false;
    }

    protected Node initEditableNode() {
        return new Node(this.browseBean.getActionSpace().getNodeRef());
    }

    @Override
    public String getFinishButtonLabel() {
        return Application.getMessage(FacesContext.getCurrentInstance(), "ok");
    }

    @Override
    protected String finishImpl(FacesContext context, String outcome) throws Exception {
        NodeRef nodeRef = this.editableNode.getNodeRef();
        Map<String, Object> editedProps = this.editableNode.getProperties();
        String name = (String)editedProps.get(ContentModel.PROP_NAME);
        if (name != null) {
            this.getFileFolderService().rename(nodeRef, name);
        }
        HashMap<QName, Serializable> repoProps = new HashMap<QName, Serializable>(7);
        for (String propName : editedProps.keySet()) {
            PropertyDefinition propDef;
            QName qname = QName.createQName((String)propName);
            Serializable propValue = (Serializable)editedProps.get(propName);
            if (propValue != null && propValue instanceof String && propValue.toString().length() == 0 && (propDef = this.getDictionaryService().getProperty(qname)) != null && (propDef.getDataType().getName().equals((Object)DataTypeDefinition.DOUBLE) || propDef.getDataType().getName().equals((Object)DataTypeDefinition.FLOAT) || propDef.getDataType().getName().equals((Object)DataTypeDefinition.INT) || propDef.getDataType().getName().equals((Object)DataTypeDefinition.LONG))) {
                propValue = null;
            }
            repoProps.put(qname, propValue);
        }
        this.getNodeService().addProperties(nodeRef, repoProps);
        Map<String, Map<String, AssociationRef>> addedAssocs = this.editableNode.getAddedAssociations();
        for (Map<String, AssociationRef> typedAssoc : addedAssocs.values()) {
            for (AssociationRef associationRef : typedAssoc.values()) {
                this.getNodeService().createAssociation(associationRef.getSourceRef(), associationRef.getTargetRef(), associationRef.getTypeQName());
            }
        }
        Map<String, Map<String, AssociationRef>> removedAssocs = this.editableNode.getRemovedAssociations();
        for (Map<String, AssociationRef> typedAssoc : removedAssocs.values()) {
            for (AssociationRef associationRef : typedAssoc.values()) {
                this.getNodeService().removeAssociation(associationRef.getSourceRef(), associationRef.getTargetRef(), associationRef.getTypeQName());
            }
        }
        Map<String, Map<String, ChildAssociationRef>> addedChildAssocs = this.editableNode.getAddedChildAssociations();
        for (Map map : addedChildAssocs.values()) {
            for (ChildAssociationRef assoc : map.values()) {
                this.getNodeService().addChild(assoc.getParentRef(), assoc.getChildRef(), assoc.getTypeQName(), assoc.getTypeQName());
            }
        }
        Map<String, Map<String, ChildAssociationRef>> removedChildAssocs = this.editableNode.getRemovedChildAssociations();
        for (Map<String, ChildAssociationRef> map : removedChildAssocs.values()) {
            for (ChildAssociationRef assoc : map.values()) {
                this.getNodeService().removeChild(assoc.getParentRef(), assoc.getChildRef());
            }
        }
        return "dialog:close";
    }

    @Override
    protected String doPostCommitProcessing(FacesContext context, String outcome) {
        this.browseBean.getActionSpace().reset();
        return outcome;
    }

    public Node getEditableNode() {
        return this.editableNode;
    }
}

