/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.web.bean.users;

import java.io.Serializable;
import java.text.MessageFormat;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;
import javax.faces.application.FacesMessage;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.event.ActionEvent;
import javax.faces.validator.ValidatorException;
import org.alfresco.error.AlfrescoRuntimeException;
import org.alfresco.model.ApplicationModel;
import org.alfresco.model.ContentModel;
import org.alfresco.repo.tenant.TenantService;
import org.alfresco.service.cmr.repository.ChildAssociationRef;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.security.MutableAuthenticationService;
import org.alfresco.service.cmr.security.OwnableService;
import org.alfresco.service.cmr.security.PermissionService;
import org.alfresco.service.cmr.security.PersonService;
import org.alfresco.service.cmr.usage.ContentUsageService;
import org.alfresco.service.namespace.NamespacePrefixResolver;
import org.alfresco.service.namespace.QName;
import org.alfresco.util.Pair;
import org.alfresco.web.app.Application;
import org.alfresco.web.app.context.UIContextService;
import org.alfresco.web.app.servlet.FacesHelper;
import org.alfresco.web.bean.repository.Repository;
import org.alfresco.web.bean.wizard.BaseWizardBean;
import org.alfresco.web.config.ClientConfigElement;
import org.alfresco.web.ui.common.ReportedException;
import org.alfresco.web.ui.common.Utils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CreateUserWizard
extends BaseWizardBean {
    private static final long serialVersionUID = 8008464794715380019L;
    private static Log logger = LogFactory.getLog(BaseWizardBean.class);
    protected static final String ERROR = "error_person";
    protected static final String ERROR_DOMAIN_MISMATCH = "error_domain_mismatch";
    private static final String MSG_ERROR_NEWUSER_HOME_SPACE = "error_newuser_home_space";
    protected static final String QUOTA_UNITS_KB = "kilobyte";
    protected static final String QUOTA_UNITS_MB = "megabyte";
    protected static final String QUOTA_UNITS_GB = "gigabyte";
    protected String firstName = null;
    protected String lastName = null;
    protected String userName = null;
    protected String password = null;
    protected String confirm = null;
    protected String email = null;
    protected String companyId = null;
    protected String homeSpaceName = "";
    protected NodeRef homeSpaceLocation = null;
    protected String presenceProvider = null;
    protected String presenceUsername = null;
    protected String organisation = null;
    protected String jobtitle = null;
    protected String location = null;
    protected Long sizeQuota = null;
    protected String sizeQuotaUnits = null;
    private transient MutableAuthenticationService authenticationService;
    private transient PersonService personService;
    private transient TenantService tenantService;
    private transient PermissionService permissionService;
    private transient OwnableService ownableService;
    private transient ContentUsageService contentUsageService;
    private NodeRef companyHomeSpaceRef = null;
    private NodeRef defaultHomeSpaceRef;

    public void setAuthenticationService(MutableAuthenticationService authenticationService) {
        this.authenticationService = authenticationService;
    }

    private MutableAuthenticationService getAuthenticationService() {
        if (this.authenticationService == null) {
            this.authenticationService = Repository.getServiceRegistry(FacesContext.getCurrentInstance()).getAuthenticationService();
        }
        return this.authenticationService;
    }

    public void setPersonService(PersonService personService) {
        this.personService = personService;
    }

    private PersonService getPersonService() {
        if (this.personService == null) {
            this.personService = Repository.getServiceRegistry(FacesContext.getCurrentInstance()).getPersonService();
        }
        return this.personService;
    }

    public void setTenantService(TenantService tenantService) {
        this.tenantService = tenantService;
    }

    private TenantService getTenantService() {
        if (this.tenantService == null) {
            this.tenantService = (TenantService)FacesHelper.getManagedBean(FacesContext.getCurrentInstance(), "tenantService");
        }
        return this.tenantService;
    }

    public void setPermissionService(PermissionService permissionService) {
        this.permissionService = permissionService;
    }

    private PermissionService getPermissionService() {
        if (this.permissionService == null) {
            this.permissionService = Repository.getServiceRegistry(FacesContext.getCurrentInstance()).getPermissionService();
        }
        return this.permissionService;
    }

    public void setOwnableService(OwnableService ownableService) {
        this.ownableService = ownableService;
    }

    private OwnableService getOwnableService() {
        if (this.ownableService == null) {
            this.ownableService = Repository.getServiceRegistry(FacesContext.getCurrentInstance()).getOwnableService();
        }
        return this.ownableService;
    }

    public void setContentUsageService(ContentUsageService contentUsageService) {
        this.contentUsageService = contentUsageService;
    }

    private ContentUsageService getContentUsageService() {
        if (this.contentUsageService == null) {
            this.contentUsageService = (ContentUsageService)FacesHelper.getManagedBean(FacesContext.getCurrentInstance(), "ContentUsageService");
        }
        return this.contentUsageService;
    }

    @Override
    public void init(Map<String, String> params) {
        super.init(params);
        this.firstName = "";
        this.lastName = "";
        this.userName = "";
        this.password = "";
        this.confirm = "";
        this.email = "";
        this.companyId = "";
        this.homeSpaceName = "";
        this.homeSpaceLocation = this.getDefaultHomeSpace();
        this.presenceProvider = "";
        this.presenceUsername = "";
        this.organisation = "";
        this.jobtitle = "";
        this.location = "";
        this.sizeQuota = null;
        this.sizeQuotaUnits = "";
    }

    @Override
    public String next() {
        String stepName = Application.getWizardManager().getCurrentStepName();
        if ("summary".equals(stepName)) {
            FacesContext context = FacesContext.getCurrentInstance();
            if (!this.password.equals(this.confirm)) {
                Utils.addErrorMessage(Application.getMessage(context, "error_password_match"));
            }
            this.checkTenantUserName();
            if (context.getMessages().hasNext()) {
                Application.getWizardManager().getState().setCurrentStep(Application.getWizardManager().getCurrentStep() - 1);
            }
        }
        return super.next();
    }

    public String getSummary() {
        ResourceBundle bundle = Application.getBundle(FacesContext.getCurrentInstance());
        String homeSpaceLabel = this.homeSpaceName;
        if (this.homeSpaceName.length() == 0 && this.homeSpaceLocation != null) {
            homeSpaceLabel = Repository.getNameForNode(this.getNodeService(), this.homeSpaceLocation);
        }
        String quotaLabel = "";
        if (this.sizeQuota != null && this.sizeQuota != -1L) {
            quotaLabel = Long.toString(this.sizeQuota) + bundle.getString(this.sizeQuotaUnits);
        }
        String presenceLabel = "";
        if (this.presenceProvider != null && this.presenceProvider.length() != 0) {
            presenceLabel = this.presenceUsername + " (" + this.presenceProvider + ")";
        }
        return this.buildSummary(new String[]{bundle.getString("name"), bundle.getString("username"), bundle.getString("password"), bundle.getString("homespace"), bundle.getString("email"), bundle.getString("user_organization"), bundle.getString("user_jobtitle"), bundle.getString("user_location"), bundle.getString("presence_username"), bundle.getString("quota")}, new String[]{Utils.encode((String)(this.firstName + " " + this.lastName)), Utils.encode((String)this.userName), "********", Utils.encode((String)homeSpaceLabel), Utils.encode((String)this.email), Utils.encode((String)this.organisation), Utils.encode((String)this.jobtitle), Utils.encode((String)this.location), Utils.encode((String)presenceLabel), quotaLabel});
    }

    public void setupUsers(ActionEvent event) {
        this.invalidateUserList();
    }

    public String getCompanyId() {
        return this.companyId;
    }

    public void setCompanyId(String companyId) {
        this.companyId = companyId;
    }

    public String getPresenceProvider() {
        return this.presenceProvider;
    }

    public void setPresenceProvider(String presenceProvider) {
        this.presenceProvider = presenceProvider;
    }

    public String getPresenceUsername() {
        return this.presenceUsername;
    }

    public void setPresenceUsername(String presenceUsername) {
        this.presenceUsername = presenceUsername;
    }

    public String getEmail() {
        return this.email;
    }

    public void setEmail(String email) {
        this.email = email;
    }

    public String getFirstName() {
        return this.firstName;
    }

    public void setFirstName(String firstName) {
        this.firstName = firstName;
    }

    public NodeRef getHomeSpaceLocation() {
        return this.homeSpaceLocation;
    }

    public void setHomeSpaceLocation(NodeRef homeSpaceLocation) {
        this.homeSpaceLocation = homeSpaceLocation;
    }

    public String getHomeSpaceName() {
        return this.homeSpaceName;
    }

    public void setHomeSpaceName(String homeSpaceName) {
        this.homeSpaceName = homeSpaceName;
    }

    public String getLastName() {
        return this.lastName;
    }

    public void setLastName(String lastName) {
        this.lastName = lastName;
    }

    public String getUserName() {
        return this.userName;
    }

    public void setUserName(String userName) {
        this.userName = userName != null ? userName.trim() : null;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public String getConfirm() {
        return this.confirm;
    }

    public void setConfirm(String confirm) {
        this.confirm = confirm;
    }

    public String getJobtitle() {
        return this.jobtitle;
    }

    public void setJobtitle(String jobtitle) {
        this.jobtitle = jobtitle;
    }

    public String getLocation() {
        return this.location;
    }

    public void setLocation(String location) {
        this.location = location;
    }

    public String getOrganization() {
        return this.organisation;
    }

    public void setOrganization(String organisation) {
        this.organisation = organisation;
    }

    public Long getSizeQuota() {
        return this.sizeQuota;
    }

    public void setSizeQuota(Long sizeQuota) {
        this.sizeQuota = sizeQuota;
    }

    public String getSizeQuotaUnits() {
        return this.sizeQuotaUnits;
    }

    public void setSizeQuotaUnits(String sizeQuotaUnits) {
        this.sizeQuotaUnits = sizeQuotaUnits;
    }

    public void validatePassword(FacesContext context, UIComponent component, Object value) throws ValidatorException {
        int minPasswordLength = Application.getClientConfig(context).getMinPasswordLength();
        String pass = (String)value;
        if (pass.length() < minPasswordLength || pass.length() > 256) {
            String err = MessageFormat.format(Application.getMessage(context, "login_err_password_length"), minPasswordLength, 256);
            throw new ValidatorException(new FacesMessage(err));
        }
    }

    public void validateUsername(FacesContext context, UIComponent component, Object value) throws ValidatorException {
        int minUsernameLength = Application.getClientConfig(context).getMinUsernameLength();
        String name = ((String)value).trim();
        if (name.length() < minUsernameLength || name.length() > 256) {
            String err = MessageFormat.format(Application.getMessage(context, "login_err_username_length"), minUsernameLength, 256);
            throw new ValidatorException(new FacesMessage(err));
        }
        if (name.indexOf(34) != -1 || name.indexOf(92) != -1) {
            String err = MessageFormat.format(Application.getMessage(context, "user_err_user_name"), "\", \\");
            throw new ValidatorException(new FacesMessage(err));
        }
    }

    protected NodeRef getCompanyHomeSpace() {
        if (this.companyHomeSpaceRef == null) {
            String companyXPath = Application.getRootPath(FacesContext.getCurrentInstance());
            NodeRef rootNodeRef = this.getNodeService().getRootNode(Repository.getStoreRef());
            List nodes = this.getSearchService().selectNodes(rootNodeRef, companyXPath, null, (NamespacePrefixResolver)this.getNamespaceService(), false);
            if (nodes.size() == 0) {
                throw new IllegalStateException("Unable to find company home space path: " + companyXPath);
            }
            this.companyHomeSpaceRef = (NodeRef)nodes.get(0);
        }
        return this.companyHomeSpaceRef;
    }

    protected NodeRef getDefaultHomeSpace() {
        if (this.defaultHomeSpaceRef == null || !this.getNodeService().exists(this.defaultHomeSpaceRef)) {
            String defaultHomeSpacePath = Application.getClientConfig(FacesContext.getCurrentInstance()).getDefaultHomeSpacePath();
            NodeRef rootNodeRef = this.getNodeService().getRootNode(Repository.getStoreRef());
            List nodes = this.getSearchService().selectNodes(rootNodeRef, defaultHomeSpacePath, null, (NamespacePrefixResolver)this.getNamespaceService(), false);
            if (nodes.size() == 0) {
                return this.getCompanyHomeSpace();
            }
            this.defaultHomeSpaceRef = (NodeRef)nodes.get(0);
        }
        return this.defaultHomeSpaceRef;
    }

    protected NodeRef createHomeSpace(String locationId, String spaceName, boolean error) {
        NodeRef homeSpaceNodeRef = null;
        if (spaceName != null && spaceName.length() != 0) {
            NodeRef parentRef = new NodeRef(Repository.getStoreRef(), locationId);
            NodeRef childRef = this.getNodeService().getChildByName(parentRef, ContentModel.ASSOC_CONTAINS, spaceName);
            if (childRef != null) {
                if (error) {
                    throw new AlfrescoRuntimeException("A Home Space with the same name already exists.");
                }
                return childRef;
            }
            String qname = QName.createValidLocalName((String)spaceName);
            ChildAssociationRef assocRef = this.getNodeService().createNode(parentRef, ContentModel.ASSOC_CONTAINS, QName.createQName((String)"http://www.alfresco.org/model/system/1.0", (String)qname), ContentModel.TYPE_FOLDER);
            NodeRef nodeRef = assocRef.getChildRef();
            this.getNodeService().setProperty(nodeRef, ContentModel.PROP_NAME, (Serializable)((Object)spaceName));
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Created Home Space for with name: " + spaceName));
            }
            HashMap<QName, String> uiFacetsProps = new HashMap<QName, String>(3);
            uiFacetsProps.put(ApplicationModel.PROP_ICON, "space-icon-default");
            uiFacetsProps.put(ContentModel.PROP_TITLE, spaceName);
            this.getNodeService().addAspect(nodeRef, ApplicationModel.ASPECT_UIFACETS, uiFacetsProps);
            this.setupHomeSpacePermissions(nodeRef);
            homeSpaceNodeRef = nodeRef;
        }
        return homeSpaceNodeRef;
    }

    private void setupHomeSpacePermissions(NodeRef homeSpaceRef) {
        this.getPermissionService().setPermission(homeSpaceRef, this.userName, this.getPermissionService().getAllPermission(), true);
        String permission = this.getDefaultPermission();
        if (permission != null && permission.length() != 0) {
            this.getPermissionService().setPermission(homeSpaceRef, this.getPermissionService().getAllAuthorities(), permission, true);
        }
        this.getOwnableService().setOwner(homeSpaceRef, this.userName);
        this.getPermissionService().setPermission(homeSpaceRef, this.getPermissionService().getOwnerAuthority(), this.getPermissionService().getAllPermission(), true);
        this.getPermissionService().setInheritParentPermissions(homeSpaceRef, false);
    }

    private String getDefaultPermission() {
        ClientConfigElement config = Application.getClientConfig(FacesContext.getCurrentInstance());
        return config.getHomeSpacePermission();
    }

    private void invalidateUserList() {
        UIContextService.getInstance(FacesContext.getCurrentInstance()).notifyBeans();
    }

    @Override
    protected String finishImpl(FacesContext context, String outcome) throws Throwable {
        try {
            if (!this.password.equals(this.confirm)) {
                Utils.addErrorMessage(Application.getMessage(context, "error_password_match"));
                outcome = null;
            }
            if (!this.checkTenantUserName()) {
                outcome = null;
            }
            if (outcome != null) {
                NodeRef homeSpaceNodeRef;
                HashMap<QName, String> props = new HashMap<QName, String>(7, 1.0f);
                props.put(ContentModel.PROP_USERNAME, this.userName);
                props.put(ContentModel.PROP_FIRSTNAME, this.firstName);
                props.put(ContentModel.PROP_LASTNAME, this.lastName);
                if (this.homeSpaceLocation != null && this.homeSpaceName.length() != 0) {
                    homeSpaceNodeRef = this.createHomeSpace(this.homeSpaceLocation.getId(), this.homeSpaceName, true);
                } else if (this.homeSpaceLocation != null) {
                    if (this.defaultHomeSpaceRef.equals((Object)this.homeSpaceLocation)) {
                        throw new AlfrescoRuntimeException(Application.getMessage(context, MSG_ERROR_NEWUSER_HOME_SPACE));
                    }
                    homeSpaceNodeRef = this.homeSpaceLocation;
                    this.setupHomeSpacePermissions(homeSpaceNodeRef);
                } else {
                    homeSpaceNodeRef = this.getCompanyHomeSpace();
                }
                props.put(ContentModel.PROP_HOMEFOLDER, (String)homeSpaceNodeRef);
                props.put(ContentModel.PROP_EMAIL, this.email);
                props.put(ContentModel.PROP_ORGID, this.companyId);
                props.put(ContentModel.PROP_ORGANIZATION, this.organisation);
                props.put(ContentModel.PROP_JOBTITLE, this.jobtitle);
                props.put(ContentModel.PROP_LOCATION, this.location);
                props.put(ContentModel.PROP_PRESENCEPROVIDER, this.presenceProvider);
                props.put(ContentModel.PROP_PRESENCEUSERNAME, this.presenceUsername);
                this.getPersonService().createPerson(props);
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("Created Person node for username: " + this.userName));
                }
                this.getAuthenticationService().createAuthentication(this.userName, this.password.toCharArray());
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("Created User Authentication instance for username: " + this.userName));
                }
                if (this.sizeQuota != null && this.sizeQuota < 0L) {
                    Utils.addErrorMessage(MessageFormat.format(Application.getMessage(context, "error_negative_quota"), this.sizeQuota));
                    outcome = null;
                } else {
                    this.putSizeQuotaProperty(this.userName, this.sizeQuota, this.sizeQuotaUnits);
                }
            }
            this.invalidateUserList();
        }
        catch (Throwable e) {
            Utils.addErrorMessage(MessageFormat.format(Application.getMessage(FacesContext.getCurrentInstance(), ERROR), e.getMessage()), e);
            outcome = null;
            this.isFinished = false;
            ReportedException.throwIfNecessary(e);
        }
        if (outcome == null) {
            this.isFinished = false;
        }
        return outcome;
    }

    @Override
    public boolean getFinishButtonDisabled() {
        return this.firstName == null || this.lastName == null || this.email == null || this.firstName.length() <= 0 || this.lastName.length() <= 0 || this.email.length() <= 0;
    }

    protected void putSizeQuotaProperty(String userName, Long quota, String quotaUnits) {
        if (quota != null) {
            if (quota >= 0L) {
                quota = this.convertToBytes(quota, quotaUnits);
            } else {
                return;
            }
        }
        this.getContentUsageService().setUserQuota(userName, quota == null ? -1L : quota);
    }

    protected long convertToBytes(long size, String units) {
        if (units != null) {
            if (units.equals(QUOTA_UNITS_KB)) {
                size *= 1024L;
            } else if (units.equals(QUOTA_UNITS_MB)) {
                size *= 0x100000L;
            } else if (units.equals(QUOTA_UNITS_GB)) {
                size *= 0x40000000L;
            }
        }
        return size;
    }

    protected Pair<Long, String> convertFromBytes(long size) {
        String units = null;
        if (size <= 0L) {
            units = QUOTA_UNITS_GB;
        } else if (size < 999999L) {
            size = (long)((double)size / 1024.0);
            units = QUOTA_UNITS_KB;
        } else if (size < 999999999L) {
            size = (long)((double)size / 1048576.0);
            units = QUOTA_UNITS_MB;
        } else {
            size = (long)((double)size / 1.073741824E9);
            units = QUOTA_UNITS_GB;
        }
        return new Pair((Object)size, (Object)units);
    }

    public boolean checkTenantUserName() {
        if (this.getTenantService().isEnabled()) {
            String currentDomain = this.getTenantService().getCurrentUserDomain();
            String userDomain = "";
            int idx = this.userName.indexOf("@");
            if (idx != -1 && idx < this.userName.length() - 1) {
                userDomain = this.userName.substring(idx + 1);
            }
            if (!currentDomain.equals("") && userDomain.equals("")) {
                this.userName = this.getTenantService().getDomainUser(this.userName, currentDomain);
                logger.warn((Object)("Added domain to username: " + this.userName));
            } else if (!currentDomain.equals(userDomain)) {
                Utils.addErrorMessage(MessageFormat.format(Application.getMessage(FacesContext.getCurrentInstance(), ERROR_DOMAIN_MISMATCH), currentDomain, userDomain));
                return false;
            }
        }
        return true;
    }

    public Map getPersonPropertiesImmutability() {
        return Collections.EMPTY_MAP;
    }
}

