/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.web.bean.users;

import java.io.Serializable;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.faces.context.FacesContext;
import javax.faces.event.ActionEvent;
import javax.transaction.UserTransaction;
import org.alfresco.model.ContentModel;
import org.alfresco.repo.security.permissions.AccessDeniedException;
import org.alfresco.service.cmr.dictionary.DictionaryService;
import org.alfresco.service.cmr.repository.InvalidNodeRefException;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.NodeService;
import org.alfresco.service.cmr.security.AccessStatus;
import org.alfresco.service.cmr.security.PermissionService;
import org.alfresco.web.app.Application;
import org.alfresco.web.bean.BrowseBean;
import org.alfresco.web.bean.repository.Node;
import org.alfresco.web.bean.repository.PreferencesService;
import org.alfresco.web.bean.repository.Repository;
import org.alfresco.web.ui.common.Utils;
import org.alfresco.web.ui.common.component.UIActionLink;
import org.alfresco.web.ui.repo.component.shelf.UIShortcutsShelfItem;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UserShortcutsBean
implements Serializable {
    private static final long serialVersionUID = -2264529845476479897L;
    private static Log logger = LogFactory.getLog(UserShortcutsBean.class);
    protected transient NodeService nodeService;
    protected BrowseBean browseBean;
    private transient PermissionService permissionService;
    private List<Node> shortcuts = null;
    private static final String PREF_SHORTCUTS = "shortcuts";

    public void setNodeService(NodeService nodeService) {
        this.nodeService = nodeService;
    }

    protected NodeService getNodeService() {
        if (this.nodeService == null) {
            this.nodeService = Repository.getServiceRegistry(FacesContext.getCurrentInstance()).getNodeService();
        }
        return this.nodeService;
    }

    public void setBrowseBean(BrowseBean browseBean) {
        this.browseBean = browseBean;
    }

    public void setPermissionService(PermissionService permissionService) {
        this.permissionService = permissionService;
    }

    protected PermissionService getPermissionService() {
        if (this.permissionService == null) {
            this.permissionService = Repository.getServiceRegistry(FacesContext.getCurrentInstance()).getPermissionService();
        }
        return this.permissionService;
    }

    public List<Node> getShortcuts() {
        if (this.shortcuts == null) {
            List<String> shortcuts = null;
            Object prefRef = null;
            UserTransaction tx = null;
            boolean rollback = false;
            try {
                FacesContext context = FacesContext.getCurrentInstance();
                tx = Repository.getUserTransaction(context);
                tx.begin();
                shortcuts = UserShortcutsBean.getShortcutList(context);
                if (shortcuts.size() != 0) {
                    this.shortcuts = new ArrayList<Node>(shortcuts.size());
                    for (int i = 0; i < shortcuts.size(); ++i) {
                        NodeRef ref = new NodeRef(Repository.getStoreRef(), shortcuts.get(i));
                        try {
                            if (this.getNodeService().exists(ref)) {
                                Node node = new Node(ref);
                                node.getProperties();
                                this.shortcuts.add(node);
                                continue;
                            }
                            if (!logger.isDebugEnabled()) continue;
                            logger.debug((Object)("Found invalid shortcut node Id: " + ref.getId()));
                            continue;
                        }
                        catch (AccessDeniedException accessErr) {
                            if (logger.isDebugEnabled()) {
                                logger.debug((Object)("Found invalid shortcut node Id: " + ref.getId()));
                            }
                            rollback = true;
                        }
                    }
                } else {
                    this.shortcuts = new ArrayList<Node>(5);
                }
                if (!rollback) {
                    tx.commit();
                } else {
                    tx.rollback();
                }
            }
            catch (Throwable err) {
                Utils.addErrorMessage(MessageFormat.format(Application.getMessage(FacesContext.getCurrentInstance(), "error_generic"), err.getMessage()), err);
                try {
                    if (tx != null) {
                        tx.rollback();
                    }
                }
                catch (Exception tex) {
                    // empty catch block
                }
            }
            if (shortcuts != null && shortcuts.size() != this.shortcuts.size()) {
                try {
                    shortcuts = new ArrayList<String>(this.shortcuts.size());
                    for (int i = 0; i < this.shortcuts.size(); ++i) {
                        shortcuts.add(this.shortcuts.get(i).getId());
                    }
                    PreferencesService.getPreferences().setValue(PREF_SHORTCUTS, (Serializable)((Object)shortcuts));
                }
                catch (Exception err) {
                    Utils.addErrorMessage(MessageFormat.format(Application.getMessage(FacesContext.getCurrentInstance(), "error_generic"), err.getMessage()), err);
                }
            }
        }
        return this.shortcuts;
    }

    public void setShortcuts(List<Node> nodes) {
        this.shortcuts = nodes;
    }

    public void createShortcut(ActionEvent event) {
        block10: {
            UIActionLink link = (UIActionLink)event.getComponent();
            Map<String, String> params = link.getParameterMap();
            String id = params.get("id");
            if (id != null && id.length() != 0) {
                try {
                    NodeRef ref = new NodeRef(Repository.getStoreRef(), id);
                    Node node = new Node(ref);
                    boolean foundShortcut = false;
                    for (int i = 0; i < this.getShortcuts().size(); ++i) {
                        if (!node.getId().equals(this.getShortcuts().get(i).getId())) continue;
                        foundShortcut = true;
                        break;
                    }
                    if (foundShortcut) break block10;
                    UserTransaction tx = null;
                    try {
                        FacesContext context = FacesContext.getCurrentInstance();
                        tx = Repository.getUserTransaction(context);
                        tx.begin();
                        List<String> shortcuts = UserShortcutsBean.getShortcutList(context);
                        shortcuts.add(node.getNodeRef().getId());
                        PreferencesService.getPreferences(context).setValue(PREF_SHORTCUTS, (Serializable)((Object)shortcuts));
                        tx.commit();
                        this.getShortcuts().add(node);
                        if (logger.isDebugEnabled()) {
                            logger.debug((Object)("Added node: " + node.getName() + " to the user shortcuts list."));
                        }
                    }
                    catch (Throwable err) {
                        Utils.addErrorMessage(MessageFormat.format(Application.getMessage(FacesContext.getCurrentInstance(), "error_generic"), err.getMessage()), err);
                        try {
                            if (tx != null) {
                                tx.rollback();
                            }
                        }
                        catch (Exception tex) {}
                    }
                }
                catch (InvalidNodeRefException refErr) {
                    Utils.addErrorMessage(MessageFormat.format(Application.getMessage(FacesContext.getCurrentInstance(), "error_noderef"), id));
                }
            }
        }
    }

    public void removeShortcut(ActionEvent event) {
        UIShortcutsShelfItem.ShortcutEvent shortcutEvent = (UIShortcutsShelfItem.ShortcutEvent)event;
        UserTransaction tx = null;
        try {
            FacesContext context = FacesContext.getCurrentInstance();
            tx = Repository.getUserTransaction(context);
            tx.begin();
            List<String> shortcuts = UserShortcutsBean.getShortcutList(context);
            if (shortcuts.size() > shortcutEvent.Index) {
                shortcuts.remove(shortcutEvent.Index);
                PreferencesService.getPreferences(context).setValue(PREF_SHORTCUTS, (Serializable)((Object)shortcuts));
                tx.commit();
                Node node = this.getShortcuts().remove(shortcutEvent.Index);
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("Removed node: " + node.getName() + " from the user shortcuts list."));
                }
            }
        }
        catch (Throwable err) {
            Utils.addErrorMessage(MessageFormat.format(Application.getMessage(FacesContext.getCurrentInstance(), "error_generic"), err.getMessage()), err);
            try {
                if (tx != null) {
                    tx.rollback();
                }
            }
            catch (Exception tex) {
                // empty catch block
            }
        }
    }

    private static List<String> getShortcutList(FacesContext context) {
        ArrayList<String> shortcuts = null;
        Serializable prefValue = PreferencesService.getPreferences(context).getValue(PREF_SHORTCUTS);
        if (prefValue instanceof List) {
            shortcuts = (ArrayList<String>)prefValue;
        } else if (prefValue instanceof String) {
            shortcuts = new ArrayList<String>(1);
            shortcuts.add((String)((Object)prefValue));
        }
        if (shortcuts == null || shortcuts.size() == 0) {
            shortcuts = new ArrayList(1);
        }
        return shortcuts;
    }

    public void click(ActionEvent event) {
        UIShortcutsShelfItem.ShortcutEvent shortcutEvent = (UIShortcutsShelfItem.ShortcutEvent)event;
        Node selectedNode = this.getShortcuts().get(shortcutEvent.Index);
        try {
            if (this.getPermissionService().hasPermission(selectedNode.getNodeRef(), "Read") == AccessStatus.ALLOWED) {
                if (!this.getNodeService().exists(selectedNode.getNodeRef())) {
                    throw new InvalidNodeRefException(selectedNode.getNodeRef());
                }
                DictionaryService dd = Repository.getServiceRegistry(FacesContext.getCurrentInstance()).getDictionaryService();
                if (dd.isSubClass(selectedNode.getType(), ContentModel.TYPE_FOLDER)) {
                    this.browseBean.updateUILocation(selectedNode.getNodeRef());
                } else if (dd.isSubClass(selectedNode.getType(), ContentModel.TYPE_CONTENT)) {
                    this.browseBean.setupContentAction(selectedNode.getId(), true);
                    FacesContext fc = FacesContext.getCurrentInstance();
                    fc.getApplication().getNavigationHandler().handleNavigation(fc, null, "dialog:showDocDetails");
                }
            } else {
                Utils.addErrorMessage(Application.getMessage(FacesContext.getCurrentInstance(), "error_shortcut_permissions"));
            }
        }
        catch (InvalidNodeRefException refErr) {
            Utils.addErrorMessage(MessageFormat.format(Application.getMessage(FacesContext.getCurrentInstance(), "error_noderef"), selectedNode.getId()));
            UserTransaction tx = null;
            try {
                FacesContext context = FacesContext.getCurrentInstance();
                tx = Repository.getUserTransaction(context);
                tx.begin();
                List<String> shortcuts = UserShortcutsBean.getShortcutList(context);
                if (shortcuts.size() > shortcutEvent.Index) {
                    shortcuts.remove(shortcutEvent.Index);
                    PreferencesService.getPreferences(context).setValue(PREF_SHORTCUTS, (Serializable)((Object)shortcuts));
                    tx.commit();
                    Node node = this.getShortcuts().remove(shortcutEvent.Index);
                    if (logger.isDebugEnabled()) {
                        logger.debug((Object)("Removed deleted node: " + node.getName() + " from the user shortcuts list."));
                    }
                }
            }
            catch (Throwable err) {
                try {
                    if (tx != null) {
                        tx.rollback();
                    }
                }
                catch (Exception tex) {
                    // empty catch block
                }
            }
        }
    }
}

