/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.web.bean.wcm;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.StringTokenizer;
import javax.faces.context.FacesContext;
import org.alfresco.error.AlfrescoRuntimeException;
import org.alfresco.model.WCMAppModel;
import org.alfresco.service.cmr.avm.AVMNodeDescriptor;
import org.alfresco.service.cmr.avm.AVMService;
import org.alfresco.service.cmr.avmsync.AVMSyncService;
import org.alfresco.service.cmr.repository.ContentReader;
import org.alfresco.service.cmr.repository.ContentService;
import org.alfresco.service.cmr.repository.ContentWriter;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.workflow.WorkflowDefinition;
import org.alfresco.service.cmr.workflow.WorkflowService;
import org.alfresco.service.cmr.workflow.WorkflowTask;
import org.alfresco.wcm.util.WCMUtil;
import org.alfresco.wcm.util.WCMWorkflowUtil;
import org.alfresco.web.app.Application;
import org.alfresco.web.bean.repository.Repository;
import org.alfresco.web.bean.workflow.WorkflowUtil;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.extensions.config.ConfigElement;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AVMWorkflowUtil
extends WorkflowUtil {
    private static final Log logger = LogFactory.getLog(AVMWorkflowUtil.class);
    private static final String PATH_CACHE = "_alf_sandbox_path_cache";
    private static List<WorkflowDefinition> configuredWorkflowDefs = null;

    public static void serializeWorkflowParams(Serializable params, NodeRef workflowRef) {
        try {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            ObjectOutputStream oos = new ObjectOutputStream(baos);
            oos.writeObject(params);
            oos.close();
            ContentService cs = Repository.getServiceRegistry(FacesContext.getCurrentInstance()).getContentService();
            ContentWriter writer = cs.getWriter(workflowRef, WCMAppModel.PROP_WORKFLOW_DEFAULT_PROPERTIES, true);
            writer.setMimetype("application/octet-stream");
            writer.putContent((InputStream)new ByteArrayInputStream(baos.toByteArray()));
        }
        catch (IOException ioerr) {
            throw new AlfrescoRuntimeException("Unable to serialize workflow default parameters: " + ioerr.getMessage());
        }
    }

    public static Serializable deserializeWorkflowParams(NodeRef workflowRef) {
        try {
            Serializable params = null;
            ContentService cs = Repository.getServiceRegistry(FacesContext.getCurrentInstance()).getContentService();
            ContentReader reader = cs.getReader(workflowRef, WCMAppModel.PROP_WORKFLOW_DEFAULT_PROPERTIES);
            if (reader != null) {
                ObjectInputStream ois = new ObjectInputStream(reader.getContentInputStream());
                params = (Serializable)ois.readObject();
                ois.close();
            }
            return params;
        }
        catch (IOException ioErr) {
            throw new AlfrescoRuntimeException("Unable to deserialize workflow default parameters: " + ioErr.getMessage());
        }
        catch (ClassNotFoundException classErr) {
            throw new AlfrescoRuntimeException("Unable to deserialize workflow default parameters: " + classErr.getMessage());
        }
    }

    public static List<WorkflowDefinition> getConfiguredWorkflows() {
        if (configuredWorkflowDefs == null || Application.isDynamicConfig(FacesContext.getCurrentInstance())) {
            FacesContext fc = FacesContext.getCurrentInstance();
            List defs = Collections.emptyList();
            ConfigElement config = Application.getConfigService(fc).getGlobalConfig().getConfigElement("wcm");
            if (config == null) {
                logger.warn((Object)"WARNING: Unable to find 'wcm' config element definition.");
            } else {
                ConfigElement workflowConfig = config.getChild("workflows");
                if (workflowConfig == null) {
                    logger.warn((Object)"WARNING: Unable to find WCM 'workflows' config element definition.");
                } else {
                    WorkflowService service = Repository.getServiceRegistry(fc).getWorkflowService();
                    StringTokenizer t = new StringTokenizer(workflowConfig.getValue().trim(), ", ");
                    defs = new ArrayList(t.countTokens());
                    while (t.hasMoreTokens()) {
                        String wfName = t.nextToken();
                        WorkflowDefinition def = service.getDefinitionByName("jbpm$" + wfName);
                        if (def != null) {
                            defs.add(def);
                            continue;
                        }
                        logger.warn((Object)("WARNING: Cannot find WCM workflow def for configured definition name: " + wfName));
                    }
                }
            }
            configuredWorkflowDefs = defs;
        }
        return configuredWorkflowDefs;
    }

    public static List<WorkflowTask> getAssociatedTasksForSandbox(String storeName) {
        FacesContext fc = FacesContext.getCurrentInstance();
        WorkflowService workflowService = Repository.getServiceRegistry(fc).getWorkflowService();
        return WCMWorkflowUtil.getAssociatedTasksForSandbox((WorkflowService)workflowService, (String)storeName);
    }

    public static List<WorkflowTask> getAssociatedTasksForNode(AVMNodeDescriptor node, List<WorkflowTask> tasks) {
        FacesContext fc = FacesContext.getCurrentInstance();
        AVMService avmService = Repository.getServiceRegistry(fc).getAVMService();
        return WCMWorkflowUtil.getAssociatedTasksForNode((AVMService)avmService, (AVMNodeDescriptor)node, tasks);
    }

    public static boolean isInActiveWorkflow(String sandbox, AVMNodeDescriptor node) {
        return AVMWorkflowUtil.isInActiveWorkflow(sandbox, WCMUtil.getStoreRelativePath((String)node.getPath()));
    }

    public static boolean isInActiveWorkflow(String sandbox, String relativePath) {
        List<String> cachedPaths = AVMWorkflowUtil.getAssociatedPathsForSandbox(sandbox);
        return cachedPaths.contains(relativePath);
    }

    private static List<String> getAssociatedPathsForSandbox(String sandbox) {
        List cachedPaths;
        FacesContext fc = FacesContext.getCurrentInstance();
        AVMSyncService avmSyncService = Repository.getServiceRegistry(fc).getAVMSyncService();
        WorkflowService workflowService = Repository.getServiceRegistry(fc).getWorkflowService();
        HashMap<String, List> cachedSandboxPaths = (HashMap<String, List>)fc.getExternalContext().getRequestMap().get(PATH_CACHE);
        if (cachedSandboxPaths == null) {
            cachedSandboxPaths = new HashMap<String, List>(64, 1.0f);
            fc.getExternalContext().getRequestMap().put(PATH_CACHE, cachedSandboxPaths);
        }
        if ((cachedPaths = (List)cachedSandboxPaths.get(sandbox)) == null) {
            cachedPaths = WCMWorkflowUtil.getAssociatedPathsForSandbox((AVMSyncService)avmSyncService, (WorkflowService)workflowService, (String)sandbox);
            cachedSandboxPaths.put(sandbox, cachedPaths);
        }
        return cachedPaths;
    }
}

