/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.web.bean.wcm;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import javax.faces.context.FacesContext;
import javax.faces.event.ActionEvent;
import javax.faces.model.SelectItem;
import org.alfresco.web.app.Application;
import org.alfresco.web.bean.wcm.AVMUtil;
import org.alfresco.web.bean.wcm.CompareSnapshotDialog;
import org.alfresco.web.bean.wcm.WCMCompareUtils;
import org.alfresco.web.ui.common.Utils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CompareToAnySnapshotDialog
extends CompareSnapshotDialog {
    private static final long serialVersionUID = 5483432383286687197L;
    private static final String COMPARE_TO_ANY_SNAPSHOT_DESCRIPTION_MESSAGE_TEXT_ID = "snapshot_compare_to_any_description";
    public static final String MSG_ERROR_VERSION_NOT_VALID = "error_version_validate";
    private int userSpecifiedVersion;
    private boolean storeChanged;
    private String userSpecifiedStore;
    private String userSpecifiedRoot;
    private List<Integer> availableVersionNumbers;
    private int curAvailableVersionNumber;
    private boolean compare;

    private void buildAvailableVersionNumbers() {
        this.curAvailableVersionNumber = -1;
        this.availableVersionNumbers = WCMCompareUtils.getAllVersionID(this.getSandboxService(), this.userSpecifiedStore);
        Collections.sort(this.availableVersionNumbers);
    }

    @Override
    public void init(Map<String, String> parameters) {
        super.init(parameters);
        this.userSpecifiedStore = this.sandbox;
        this.userSpecifiedRoot = this.storeRoot;
        this.userSpecifiedVersion = -1;
        this.buildAvailableVersionNumbers();
        this.compare = true;
        this.storeChanged = false;
    }

    private boolean isCorrectVersion(int userSpecVersion) {
        return userSpecVersion == -1 || this.availableVersionNumbers.contains(userSpecVersion);
    }

    @Override
    public List<Map<String, String>> getComparedNodes() {
        if (this.compare) {
            this.compare = false;
            List<Map<String, String>> nodes = null;
            if (this.isCorrectVersion(this.userSpecifiedVersion)) {
                nodes = WCMCompareUtils.getComparedNodes(this.getAvmSyncService(), this.version, this.storeRoot, this.userSpecifiedVersion, this.userSpecifiedRoot, null);
            }
            return nodes;
        }
        return Collections.emptyList();
    }

    public List<SelectItem> getStoresList() {
        List<String> stores = WCMCompareUtils.receiveStoresList(this.getAvmService());
        ArrayList<SelectItem> result = new ArrayList<SelectItem>();
        for (String itemValue : stores) {
            result.add(new SelectItem((Object)itemValue, itemValue, itemValue, false));
        }
        return result;
    }

    public void refreshComparePanel(ActionEvent event) {
        this.compare = true;
    }

    public int getUserSpecifiedVersion() {
        return this.userSpecifiedVersion;
    }

    public void setUserSpecifiedVersion(int userSpecifiedVersion) {
        if (!this.storeChanged) {
            if (this.userSpecifiedVersion != userSpecifiedVersion) {
                if (userSpecifiedVersion != -1) {
                    int index = this.availableVersionNumbers.indexOf(userSpecifiedVersion);
                    if (index != -1) {
                        this.curAvailableVersionNumber = index;
                        this.userSpecifiedVersion = userSpecifiedVersion;
                    } else {
                        Utils.addErrorMessage(Application.getMessage(FacesContext.getCurrentInstance(), MSG_ERROR_VERSION_NOT_VALID));
                        FacesContext.getCurrentInstance().renderResponse();
                    }
                } else {
                    this.curAvailableVersionNumber = -1;
                    this.userSpecifiedVersion = -1;
                }
            }
        } else {
            this.storeChanged = false;
        }
    }

    public String getUserSpecifiedSnapshot() {
        return this.userSpecifiedStore;
    }

    public void setUserSpecifiedSnapshot(String userSpecifiedSnapshot) {
        if (!userSpecifiedSnapshot.equals(this.userSpecifiedStore)) {
            this.storeChanged = true;
            this.userSpecifiedStore = userSpecifiedSnapshot;
            this.userSpecifiedRoot = AVMUtil.buildSandboxRootPath(this.userSpecifiedStore);
            this.userSpecifiedVersion = -1;
            this.buildAvailableVersionNumbers();
        }
    }

    @Override
    public String getSandbox() {
        return this.userSpecifiedStore;
    }

    @Override
    protected String getDescription() {
        return COMPARE_TO_ANY_SNAPSHOT_DESCRIPTION_MESSAGE_TEXT_ID;
    }

    public boolean isIncrementVersionButtonDisabled() {
        return this.curAvailableVersionNumber + 1 == this.availableVersionNumbers.size();
    }

    public boolean isDecrementVersionButtonDisabled() {
        return this.curAvailableVersionNumber == -1;
    }

    public void incrementVersion(ActionEvent event) {
        ++this.curAvailableVersionNumber;
        this.userSpecifiedVersion = this.availableVersionNumbers.get(this.curAvailableVersionNumber);
    }

    public void decrementVersion(ActionEvent event) {
        --this.curAvailableVersionNumber;
        this.userSpecifiedVersion = this.curAvailableVersionNumber != -1 ? this.availableVersionNumbers.get(this.curAvailableVersionNumber) : -1;
    }
}

