/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.web.bean.wcm;

import java.util.Map;
import javax.faces.context.FacesContext;
import org.alfresco.repo.avm.AVMNodeConverter;
import org.alfresco.repo.web.scripts.FileTypeImageUtils;
import org.alfresco.service.cmr.avm.AVMService;
import org.alfresco.web.app.Application;
import org.alfresco.web.app.servlet.DownloadContentServlet;
import org.alfresco.web.bean.dialog.BaseDialogBean;
import org.alfresco.web.bean.repository.Repository;
import org.alfresco.web.bean.wcm.AVMBrowseBean;
import org.alfresco.web.bean.wcm.AVMNode;
import org.alfresco.web.bean.wcm.AVMUtil;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EditAvmFileDialog
extends BaseDialogBean {
    private static final long serialVersionUID = 3099172372971422442L;
    private static final Log LOGGER = LogFactory.getLog(EditAvmFileDialog.class);
    private transient AVMService avmService;
    protected AVMBrowseBean avmBrowseBean;

    public void setAvmService(AVMService avmService) {
        this.avmService = avmService;
    }

    protected AVMService getAvmService() {
        if (this.avmService == null) {
            this.avmService = Repository.getServiceRegistry(FacesContext.getCurrentInstance()).getAVMService();
        }
        return this.avmService;
    }

    public void setAvmBrowseBean(AVMBrowseBean avmBrowseBean) {
        this.avmBrowseBean = avmBrowseBean;
    }

    public AVMNode getAvmNode() {
        return this.avmBrowseBean.getAvmActionNode();
    }

    public String getFileType32() {
        return FileTypeImageUtils.getFileTypeImage((String)this.getAvmNode().getName(), (boolean)false);
    }

    public String getUrl() {
        return DownloadContentServlet.generateDownloadURL(AVMNodeConverter.ToNodeRef((int)-1, (String)this.getAvmNode().getPath()), this.getAvmNode().getName());
    }

    @Override
    public void init(Map<String, String> parameters) {
        super.init(parameters);
    }

    @Override
    protected String finishImpl(FacesContext context, String outcome) throws Exception {
        AVMNode node = this.getAvmNode();
        if (node != null) {
            AVMUtil.updateVServerWebapp(node.getPath(), false);
            outcome = "dialog:close";
        }
        return outcome;
    }

    @Override
    public String getContainerTitle() {
        return this.getAvmNode().getName();
    }

    @Override
    public String getCancelButtonLabel() {
        return Application.getMessage(FacesContext.getCurrentInstance(), "close");
    }
}

