/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.web.bean.wcm;

import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.io.Writer;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import javax.faces.context.ExternalContext;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import javax.servlet.http.HttpServletRequest;
import org.alfresco.error.AlfrescoRuntimeException;
import org.alfresco.model.ContentModel;
import org.alfresco.model.WCMModel;
import org.alfresco.repo.avm.AVMNodeConverter;
import org.alfresco.repo.domain.PropertyValue;
import org.alfresco.repo.search.SearcherException;
import org.alfresco.repo.security.permissions.AccessDeniedException;
import org.alfresco.repo.web.scripts.FileTypeImageUtils;
import org.alfresco.service.cmr.avm.AVMNodeDescriptor;
import org.alfresco.service.cmr.avm.AVMService;
import org.alfresco.service.cmr.dictionary.DataTypeDefinition;
import org.alfresco.service.cmr.dictionary.DictionaryService;
import org.alfresco.service.cmr.repository.ChildAssociationRef;
import org.alfresco.service.cmr.repository.ContentReader;
import org.alfresco.service.cmr.repository.ContentService;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.NodeService;
import org.alfresco.service.cmr.repository.StoreRef;
import org.alfresco.service.cmr.search.ResultSet;
import org.alfresco.service.cmr.search.ResultSetRow;
import org.alfresco.service.cmr.search.SearchService;
import org.alfresco.service.namespace.NamespacePrefixResolver;
import org.alfresco.service.namespace.NamespaceService;
import org.alfresco.service.namespace.QName;
import org.alfresco.service.namespace.QNamePattern;
import org.alfresco.service.namespace.RegexQNamePattern;
import org.alfresco.util.Pair;
import org.alfresco.web.app.Application;
import org.alfresco.web.app.servlet.ajax.InvokeCommand;
import org.alfresco.web.bean.FileUploadBean;
import org.alfresco.web.bean.repository.Node;
import org.alfresco.web.bean.repository.Repository;
import org.alfresco.web.bean.wcm.AVMBrowseBean;
import org.alfresco.web.bean.wcm.AVMNode;
import org.alfresco.web.bean.wcm.AVMUtil;
import org.alfresco.web.bean.wcm.WebProject;
import org.alfresco.web.forms.XMLUtil;
import org.apache.commons.fileupload.FileItem;
import org.apache.commons.fileupload.FileItemFactory;
import org.apache.commons.fileupload.disk.DiskFileItemFactory;
import org.apache.commons.fileupload.servlet.ServletFileUpload;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.DocumentHelper;
import org.dom4j.XPath;
import org.dom4j.io.SAXReader;
import org.springframework.util.FileCopyUtils;
import org.w3c.dom.Element;
import org.w3c.dom.Text;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FilePickerBean
implements Serializable {
    private static final Log LOGGER = LogFactory.getLog(FilePickerBean.class);
    private static final String CONFIGURED_SEARCH_QUERY_XPATH = "/search/query";
    private static final String CDATA_START_DELIM = "![CDATA[";
    private static final String CDATA_END_DELIM = "]]";
    private static final String PARAM_FOLDER_RESTRICTION = "folderRestriction";
    private static final String PARAM_CONFIGURED_SEARCH_NAME = "configSearchName";
    private static final String PARAM_SELECTABLE_TYPES = "selectableTypes";
    private static final String PARAM_FILTER_MIME_TYPES = "filterMimetypes";
    private static final String PARAM_CURRENT_PATH = "currentPath";
    private final Set<NodeRef> uploads = new HashSet<NodeRef>();
    private AVMBrowseBean avmBrowseBean;
    private transient AVMService avmService;
    private transient NamespaceService namespaceService;
    private transient SearchService searchService;
    private transient NodeService nodeService;
    private transient DictionaryService dictionaryService;
    private transient ContentService contentService;
    private NodeRef publicSearchesRef = null;

    public void clearUploadedFiles() {
        this.uploads.clear();
    }

    public NodeRef[] getUploadedFiles() {
        return this.uploads.toArray(new NodeRef[this.uploads.size()]);
    }

    public void setAvmBrowseBean(AVMBrowseBean avmBrowseBean) {
        this.avmBrowseBean = avmBrowseBean;
    }

    public AVMBrowseBean getAvmBrowseBean() {
        return this.avmBrowseBean;
    }

    public void setAvmService(AVMService avmService) {
        this.avmService = avmService;
    }

    public AVMService getAvmService() {
        if (this.avmService == null) {
            this.avmService = Repository.getServiceRegistry(FacesContext.getCurrentInstance()).getAVMService();
        }
        return this.avmService;
    }

    public void setNodeService(NodeService nodeService) {
        this.nodeService = nodeService;
    }

    public NodeService getNodeService() {
        if (this.nodeService == null) {
            this.nodeService = Repository.getServiceRegistry(FacesContext.getCurrentInstance()).getNodeService();
        }
        return this.nodeService;
    }

    public void setSearchService(SearchService searchService) {
        this.searchService = searchService;
    }

    public SearchService getSearchService() {
        if (this.searchService == null) {
            this.searchService = Repository.getServiceRegistry(FacesContext.getCurrentInstance()).getSearchService();
        }
        return this.searchService;
    }

    public void setDictionaryService(DictionaryService dictionaryService) {
        this.dictionaryService = dictionaryService;
    }

    public DictionaryService getDictionaryService() {
        if (this.dictionaryService == null) {
            this.dictionaryService = Repository.getServiceRegistry(FacesContext.getCurrentInstance()).getDictionaryService();
        }
        return this.dictionaryService;
    }

    public void setNamespaceService(NamespaceService namespaceService) {
        this.namespaceService = namespaceService;
    }

    public NamespaceService getNamespaceService() {
        if (this.namespaceService == null) {
            this.namespaceService = Repository.getServiceRegistry(FacesContext.getCurrentInstance()).getNamespaceService();
        }
        return this.namespaceService;
    }

    public void setContentService(ContentService contentService) {
        this.contentService = contentService;
    }

    public ContentService getContentService() {
        if (this.contentService == null) {
            this.contentService = Repository.getServiceRegistry(FacesContext.getCurrentInstance()).getContentService();
        }
        return this.contentService;
    }

    @InvokeCommand.ResponseMimetype(value="text/xml")
    public void getFilePickerData() throws Exception {
        FacesContext facesContext = FacesContext.getCurrentInstance();
        ExternalContext externalContext = facesContext.getExternalContext();
        String configSearchName = null;
        String[] configSearchNameParam = (String[])externalContext.getRequestParameterValuesMap().get(PARAM_CONFIGURED_SEARCH_NAME);
        if (configSearchNameParam != null && configSearchNameParam.length != 0) {
            configSearchName = configSearchNameParam[0];
        }
        Object[] selectableTypes = this.getSelectableTypes((String[])externalContext.getRequestParameterValuesMap().get(PARAM_SELECTABLE_TYPES));
        Object[] filterMimetypes = this.getFilterMimetypes((String[])externalContext.getRequestParameterValuesMap().get(PARAM_FILTER_MIME_TYPES));
        String folderPathRestriction = null;
        String[] folderPathRestrictionParam = (String[])externalContext.getRequestParameterValuesMap().get(PARAM_FOLDER_RESTRICTION);
        if (folderPathRestrictionParam != null && folderPathRestrictionParam.length != 0 && ((folderPathRestriction = folderPathRestrictionParam[0]).charAt(0) == '/' || folderPathRestriction.charAt(0) == '\\')) {
            folderPathRestriction = folderPathRestriction.substring(1);
        }
        String currentPath = null;
        String currentPathReqParam = (String)externalContext.getRequestParameterMap().get(PARAM_CURRENT_PATH);
        if (currentPathReqParam == null) {
            currentPath = this.getCurrentAVMPath();
        } else {
            String previewStorePath = AVMUtil.getCorrespondingPathInPreviewStore(this.getCurrentAVMPath());
            currentPath = AVMUtil.buildPath(previewStorePath, currentPathReqParam, AVMUtil.PathRelation.WEBAPP_RELATIVE);
        }
        if (folderPathRestriction != null && folderPathRestriction.length() != 0) {
            currentPath = AVMUtil.getWebappPath(currentPath) + "/" + folderPathRestriction;
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)(this + ".getFilePickerData(path = " + currentPath + ", folderRestriction = " + folderPathRestriction + ", selectableTypes = [" + StringUtils.join((Object[])selectableTypes, (String)",") + "], filterMimetypes = [" + StringUtils.join((Object[])filterMimetypes, (String)",") + "])"));
        }
        org.w3c.dom.Document filePickerDataDoc = XMLUtil.newDocument();
        Element filePickerDataElement = filePickerDataDoc.createElement("file-picker-data");
        filePickerDataDoc.appendChild(filePickerDataElement);
        AVMNodeDescriptor currentNode = this.getAvmService().lookup(-1, currentPath);
        if (currentNode == null) {
            currentPath = AVMUtil.getWebappRelativePath(currentPath);
            filePickerDataElement.setAttribute("error", MessageFormat.format(Application.getMessage(facesContext, "error_not_found"), "'" + currentPath.substring(currentPath.lastIndexOf("/") + 1, currentPath.length()) + "'", currentPath.lastIndexOf("/") == 0 ? "/" : currentPath.substring(0, currentPath.lastIndexOf("/"))));
            currentPath = folderPathRestriction != null && folderPathRestriction.length() != 0 ? null : this.getCurrentAVMPath();
        } else if (!currentNode.isDirectory()) {
            currentPath = AVMNodeConverter.SplitBase((String)currentPath)[0];
        }
        Element currentNodeElement = filePickerDataDoc.createElement("current-node");
        if (currentPath == null) {
            currentNodeElement.setAttribute("avmPath", "");
            currentNodeElement.setAttribute("webappRelativePath", "");
        } else {
            currentNodeElement.setAttribute("avmPath", currentPath);
            currentNodeElement.setAttribute("webappRelativePath", AVMUtil.getWebappRelativePath(currentPath));
        }
        currentNodeElement.setAttribute("type", "directory");
        currentNodeElement.setAttribute("image", "/images/icons/space_small.gif");
        filePickerDataElement.appendChild(currentNodeElement);
        if (configSearchName != null && configSearchName.length() != 0) {
            NodeRef configuredSearchNodeRef = this.getConfiguredSearches(configSearchName);
            if (configuredSearchNodeRef == null) {
                filePickerDataElement.setAttribute("error", MessageFormat.format(Application.getMessage(facesContext, "error_search_not_exist"), configSearchName));
            } else {
                try {
                    this.addSearchResultNodes(filePickerDataDoc, filePickerDataElement, configuredSearchNodeRef, (QName[])selectableTypes, facesContext);
                }
                catch (SearcherException e) {
                    filePickerDataElement.setAttribute("error", MessageFormat.format(Application.getMessage(facesContext, "error_retrieving_search_results"), configSearchName, e.getMessage()));
                }
            }
        } else if (currentPath != null) {
            this.addPathChildNodesToElement(filePickerDataDoc, filePickerDataElement, currentPath, (QName[])selectableTypes, (Pattern[])filterMimetypes, facesContext);
        }
        ResponseWriter out = facesContext.getResponseWriter();
        XMLUtil.print((org.w3c.dom.Node)filePickerDataDoc, (Writer)out);
    }

    @InvokeCommand.ResponseMimetype(value="text/html")
    public void uploadFile() throws Exception {
        LOGGER.debug((Object)(this + ".uploadFile()"));
        FacesContext facesContext = FacesContext.getCurrentInstance();
        ExternalContext externalContext = facesContext.getExternalContext();
        HttpServletRequest request = (HttpServletRequest)externalContext.getRequest();
        ServletFileUpload upload = new ServletFileUpload((FileItemFactory)new DiskFileItemFactory());
        upload.setHeaderEncoding("UTF-8");
        List fileItems = upload.parseRequest(request);
        FileUploadBean bean = new FileUploadBean();
        String uploadId = null;
        String currentPath = null;
        String filename = null;
        String returnPage = null;
        InputStream fileInputStream = null;
        for (FileItem item : fileItems) {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug((Object)("item = " + item));
            }
            if (item.isFormField() && item.getFieldName().equals("upload-id")) {
                uploadId = item.getString();
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug((Object)("uploadId is " + uploadId));
                }
            }
            if (item.isFormField() && item.getFieldName().equals("return-page")) {
                returnPage = item.getString();
                if (!LOGGER.isDebugEnabled()) continue;
                LOGGER.debug((Object)("returnPage is " + returnPage));
                continue;
            }
            if (item.isFormField() && item.getFieldName().equals(PARAM_CURRENT_PATH)) {
                String previewStorePath = AVMUtil.getCorrespondingPathInPreviewStore(this.getCurrentAVMPath());
                currentPath = AVMUtil.buildPath(previewStorePath, item.getString(), AVMUtil.PathRelation.WEBAPP_RELATIVE);
                if (!LOGGER.isDebugEnabled()) continue;
                LOGGER.debug((Object)("currentPath is " + currentPath));
                continue;
            }
            filename = FilenameUtils.getName((String)item.getName());
            fileInputStream = item.getInputStream();
            if (!LOGGER.isDebugEnabled()) continue;
            LOGGER.debug((Object)("uploading file " + filename));
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)("saving file " + filename + " to " + currentPath));
        }
        try {
            FileCopyUtils.copy(fileInputStream, (OutputStream)this.getAvmService().createFile(currentPath, filename));
            HashMap<QName, PropertyValue> props = new HashMap<QName, PropertyValue>(1, 1.0f);
            props.put(ContentModel.PROP_TITLE, new PropertyValue(DataTypeDefinition.TEXT, (Serializable)((Object)filename)));
            this.getAvmService().setNodeProperties(currentPath + "/" + filename, props);
            this.getAvmService().addAspect(currentPath + "/" + filename, ContentModel.ASPECT_TITLED);
            this.uploads.add(AVMNodeConverter.ToNodeRef((int)-1, (String)(currentPath + "/" + filename)));
            returnPage = returnPage.replace("${_FILE_TYPE_IMAGE}", FileTypeImageUtils.getFileTypeImage((FacesContext)facesContext, (String)filename, (boolean)true));
        }
        catch (Exception e) {
            LOGGER.debug((Object)e.getMessage(), (Throwable)e);
            returnPage = returnPage.replace("${_UPLOAD_ERROR}", e.getMessage());
        }
        LOGGER.debug((Object)("upload complete.  sending response: " + returnPage));
        org.w3c.dom.Document result = XMLUtil.newDocument();
        Element htmlEl = result.createElement("html");
        result.appendChild(htmlEl);
        Element bodyEl = result.createElement("body");
        htmlEl.appendChild(bodyEl);
        Element scriptEl = result.createElement("script");
        bodyEl.appendChild(scriptEl);
        scriptEl.setAttribute("type", "text/javascript");
        Text scriptText = result.createTextNode(returnPage);
        scriptEl.appendChild(scriptText);
        ResponseWriter out = facesContext.getResponseWriter();
        XMLUtil.print((org.w3c.dom.Node)result, (Writer)out);
    }

    private String getCurrentAVMPath() {
        AVMNode node = this.getAvmBrowseBean().getAvmActionNode();
        if (node == null) {
            return this.getAvmBrowseBean().getCurrentPath();
        }
        String result = node.getPath();
        return node.isDirectory() ? result : AVMNodeConverter.SplitBase((String)result)[0];
    }

    private QName[] getSelectableTypes(String[] selectableTypes) {
        QName[] result;
        QName[] qNameArray;
        if (selectableTypes == null) {
            QName[] qNameArray2 = new QName[2];
            qNameArray2[0] = WCMModel.TYPE_AVM_CONTENT;
            qNameArray = qNameArray2;
            qNameArray2[1] = WCMModel.TYPE_AVM_FOLDER;
        } else {
            qNameArray = result = new QName[selectableTypes.length];
        }
        if (selectableTypes != null) {
            for (int i = 0; i < selectableTypes.length; ++i) {
                result[i] = QName.resolveToQName((NamespacePrefixResolver)this.getNamespaceService(), (String)selectableTypes[i]);
            }
        }
        return result;
    }

    private Pattern[] getFilterMimetypes(String[] filterMimetypes) {
        Pattern[] result;
        Pattern[] patternArray = result = filterMimetypes == null ? new Pattern[]{} : new Pattern[filterMimetypes.length];
        if (filterMimetypes != null) {
            for (int i = 0; i < filterMimetypes.length; ++i) {
                result[i] = Pattern.compile(filterMimetypes[i].replaceAll("\\*", "\\.*").replaceAll("\\/", "\\\\/"));
            }
        }
        return result;
    }

    private void addPathChildNodesToElement(org.w3c.dom.Document doc, Element parent, String path, QName[] selectableTypes, Pattern[] filterMimetypes, FacesContext facesContext) {
        for (Map.Entry entry : this.getAvmService().getDirectoryListing(-1, path).entrySet()) {
            if (!((AVMNodeDescriptor)entry.getValue()).isDirectory() && filterMimetypes.length != 0) {
                String contentMimetype = this.getAvmService().getContentDataForRead((AVMNodeDescriptor)entry.getValue()).getMimetype();
                boolean matched = false;
                for (Pattern p : filterMimetypes) {
                    matched = p.matcher(contentMimetype).matches();
                    if (LOGGER.isDebugEnabled()) {
                        LOGGER.debug((Object)(p + ".matches(" + contentMimetype + ") = " + matched));
                    }
                    if (matched) break;
                }
                if (!matched) continue;
            }
            this.addAVMChildNodeToParentElement(doc, parent, (AVMNodeDescriptor)entry.getValue(), selectableTypes, facesContext);
        }
    }

    private void addSearchResultNodes(org.w3c.dom.Document doc, Element parent, NodeRef configuredSearchNodeRef, QName[] selectableTypes, FacesContext facesContext) {
        List<AVMNodeDescriptor> searchResultNodes = this.runConfiguredSearch(configuredSearchNodeRef);
        if (searchResultNodes == null) {
            throw new SearcherException("No results returned by search query.\nSearch node reference: " + configuredSearchNodeRef);
        }
        for (AVMNodeDescriptor node : searchResultNodes) {
            this.addAVMChildNodeToParentElement(doc, parent, node, selectableTypes, facesContext);
        }
    }

    private List<AVMNodeDescriptor> runConfiguredSearch(NodeRef configSearchNodeRef) {
        WebProject webProject = this.getAvmBrowseBean().getWebProject();
        String storeID = webProject.getStoreId();
        ContentReader contentReader = this.getContentService().getReader(configSearchNodeRef, ContentModel.PROP_CONTENT);
        InputStream queryInpStream = contentReader.getContentInputStream();
        SAXReader reader = new SAXReader();
        Document queryDoc = null;
        try {
            queryDoc = reader.read(queryInpStream);
        }
        catch (DocumentException de) {
            return null;
        }
        String query = null;
        XPath queryXPath = DocumentHelper.createXPath((String)CONFIGURED_SEARCH_QUERY_XPATH);
        List xpathResult = queryXPath.selectNodes((Object)queryDoc);
        if (xpathResult != null && xpathResult.size() != 0) {
            org.dom4j.Element queryElement = (org.dom4j.Element)xpathResult.get(0);
            String queryElemText = queryElement.getText();
            int cdataStartDelimIndex = queryElemText.indexOf(CDATA_START_DELIM);
            int cdataEndDelimIndex = queryElemText.indexOf(CDATA_END_DELIM);
            query = cdataStartDelimIndex > -1 && cdataStartDelimIndex + CDATA_START_DELIM.length() < cdataEndDelimIndex ? queryElemText.substring(cdataStartDelimIndex + CDATA_START_DELIM.length(), cdataEndDelimIndex) : queryElemText;
        }
        ArrayList<AVMNodeDescriptor> resultNodeDescriptors = null;
        if (query != null && query.length() != 0) {
            ResultSet results = null;
            try {
                results = this.getSearchService().query(new StoreRef("avm", storeID), "lucene", query);
                if (results.length() != 0) {
                    resultNodeDescriptors = new ArrayList<AVMNodeDescriptor>();
                    for (int i = 0; i < results.length(); ++i) {
                        ResultSetRow row = results.getRow(i);
                        NodeRef resultNodeRef = row.getNodeRef();
                        Node resultNode = new Node(resultNodeRef);
                        if (!this.getDictionaryService().isSubClass(resultNode.getType(), ContentModel.TYPE_CONTENT)) continue;
                        Pair pair = AVMNodeConverter.ToAVMVersionPath((NodeRef)resultNodeRef);
                        Integer version = (Integer)pair.getFirst();
                        String path = (String)pair.getSecond();
                        resultNodeDescriptors.add(this.getAvmService().lookup(version.intValue(), path));
                    }
                }
            }
            catch (Throwable err) {
                throw new AlfrescoRuntimeException("Failed to execute search: " + query, err);
            }
            finally {
                if (results != null) {
                    results.close();
                }
            }
        }
        return resultNodeDescriptors;
    }

    private NodeRef getPublicSearchesRef() {
        if (this.publicSearchesRef == null) {
            FacesContext fc = FacesContext.getCurrentInstance();
            String xpath = Application.getRootPath(fc) + "/" + Application.getGlossaryFolderName(fc) + "/" + Application.getSavedSearchesFolderName(fc);
            List results = null;
            try {
                results = this.getSearchService().selectNodes(this.getNodeService().getRootNode(Repository.getStoreRef()), xpath, null, (NamespacePrefixResolver)this.getNamespaceService(), false);
            }
            catch (AccessDeniedException err) {
                // empty catch block
            }
            if (results != null && results.size() != 0) {
                this.publicSearchesRef = (NodeRef)results.get(0);
            }
        }
        return this.publicSearchesRef;
    }

    public NodeRef getConfiguredSearches(String configSearchName) {
        NodeRef configSearchNodeRef = null;
        NodeRef publicSearchesFolderRef = this.getPublicSearchesRef();
        List childRefs = this.getNodeService().getChildAssocs(publicSearchesFolderRef, (QNamePattern)ContentModel.ASSOC_CONTAINS, RegexQNamePattern.MATCH_ALL);
        if (childRefs.size() != 0) {
            for (ChildAssociationRef ref : childRefs) {
                String childNodeName;
                NodeRef childNodeRef = ref.getChildRef();
                Node childNode = new Node(childNodeRef);
                if (!this.getDictionaryService().isSubClass(childNode.getType(), ContentModel.TYPE_CONTENT) || !(childNodeName = childNode.getName()).equals(configSearchName)) continue;
                configSearchNodeRef = childNodeRef;
                break;
            }
        }
        return configSearchNodeRef;
    }

    private void addAVMChildNodeToParentElement(org.w3c.dom.Document doc, Element parent, AVMNodeDescriptor node, QName[] selectableTypes, FacesContext facesContext) {
        Element childNodeElement = doc.createElement("child-node");
        childNodeElement.setAttribute("avmPath", node.getPath());
        childNodeElement.setAttribute("webappRelativePath", AVMUtil.getWebappRelativePath(node.getPath()));
        childNodeElement.setAttribute("type", node.isDirectory() ? "directory" : "file");
        childNodeElement.setAttribute("image", node.isDirectory() ? "/images/icons/space_small.gif" : FileTypeImageUtils.getFileTypeImage((FacesContext)facesContext, (String)node.getName(), (boolean)true));
        boolean selectable = false;
        for (QName typeQName : selectableTypes) {
            selectable = selectable || WCMModel.TYPE_AVM_FOLDER.equals((Object)typeQName) && node.isDirectory();
            selectable = selectable || WCMModel.TYPE_AVM_CONTENT.equals((Object)typeQName) && !node.isDirectory();
        }
        childNodeElement.setAttribute("selectable", Boolean.toString(selectable));
        parent.appendChild(childNodeElement);
    }
}

