/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.web.bean.wcm;

import java.io.Serializable;
import java.text.MessageFormat;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import javax.faces.context.FacesContext;
import org.alfresco.error.AlfrescoRuntimeException;
import org.alfresco.service.cmr.repository.AssociationRef;
import org.alfresco.service.cmr.workflow.WorkflowDefinition;
import org.alfresco.service.cmr.workflow.WorkflowService;
import org.alfresco.service.cmr.workflow.WorkflowTaskDefinition;
import org.alfresco.service.namespace.QName;
import org.alfresco.web.app.Application;
import org.alfresco.web.bean.dialog.BaseDialogBean;
import org.alfresco.web.bean.repository.Node;
import org.alfresco.web.bean.repository.Repository;
import org.alfresco.web.bean.repository.TransientNode;
import org.alfresco.web.bean.wcm.CreateWebsiteWizard;
import org.alfresco.web.bean.wcm.WorkflowConfiguration;
import org.alfresco.web.bean.workflow.WorkflowUtil;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FormWorkflowDialog
extends BaseDialogBean {
    private static final long serialVersionUID = -7858470945912453738L;
    private static final String MSG_ERROR_FILENAME_PATTERN = "error_filename_pattern";
    private static final Log logger = LogFactory.getLog(FormWorkflowDialog.class);
    private String filenamePattern;
    private transient WorkflowService workflowService;
    protected CreateWebsiteWizard websiteWizard;
    protected TransientNode workflowNode;

    public void setWorkflowService(WorkflowService workflowService) {
        this.workflowService = workflowService;
    }

    protected WorkflowService getWorkflowService() {
        if (this.workflowService == null) {
            this.workflowService = Repository.getServiceRegistry(FacesContext.getCurrentInstance()).getWorkflowService();
        }
        return this.workflowService;
    }

    public void setCreateWebsiteWizard(CreateWebsiteWizard wizard) {
        this.websiteWizard = wizard;
    }

    public String getFilenamePattern() {
        if (this.filenamePattern == null) {
            this.filenamePattern = this.getActionWorkflow().getFilenamePattern();
        }
        return this.filenamePattern;
    }

    public void setFilenamePattern(String filenamePattern) {
        if (this.filenamePattern != null && this.filenamePattern.length() != 0) {
            this.filenamePattern = filenamePattern;
        }
    }

    @Override
    public void init(Map<String, String> parameters) {
        super.init(parameters);
        this.filenamePattern = null;
        this.workflowNode = null;
        WorkflowConfiguration workflow = this.getActionWorkflow();
        if (workflow == null) {
            throw new IllegalArgumentException("Workflow action context is mandatory.");
        }
        if (workflow.getType() != null) {
            this.workflowNode = new TransientNode(workflow.getType(), "task_" + System.currentTimeMillis(), workflow.getParams());
        } else {
            WorkflowTaskDefinition taskDef;
            WorkflowDefinition flowDef = this.getWorkflowService().getDefinitionByName(workflow.getName());
            if (flowDef != null && (taskDef = flowDef.getStartTaskDefinition()) != null) {
                this.workflowNode = new TransientNode(taskDef.metadata.getName(), "task_" + System.currentTimeMillis(), workflow.getParams());
            }
        }
    }

    @Override
    protected String finishImpl(FacesContext context, String outcome) throws Exception {
        if (this.workflowNode != null) {
            WorkflowConfiguration wf = this.getActionWorkflow();
            Map<QName, Serializable> taskParams = WorkflowUtil.prepareTaskParams(this.workflowNode);
            if (wf.getParams() == null) {
                wf.setParams(taskParams);
            } else {
                Map<QName, Serializable> params = wf.getParams();
                for (QName qname : taskParams.keySet()) {
                    Serializable value = taskParams.get(qname);
                    if (params.get(qname) == null || !(value instanceof List)) {
                        params.put(qname, value);
                        continue;
                    }
                    List current = (List)((Object)params.get(qname));
                    current.addAll((List)((Object)value));
                }
                Map<String, Map<String, AssociationRef>> assocs = this.workflowNode.getRemovedAssociations();
                for (String assocName : assocs.keySet()) {
                    List current;
                    QName assocQName = Repository.resolveToQName(assocName);
                    if (!params.containsKey(assocQName) || (current = (List)((Object)params.get(assocQName))) == null) continue;
                    Map<String, AssociationRef> removedAssocs = assocs.get(assocName);
                    for (AssociationRef assoc : removedAssocs.values()) {
                        current.remove(assoc.getTargetRef());
                    }
                }
                wf.setParams(params);
            }
            wf.setType(this.workflowNode.getType());
            if (this.filenamePattern != null && this.filenamePattern.length() != 0) {
                try {
                    Pattern.compile(this.filenamePattern);
                }
                catch (PatternSyntaxException pax) {
                    throw new AlfrescoRuntimeException(MessageFormat.format(Application.getMessage(FacesContext.getCurrentInstance(), MSG_ERROR_FILENAME_PATTERN), pax.getMessage()), (Throwable)pax);
                }
                wf.setFilenamePattern(this.filenamePattern);
            }
        }
        return outcome;
    }

    @Override
    public boolean getFinishButtonDisabled() {
        return false;
    }

    public WorkflowConfiguration getActionWorkflow() {
        return this.websiteWizard.getActionWorkflow();
    }

    public Node getWorkflowMetadataNode() {
        return this.workflowNode;
    }
}

