/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.web.bean.workflow;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.ResourceBundle;
import javax.faces.context.FacesContext;
import javax.faces.model.SelectItem;
import javax.transaction.UserTransaction;
import org.alfresco.model.ContentModel;
import org.alfresco.repo.search.impl.lucene.LuceneQueryParser;
import org.alfresco.repo.security.authentication.AuthenticationUtil;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.search.LimitBy;
import org.alfresco.service.cmr.search.ResultSet;
import org.alfresco.service.cmr.search.SearchParameters;
import org.alfresco.service.cmr.security.PersonService;
import org.alfresco.service.cmr.workflow.WorkflowService;
import org.alfresco.web.app.Application;
import org.alfresco.web.bean.dialog.BaseDialogBean;
import org.alfresco.web.bean.repository.Repository;
import org.alfresco.web.ui.common.SortableSelectItem;
import org.alfresco.web.ui.common.Utils;

public abstract class BaseReassignDialog
extends BaseDialogBean {
    private static final String MSG_SEARCH_MINIMUM = "picker_search_min";
    private transient WorkflowService workflowService;
    private transient PersonService personService;

    public void setWorkflowService(WorkflowService workflowService) {
        this.workflowService = workflowService;
    }

    protected WorkflowService getWorkflowService() {
        if (this.workflowService == null) {
            this.workflowService = Repository.getServiceRegistry(FacesContext.getCurrentInstance()).getWorkflowService();
        }
        return this.workflowService;
    }

    public void setPersonService(PersonService personService) {
        this.personService = personService;
    }

    protected PersonService getPersonService() {
        if (this.personService == null) {
            this.personService = Repository.getServiceRegistry(FacesContext.getCurrentInstance()).getPersonService();
        }
        return this.personService;
    }

    public SelectItem[] getFilters() {
        ResourceBundle bundle = Application.getBundle(FacesContext.getCurrentInstance());
        return new SelectItem[]{new SelectItem((Object)"0", bundle.getString("users"))};
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SelectItem[] pickerCallback(int filterIndex, String contains) {
        Object[] items;
        FacesContext context = FacesContext.getCurrentInstance();
        String search = contains.trim();
        int searchMin = Application.getClientConfig(context).getPickerSearchMinimum();
        if (search.length() < searchMin) {
            Utils.addErrorMessage(MessageFormat.format(Application.getMessage(context, MSG_SEARCH_MINIMUM), searchMin));
            return new SelectItem[0];
        }
        UserTransaction tx = null;
        ResultSet resultSet = null;
        try {
            tx = Repository.getUserTransaction(context, true);
            tx.begin();
            int maxResults = Application.getClientConfig(context).getInviteUsersMaxResults();
            String term = LuceneQueryParser.escape((String)contains.trim());
            StringBuilder query = new StringBuilder(128);
            Utils.generatePersonSearch(query, term);
            SearchParameters searchParams = new SearchParameters();
            searchParams.addStore(Repository.getStoreRef());
            searchParams.setLanguage("lucene");
            searchParams.setQuery(query.toString());
            if (maxResults > 0) {
                searchParams.setLimit(maxResults);
                searchParams.setLimitBy(LimitBy.FINAL_SIZE);
            }
            resultSet = Repository.getServiceRegistry(context).getSearchService().query(searchParams);
            List nodes = resultSet.getNodeRefs();
            ArrayList<SortableSelectItem> itemList = new ArrayList<SortableSelectItem>(nodes.size());
            for (NodeRef personRef : nodes) {
                String username = (String)((Object)this.getNodeService().getProperty(personRef, ContentModel.PROP_USERNAME));
                if (AuthenticationUtil.getGuestUserName().equals(username)) continue;
                String firstName = (String)((Object)this.getNodeService().getProperty(personRef, ContentModel.PROP_FIRSTNAME));
                String lastName = (String)((Object)this.getNodeService().getProperty(personRef, ContentModel.PROP_LASTNAME));
                SortableSelectItem item = new SortableSelectItem(username, firstName + " " + lastName + " [" + username + "]", lastName);
                itemList.add(item);
            }
            items = new SelectItem[itemList.size()];
            itemList.toArray(items);
            Arrays.sort(items);
            tx.commit();
        }
        catch (Throwable err) {
            Utils.addErrorMessage(MessageFormat.format(Application.getMessage(FacesContext.getCurrentInstance(), "error_generic"), err.getMessage()), err);
            try {
                if (tx != null) {
                    tx.rollback();
                }
            }
            catch (Exception tex) {
                // empty catch block
            }
            items = new SelectItem[]{};
        }
        finally {
            if (resultSet != null) {
                resultSet.close();
            }
        }
        return items;
    }
}

