/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.web.bean.workflow;

import java.text.MessageFormat;
import java.util.Map;
import javax.faces.context.FacesContext;
import org.alfresco.service.cmr.workflow.WorkflowInstance;
import org.alfresco.service.cmr.workflow.WorkflowService;
import org.alfresco.web.app.Application;
import org.alfresco.web.bean.dialog.BaseDialogBean;
import org.alfresco.web.bean.repository.Repository;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CancelWorkflowDialog
extends BaseDialogBean {
    private static final long serialVersionUID = -7875582893750792200L;
    private transient WorkflowInstance workflowInstance;
    private transient WorkflowService workflowService;
    private static final Log logger = LogFactory.getLog(CancelWorkflowDialog.class);

    @Override
    public void init(Map<String, String> parameters) {
        super.init(parameters);
        String workflowInstanceId = (String)this.parameters.get("workflow-instance-id");
        if (workflowInstanceId == null || workflowInstanceId.length() == 0) {
            throw new IllegalArgumentException("Cancel workflow dialog called without workflow instance id");
        }
        this.workflowInstance = this.getWorkflowService().getWorkflowById(workflowInstanceId);
        if (this.workflowInstance == null) {
            throw new IllegalArgumentException("Failed to find workflow instance for id: " + workflowInstanceId);
        }
    }

    @Override
    protected String finishImpl(FacesContext context, String outcome) throws Exception {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Cancelling workflow with id: " + this.getWorkflowInstance().id));
        }
        this.getWorkflowService().cancelWorkflow(this.getWorkflowInstance().id);
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Cancelled workflow with id: " + this.getWorkflowInstance().id));
        }
        return outcome;
    }

    @Override
    protected String getErrorMessageId() {
        return "error_cancel_workflow";
    }

    @Override
    public boolean getFinishButtonDisabled() {
        return false;
    }

    @Override
    public String getCancelButtonLabel() {
        return Application.getMessage(FacesContext.getCurrentInstance(), "no");
    }

    @Override
    public String getFinishButtonLabel() {
        return Application.getMessage(FacesContext.getCurrentInstance(), "yes");
    }

    public String getConfirmMessage() {
        String confirmMsg = Application.getMessage(FacesContext.getCurrentInstance(), "cancel_workflow_confirm");
        String workflowLabel = this.getWorkflowInstance().definition.title;
        if (this.getWorkflowInstance().description != null && this.getWorkflowInstance().description.length() > 0) {
            workflowLabel = workflowLabel + " (" + this.getWorkflowInstance().description + ")";
        }
        return MessageFormat.format(confirmMsg, workflowLabel);
    }

    public WorkflowService getWorkflowService() {
        if (this.workflowService == null) {
            this.workflowService = Repository.getServiceRegistry(FacesContext.getCurrentInstance()).getWorkflowService();
        }
        return this.workflowService;
    }

    public void setWorkflowService(WorkflowService workflowService) {
        this.workflowService = workflowService;
    }

    protected WorkflowInstance getWorkflowInstance() {
        if (this.workflowInstance == null) {
            String workflowInstanceId = (String)this.parameters.get("workflow-instance-id");
            if (workflowInstanceId == null || workflowInstanceId.length() == 0) {
                throw new IllegalArgumentException("Cancel workflow dialog called without workflow instance id");
            }
            this.workflowInstance = this.getWorkflowService().getWorkflowById(workflowInstanceId);
            if (this.workflowInstance == null) {
                throw new IllegalArgumentException("Failed to find workflow instance for id: " + workflowInstanceId);
            }
        }
        return this.workflowInstance;
    }
}

