/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.web.bean.workflow;

import java.util.HashMap;
import java.util.Map;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import org.alfresco.model.ContentModel;
import org.alfresco.service.namespace.QName;
import org.alfresco.web.bean.workflow.BaseReassignDialog;
import org.alfresco.web.ui.common.component.UIGenericPicker;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ReassignTaskDialog
extends BaseReassignDialog {
    private static final long serialVersionUID = 5804171557325189475L;
    protected String taskId;
    private static final Log logger = LogFactory.getLog(ReassignTaskDialog.class);

    @Override
    public void init(Map<String, String> parameters) {
        super.init(parameters);
        this.taskId = (String)this.parameters.get("id");
        if (this.taskId == null || this.taskId.length() == 0) {
            throw new IllegalArgumentException("Reassign task dialog called without task id");
        }
    }

    @Override
    protected String finishImpl(FacesContext context, String outcome) throws Exception {
        UIComponent picker;
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Reassigning task with id: " + this.taskId));
        }
        if ((picker = context.getViewRoot().findComponent("dialog:dialog-body:user-picker")) != null && picker instanceof UIGenericPicker) {
            UIGenericPicker userPicker = (UIGenericPicker)picker;
            String[] user = userPicker.getSelectedResults();
            if (user != null && user.length > 0) {
                String userName = user[0];
                HashMap<QName, String> params = new HashMap<QName, String>(1);
                params.put(ContentModel.PROP_OWNER, userName);
                this.getWorkflowService().updateTask(this.taskId, params, null, null);
            } else if (logger.isWarnEnabled()) {
                logger.warn((Object)"Failed to find selected user, reassign was unsuccessful");
            }
        } else if (logger.isWarnEnabled()) {
            logger.warn((Object)"Failed to find user-picker component, reassign was unsuccessful");
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Reassigning task with id: " + this.taskId));
        }
        return outcome;
    }

    @Override
    protected String getErrorMessageId() {
        return "error_reassign_task";
    }
}

