/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.web.config;

import java.util.ArrayList;
import java.util.Iterator;
import org.alfresco.web.config.AdvancedSearchConfigElement;
import org.dom4j.Element;
import org.springframework.extensions.config.ConfigElement;
import org.springframework.extensions.config.ConfigException;
import org.springframework.extensions.config.xml.elementreader.ConfigElementReader;

public class AdvancedSearchElementReader
implements ConfigElementReader {
    public static final String ELEMENT_CONTENTTYPES = "content-types";
    public static final String ELEMENT_FOLDERTYPES = "folder-types";
    public static final String ELEMENT_TYPE = "type";
    public static final String ELEMENT_CUSTOMPROPS = "custom-properties";
    public static final String ELEMENT_METADATA = "meta-data";
    public static final String ATTRIBUTE_NAME = "name";
    public static final String ATTRIBUTE_TYPE = "type";
    public static final String ATTRIBUTE_PROPERTY = "property";
    public static final String ATTRIBUTE_ASPECT = "aspect";
    public static final String ATTRIBUTE_DISPLAYLABEL = "display-label-id";

    public ConfigElement parse(Element element) {
        AdvancedSearchConfigElement configElement = null;
        if (element != null) {
            Element customProps;
            Element folderTypes;
            String name = element.getName();
            if (!name.equals("advanced-search")) {
                throw new ConfigException("AdvancedSearchElementReader can only parse advanced-search elements, the element passed was '" + name + "'");
            }
            configElement = new AdvancedSearchConfigElement();
            Element contentTypes = element.element(ELEMENT_CONTENTTYPES);
            if (contentTypes != null) {
                Iterator typesItr = contentTypes.elementIterator("type");
                ArrayList<String> types = new ArrayList<String>(5);
                while (typesItr.hasNext()) {
                    Element contentType = (Element)typesItr.next();
                    String type = contentType.attributeValue(ATTRIBUTE_NAME);
                    if (type == null) continue;
                    types.add(type);
                }
                configElement.setContentTypes(types);
            }
            if ((folderTypes = element.element(ELEMENT_FOLDERTYPES)) != null) {
                Iterator typesItr = folderTypes.elementIterator("type");
                ArrayList<String> types = new ArrayList<String>(5);
                while (typesItr.hasNext()) {
                    Element folderType = (Element)typesItr.next();
                    String type = folderType.attributeValue(ATTRIBUTE_NAME);
                    if (type == null) continue;
                    types.add(type);
                }
                configElement.setFolderTypes(types);
            }
            if ((customProps = element.element(ELEMENT_CUSTOMPROPS)) != null) {
                Iterator propsItr = customProps.elementIterator(ELEMENT_METADATA);
                ArrayList<AdvancedSearchConfigElement.CustomProperty> props = new ArrayList<AdvancedSearchConfigElement.CustomProperty>(5);
                while (propsItr.hasNext()) {
                    Element propElement = (Element)propsItr.next();
                    String type = propElement.attributeValue("type");
                    String aspect = propElement.attributeValue(ATTRIBUTE_ASPECT);
                    String prop = propElement.attributeValue(ATTRIBUTE_PROPERTY);
                    String labelId = propElement.attributeValue(ATTRIBUTE_DISPLAYLABEL);
                    props.add(new AdvancedSearchConfigElement.CustomProperty(type, aspect, prop, labelId));
                }
                configElement.setCustomProperties(props);
            }
        }
        return configElement;
    }
}

