/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.web.config;

import java.util.ArrayList;
import java.util.List;
import javax.faces.context.FacesContext;
import org.alfresco.mbeans.VirtServerRegistry;
import org.alfresco.service.namespace.QName;
import org.alfresco.util.ExpiringValueCache;
import org.alfresco.web.bean.repository.Repository;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.extensions.config.ConfigElement;
import org.springframework.extensions.config.element.ConfigElementAdapter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ClientConfigElement
extends ConfigElementAdapter {
    private static final long serialVersionUID = 825650925215057110L;
    private static Log logger = LogFactory.getLog(ClientConfigElement.class);
    public static final String CONFIG_ELEMENT_ID = "client";
    public static final String BREADCRUMB_PATH = "path";
    public static final String BREADCRUMB_LOCATION = "location";
    private static final String DEFAULT_FROM_ADDRESS = "alfresco@alfresco.org";
    private String fromEmailAddress = "alfresco@alfresco.org";
    private String errorPage = null;
    private String loginPage = null;
    private int recentSpacesItems = 6;
    private boolean shelfVisible = true;
    private int searchMinimum = 3;
    private boolean forceAndTerms = false;
    private int searchMaxResults = -1;
    private int selectorsSearchMaxResults = 500;
    private int inviteUsersMaxResults = 500;
    private String helpUrl = null;
    private String editLinkType = "http";
    private String homeSpacePermission = null;
    private boolean nodeSummaryEnabled = true;
    private String initialLocation = "myalfresco";
    private ExpiringValueCache<String> wcmDomain = new ExpiringValueCache(10000L);
    private ExpiringValueCache<String> wcmPort = new ExpiringValueCache(10000L);
    private String defaultHomeSpacePath = "/app:company_home/app:user_homes";
    private boolean clipboardStatusVisible = true;
    private boolean pasteAllAndClear = true;
    private boolean allowGuestConfig = false;
    private List<QName> simpleSearchAdditionalAttributes = null;
    private int minUsernameLength = 2;
    private int minPasswordLength = 3;
    private int minGroupNameLength = 3;
    private String breadcrumbMode = "path";
    private String cifsURLSuffix = null;
    private boolean languageSelect = true;
    private boolean zeroByteFileUploads = true;
    private boolean userGroupAdmin = true;
    private boolean allowUserConfig = true;
    private int pickerSearchMinimum = 2;
    private boolean checkContextAgainstPath = false;
    private boolean allowUserScriptExecute = false;

    public ClientConfigElement() {
        super(CONFIG_ELEMENT_ID);
    }

    public ClientConfigElement(String name) {
        super(name);
    }

    public ConfigElement combine(ConfigElement configElement) {
        ClientConfigElement newElement = (ClientConfigElement)configElement;
        ClientConfigElement combinedElement = new ClientConfigElement();
        if (newElement.getEditLinkType() == null) {
            combinedElement.setEditLinkType(this.editLinkType);
        } else {
            combinedElement.setEditLinkType(newElement.getEditLinkType());
        }
        if (newElement.getErrorPage() == null) {
            combinedElement.setErrorPage(this.errorPage);
        } else {
            combinedElement.setErrorPage(newElement.getErrorPage());
        }
        if (newElement.getLoginPage() == null) {
            combinedElement.setLoginPage(this.loginPage);
        } else {
            combinedElement.setLoginPage(newElement.getLoginPage());
        }
        if (newElement.getHelpUrl() == null) {
            combinedElement.setHelpUrl(this.helpUrl);
        } else {
            combinedElement.setHelpUrl(newElement.getHelpUrl());
        }
        if (newElement.getHomeSpacePermission() == null) {
            combinedElement.setHomeSpacePermission(this.homeSpacePermission);
        } else {
            combinedElement.setHomeSpacePermission(newElement.getHomeSpacePermission());
        }
        if (newElement.getCifsURLSuffix() == null) {
            combinedElement.setCifsURLSuffix(this.cifsURLSuffix);
        } else {
            combinedElement.setCifsURLSuffix(newElement.getCifsURLSuffix());
        }
        if (newElement.getSimpleSearchAdditionalAttributes() == null) {
            combinedElement.setSimpleSearchAdditionalAttributes(this.simpleSearchAdditionalAttributes);
        } else if (this.simpleSearchAdditionalAttributes == null) {
            combinedElement.setSimpleSearchAdditionalAttributes(newElement.getSimpleSearchAdditionalAttributes());
        } else {
            List<QName> newAttrs = newElement.getSimpleSearchAdditionalAttributes();
            ArrayList<QName> combinedAttrs = new ArrayList<QName>(this.simpleSearchAdditionalAttributes.size() + newAttrs.size());
            combinedAttrs.addAll(this.simpleSearchAdditionalAttributes);
            combinedAttrs.addAll(newAttrs);
            combinedElement.setSimpleSearchAdditionalAttributes(combinedAttrs);
        }
        if (newElement.getDefaultHomeSpacePath() != null && !newElement.getDefaultHomeSpacePath().equals(combinedElement.getDefaultHomeSpacePath())) {
            combinedElement.setDefaultHomeSpacePath(newElement.getDefaultHomeSpacePath());
        }
        if (newElement.getRecentSpacesItems() != combinedElement.getRecentSpacesItems()) {
            combinedElement.setRecentSpacesItems(newElement.getRecentSpacesItems());
        }
        if (newElement.getSearchMinimum() != combinedElement.getSearchMinimum()) {
            combinedElement.setSearchMinimum(newElement.getSearchMinimum());
        }
        if (newElement.getForceAndTerms() != combinedElement.getForceAndTerms()) {
            combinedElement.setForceAndTerms(newElement.getForceAndTerms());
        }
        if (newElement.getSearchMaxResults() != combinedElement.getSearchMaxResults()) {
            combinedElement.setSearchMaxResults(newElement.getSearchMaxResults());
        }
        if (newElement.getSelectorsSearchMaxResults() != combinedElement.getSelectorsSearchMaxResults()) {
            combinedElement.setSelectorsSearchMaxResults(newElement.getSelectorsSearchMaxResults());
        }
        if (newElement.getInviteUsersMaxResults() != combinedElement.getInviteUsersMaxResults()) {
            combinedElement.setInviteUsersMaxResults(newElement.getInviteUsersMaxResults());
        }
        if (newElement.isShelfVisible() != combinedElement.isShelfVisible()) {
            combinedElement.setShelfVisible(newElement.isShelfVisible());
        }
        if (newElement.isClipboardStatusVisible() != combinedElement.isClipboardStatusVisible()) {
            combinedElement.setClipboardStatusVisible(newElement.isClipboardStatusVisible());
        }
        if (newElement.isPasteAllAndClearEnabled() != combinedElement.isPasteAllAndClearEnabled()) {
            combinedElement.setPasteAllAndClearEnabled(newElement.isPasteAllAndClearEnabled());
        }
        if (newElement.getFromEmailAddress() != null && !newElement.getFromEmailAddress().equals(combinedElement.getFromEmailAddress())) {
            combinedElement.setFromEmailAddress(newElement.getFromEmailAddress());
        }
        if (newElement.isNodeSummaryEnabled() != combinedElement.isNodeSummaryEnabled()) {
            combinedElement.setNodeSummaryEnabled(newElement.isNodeSummaryEnabled());
        }
        if (newElement.getInitialLocation() != null && !newElement.getInitialLocation().equals(combinedElement.getInitialLocation())) {
            combinedElement.setInitialLocation(newElement.getInitialLocation());
        }
        if (newElement.getAllowGuestConfig() != combinedElement.getAllowGuestConfig()) {
            combinedElement.setAllowGuestConfig(newElement.getAllowGuestConfig());
        }
        if (newElement.getMinUsernameLength() != combinedElement.getMinUsernameLength()) {
            combinedElement.setMinUsernameLength(newElement.getMinUsernameLength());
        }
        if (newElement.getMinPasswordLength() != combinedElement.getMinPasswordLength()) {
            combinedElement.setMinPasswordLength(newElement.getMinPasswordLength());
        }
        if (newElement.getMinGroupNameLength() != combinedElement.getMinGroupNameLength()) {
            combinedElement.setMinGroupNameLength(newElement.getMinGroupNameLength());
        }
        if (newElement.getBreadcrumbMode() != null && !newElement.getBreadcrumbMode().equals(combinedElement.getBreadcrumbMode())) {
            combinedElement.setBreadcrumbMode(newElement.getBreadcrumbMode());
        }
        if (newElement.isLanguageSelect() != combinedElement.isLanguageSelect()) {
            combinedElement.setLanguageSelect(newElement.isLanguageSelect());
        }
        if (newElement.isZeroByteFileUploads() != combinedElement.isZeroByteFileUploads()) {
            combinedElement.setZeroByteFileUploads(newElement.isZeroByteFileUploads());
        }
        if (newElement.getAllowUserConfig() != combinedElement.getAllowUserConfig()) {
            combinedElement.setAllowUserConfig(newElement.getAllowUserConfig());
        }
        if (newElement.isUserGroupAdmin() != combinedElement.isUserGroupAdmin()) {
            combinedElement.setUserGroupAdmin(newElement.isUserGroupAdmin());
        }
        if (newElement.getPickerSearchMinimum() != combinedElement.getPickerSearchMinimum()) {
            combinedElement.setPickerSearchMinimum(newElement.getPickerSearchMinimum());
        }
        if (newElement.getCheckContextAgainstPath() != combinedElement.getCheckContextAgainstPath()) {
            combinedElement.setCheckContextAgainstPath(newElement.getCheckContextAgainstPath());
        }
        if (newElement.getAllowUserScriptExecute() != combinedElement.getAllowUserScriptExecute()) {
            combinedElement.setAllowUserScriptExecute(newElement.getAllowUserScriptExecute());
        }
        return combinedElement;
    }

    public int getRecentSpacesItems() {
        return this.recentSpacesItems;
    }

    void setRecentSpacesItems(int recentSpacesItems) {
        this.recentSpacesItems = recentSpacesItems;
    }

    public boolean isShelfVisible() {
        return this.shelfVisible;
    }

    void setShelfVisible(boolean shelfVisible) {
        this.shelfVisible = shelfVisible;
    }

    public boolean isClipboardStatusVisible() {
        return this.clipboardStatusVisible;
    }

    void setClipboardStatusVisible(boolean clipboardStatusVisible) {
        this.clipboardStatusVisible = clipboardStatusVisible;
    }

    public boolean isPasteAllAndClearEnabled() {
        return this.pasteAllAndClear;
    }

    void setPasteAllAndClearEnabled(boolean pasteAllAndClear) {
        this.pasteAllAndClear = pasteAllAndClear;
    }

    public String getErrorPage() {
        return this.errorPage;
    }

    void setErrorPage(String errorPage) {
        this.errorPage = errorPage;
    }

    public String getLoginPage() {
        return this.loginPage;
    }

    void setLoginPage(String loginPage) {
        this.loginPage = loginPage;
    }

    public String getHelpUrl() {
        return this.helpUrl;
    }

    void setHelpUrl(String helpUrl) {
        this.helpUrl = helpUrl;
    }

    public String getFromEmailAddress() {
        return this.fromEmailAddress;
    }

    void setFromEmailAddress(String fromEmailAddress) {
        this.fromEmailAddress = fromEmailAddress;
    }

    public String getEditLinkType() {
        return this.editLinkType;
    }

    void setEditLinkType(String editLinkType) {
        this.editLinkType = editLinkType;
    }

    public int getSearchMinimum() {
        return this.searchMinimum;
    }

    void setSearchMinimum(int searchMinimum) {
        this.searchMinimum = searchMinimum;
    }

    public boolean getForceAndTerms() {
        return this.forceAndTerms;
    }

    void setForceAndTerms(boolean forceAndTerms) {
        this.forceAndTerms = forceAndTerms;
    }

    public int getSearchMaxResults() {
        return this.searchMaxResults;
    }

    void setSearchMaxResults(int searchMaxResults) {
        this.searchMaxResults = searchMaxResults;
    }

    public int getSelectorsSearchMaxResults() {
        return this.selectorsSearchMaxResults;
    }

    void setSelectorsSearchMaxResults(int selectorsSearchMaxResults) {
        this.selectorsSearchMaxResults = selectorsSearchMaxResults;
    }

    public int getInviteUsersMaxResults() {
        return this.inviteUsersMaxResults;
    }

    void setInviteUsersMaxResults(int inviteUsersMaxResults) {
        this.inviteUsersMaxResults = inviteUsersMaxResults;
    }

    public String getHomeSpacePermission() {
        return this.homeSpacePermission;
    }

    void setHomeSpacePermission(String homeSpacePermission) {
        this.homeSpacePermission = homeSpacePermission;
    }

    public String getDefaultHomeSpacePath() {
        return this.defaultHomeSpacePath;
    }

    void setDefaultHomeSpacePath(String defaultHomeSpacePath) {
        this.defaultHomeSpacePath = defaultHomeSpacePath;
    }

    public boolean isNodeSummaryEnabled() {
        return this.nodeSummaryEnabled;
    }

    void setNodeSummaryEnabled(boolean ajaxEnabled) {
        this.nodeSummaryEnabled = ajaxEnabled;
    }

    public String getInitialLocation() {
        return this.initialLocation;
    }

    void setInitialLocation(String initialLocation) {
        this.initialLocation = initialLocation;
    }

    public String getWCMDomain() {
        String value = (String)this.wcmDomain.get();
        if (value == null) {
            VirtServerRegistry vServerRegistry = Repository.getServiceRegistry(FacesContext.getCurrentInstance()).getVirtServerRegistry();
            value = vServerRegistry.getVirtServerFQDN();
            if (value == null) {
                value = "127-0-0-1.ip.alfrescodemo.net";
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("Virtualisation Server not started - reverting to default IP: " + value));
                }
            }
            this.wcmDomain.put((Object)value);
        }
        return value;
    }

    public String getWCMPort() {
        String value = (String)this.wcmPort.get();
        if (value == null) {
            VirtServerRegistry vServerRegistry = Repository.getServiceRegistry(FacesContext.getCurrentInstance()).getVirtServerRegistry();
            Integer iValue = vServerRegistry.getVirtServerHttpPort();
            if (iValue == null) {
                iValue = 8180;
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("Virtualisation Server not started - reverting to default port: " + iValue));
                }
            }
            value = iValue.toString();
            this.wcmPort.put((Object)value);
        }
        return value;
    }

    void setAllowGuestConfig(boolean allow) {
        this.allowGuestConfig = allow;
    }

    public boolean getAllowGuestConfig() {
        return this.allowGuestConfig;
    }

    public List<QName> getSimpleSearchAdditionalAttributes() {
        return this.simpleSearchAdditionalAttributes;
    }

    void setSimpleSearchAdditionalAttributes(List<QName> simpleSearchAdditionalAttributes) {
        this.simpleSearchAdditionalAttributes = simpleSearchAdditionalAttributes;
    }

    public int getMinUsernameLength() {
        return this.minUsernameLength;
    }

    void setMinUsernameLength(int minUsernameLength) {
        this.minUsernameLength = minUsernameLength;
    }

    public int getMinPasswordLength() {
        return this.minPasswordLength;
    }

    void setMinPasswordLength(int minPasswordLength) {
        this.minPasswordLength = minPasswordLength;
    }

    public int getMinGroupNameLength() {
        return this.minGroupNameLength;
    }

    void setMinGroupNameLength(int minGroupNameLength) {
        this.minGroupNameLength = minGroupNameLength;
    }

    public final String getBreadcrumbMode() {
        return this.breadcrumbMode;
    }

    void setBreadcrumbMode(String mode) {
        if (BREADCRUMB_PATH.equals(mode) || BREADCRUMB_LOCATION.equals(mode)) {
            this.breadcrumbMode = mode;
        }
    }

    public final String getCifsURLSuffix() {
        return this.cifsURLSuffix;
    }

    void setCifsURLSuffix(String suffix) {
        this.cifsURLSuffix = suffix;
    }

    public final boolean isLanguageSelect() {
        return this.languageSelect;
    }

    void setLanguageSelect(boolean value) {
        this.languageSelect = value;
    }

    public boolean isZeroByteFileUploads() {
        return this.zeroByteFileUploads;
    }

    void setZeroByteFileUploads(boolean zeroByteFileUploads) {
        this.zeroByteFileUploads = zeroByteFileUploads;
    }

    public boolean isUserGroupAdmin() {
        return this.userGroupAdmin;
    }

    void setUserGroupAdmin(boolean userGroupAdmin) {
        this.userGroupAdmin = userGroupAdmin;
    }

    public boolean getAllowUserConfig() {
        return this.allowUserConfig;
    }

    void setAllowUserConfig(boolean allowUserConfig) {
        this.allowUserConfig = allowUserConfig;
    }

    public int getPickerSearchMinimum() {
        return this.pickerSearchMinimum;
    }

    void setPickerSearchMinimum(int searchMinimum) {
        this.pickerSearchMinimum = searchMinimum;
    }

    public boolean getCheckContextAgainstPath() {
        return this.checkContextAgainstPath;
    }

    void setCheckContextAgainstPath(boolean checkContextAgainstPath) {
        this.checkContextAgainstPath = checkContextAgainstPath;
    }

    public boolean getAllowUserScriptExecute() {
        return this.allowUserScriptExecute;
    }

    void setAllowUserScriptExecute(boolean allowUserScriptExecute) {
        this.allowUserScriptExecute = allowUserScriptExecute;
    }
}

