/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.web.config;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.springframework.extensions.config.ConfigElement;
import org.springframework.extensions.config.element.GenericConfigElement;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WCMConfigElement
extends GenericConfigElement {
    private static final long serialVersionUID = -4906603037550877971L;
    protected Map<String, GenericConfigElement> childrenMap;
    public static final String CONFIG_ELEMENT_ID = "wcm";

    public WCMConfigElement() {
        super(CONFIG_ELEMENT_ID);
    }

    public WCMConfigElement(String name) {
        super(name);
        this.childrenMap = new HashMap<String, GenericConfigElement>(8);
    }

    public ConfigElement combine(ConfigElement configElement) {
        WCMConfigElement combined = new WCMConfigElement(this.name);
        WCMConfigElement toCombineElement = (WCMConfigElement)configElement;
        Map<String, GenericConfigElement> toCombineKids = toCombineElement.getChildrenAsMap();
        List kids = this.getChildren();
        if (kids != null) {
            for (ConfigElement child : kids) {
                String childName = child.getName();
                if (toCombineKids.containsKey(childName)) {
                    if (childName.equals("xforms")) {
                        for (ConfigElement widget : toCombineKids.get("xforms").getChildren()) {
                            ((GenericConfigElement)child).addChild(widget);
                        }
                        combined.addChild(child);
                        continue;
                    }
                    combined.addChild((ConfigElement)toCombineKids.get(childName));
                    continue;
                }
                combined.addChild(child);
            }
        }
        if ((kids = toCombineElement.getChildren()) != null) {
            Map<String, GenericConfigElement> combinedKids = combined.getChildrenAsMap();
            for (ConfigElement child : kids) {
                if (combinedKids.containsKey(child.getName())) continue;
                combined.addChild(child);
            }
        }
        return combined;
    }

    public void addChild(ConfigElement configElement) {
        super.addChild(configElement);
        this.childrenMap.put(configElement.getName(), (GenericConfigElement)configElement);
    }

    public Map<String, GenericConfigElement> getChildrenAsMap() {
        return this.childrenMap;
    }
}

