/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.web.config;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.springframework.extensions.config.ConfigElement;
import org.springframework.extensions.config.ConfigException;
import org.springframework.extensions.config.element.ConfigElementAdapter;
import org.springframework.extensions.surf.util.ParameterCheck;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WizardsConfigElement
extends ConfigElementAdapter {
    public static final String CONFIG_ELEMENT_ID = "wizards";
    private Map<String, WizardConfig> wizards = new LinkedHashMap<String, WizardConfig>(8, 10.0f);

    public WizardsConfigElement() {
        super(CONFIG_ELEMENT_ID);
    }

    public WizardsConfigElement(String name) {
        super(name);
    }

    public List<ConfigElement> getChildren() {
        throw new ConfigException("Reading the wizards config via the generic interfaces is not supported");
    }

    public ConfigElement combine(ConfigElement configElement) {
        WizardsConfigElement combined = new WizardsConfigElement();
        for (WizardConfig wizard : this.getWizards().values()) {
            combined.addWizard(wizard);
        }
        for (WizardConfig wizard : ((WizardsConfigElement)configElement).getWizards().values()) {
            combined.addWizard(wizard);
        }
        return combined;
    }

    public WizardConfig getWizard(String name) {
        return this.wizards.get(name);
    }

    public Map<String, WizardConfig> getWizards() {
        return this.wizards;
    }

    void addWizard(WizardConfig wizardConfig) {
        this.wizards.put(wizardConfig.getName(), wizardConfig);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class StepConfig
    extends AbstractConfig
    implements Serializable {
        private static final long serialVersionUID = -3707570689181455754L;
        protected String name;
        protected PageConfig defaultPage;
        protected List<ConditionalPageConfig> conditionalPages = new ArrayList<ConditionalPageConfig>(3);

        public StepConfig(String name, String title, String titleId, String description, String descriptionId) {
            super(title, titleId, description, descriptionId);
            ParameterCheck.mandatoryString((String)"name", (String)name);
            if (this.title == null && this.titleId == null) {
                throw new IllegalArgumentException("A title or title-id attribute must be supplied for a step");
            }
            this.name = name;
        }

        public String getName() {
            return this.name;
        }

        public PageConfig getDefaultPage() {
            return this.defaultPage;
        }

        public boolean hasConditionalPages() {
            return this.conditionalPages.size() > 0;
        }

        public List<ConditionalPageConfig> getConditionalPages() {
            return this.conditionalPages;
        }

        void addConditionalPage(ConditionalPageConfig conditionalPage) {
            this.conditionalPages.add(conditionalPage);
        }

        void setDefaultPage(PageConfig page) {
            this.defaultPage = page;
        }

        public String toString() {
            StringBuilder buffer = new StringBuilder(super.toString());
            buffer.append(" (name=").append(this.name);
            buffer.append(" title=").append(this.title);
            buffer.append(" titleId=").append(this.titleId);
            buffer.append(" description=").append(this.description);
            buffer.append(" descriptionId=").append(this.descriptionId);
            buffer.append(" defaultPage=").append(this.defaultPage);
            buffer.append(" conditionalPages=").append(this.conditionalPages).append(")");
            return buffer.toString();
        }
    }

    public static class ConditionalPageConfig
    extends PageConfig {
        private static final long serialVersionUID = -3398913681170199314L;
        protected String condition;

        public ConditionalPageConfig(String path, String condition, String title, String titleId, String description, String descriptionId, String instruction, String instructionId) {
            super(path, title, titleId, description, descriptionId, instruction, instructionId);
            ParameterCheck.mandatoryString((String)"condition", (String)condition);
            this.condition = condition;
        }

        public String getCondition() {
            return this.condition;
        }

        public String toString() {
            StringBuilder buffer = new StringBuilder(super.toString());
            buffer.append(" (path=").append(this.path);
            buffer.append(" condition=").append(this.condition);
            buffer.append(" title=").append(this.title);
            buffer.append(" titleId=").append(this.titleId);
            buffer.append(" description=").append(this.description);
            buffer.append(" descriptionId=").append(this.descriptionId);
            buffer.append(" instruction=").append(this.instruction);
            buffer.append(" instructionId=").append(this.instructionId).append(")");
            return buffer.toString();
        }
    }

    public static class PageConfig
    extends AbstractConfig
    implements Serializable {
        private static final long serialVersionUID = 4154515148190230391L;
        protected String path;
        protected String instruction;
        protected String instructionId;

        public PageConfig(String path, String title, String titleId, String description, String descriptionId, String instruction, String instructionId) {
            super(title, titleId, description, descriptionId);
            ParameterCheck.mandatoryString((String)"path", (String)path);
            this.path = path;
            this.instruction = instruction;
            this.instructionId = instructionId;
        }

        public String getPath() {
            return this.path;
        }

        public String getInstruction() {
            return this.instruction;
        }

        public String getInstructionId() {
            return this.instructionId;
        }

        public String toString() {
            StringBuilder buffer = new StringBuilder(super.toString());
            buffer.append(" (path=").append(this.path);
            buffer.append(" title=").append(this.title);
            buffer.append(" titleId=").append(this.titleId);
            buffer.append(" description=").append(this.description);
            buffer.append(" descriptionId=").append(this.descriptionId);
            buffer.append(" instruction=").append(this.instruction);
            buffer.append(" instructionId=").append(this.instructionId).append(")");
            return buffer.toString();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class WizardConfig
    extends AbstractConfig
    implements Serializable {
        private static final long serialVersionUID = -3377339374041580932L;
        protected String subTitle;
        protected String subTitleId;
        protected String name;
        protected String managedBean;
        protected String icon;
        protected String errorMsgId = "error_wizard";
        protected Map<String, StepConfig> steps = new LinkedHashMap<String, StepConfig>(4);

        protected WizardConfig() {
        }

        public WizardConfig(String name, String bean, String icon, String title, String titleId, String subTitle, String subTitleId, String description, String descriptionId, String errorMsgId) {
            super(title, titleId, description, descriptionId);
            ParameterCheck.mandatoryString((String)"name", (String)name);
            this.subTitle = subTitle;
            this.subTitleId = subTitleId;
            this.name = name;
            this.managedBean = bean;
            this.icon = icon;
            if (errorMsgId != null && errorMsgId.length() > 0) {
                this.errorMsgId = errorMsgId;
            }
        }

        public String getName() {
            return this.name;
        }

        public String getManagedBean() {
            return this.managedBean;
        }

        public String getSubTitle() {
            return this.subTitle;
        }

        public String getSubTitleId() {
            return this.subTitleId;
        }

        public String getIcon() {
            return this.icon;
        }

        public String getErrorMessageId() {
            return this.errorMsgId;
        }

        public int getNumberSteps() {
            return this.steps.size();
        }

        public Map<String, StepConfig> getSteps() {
            return this.steps;
        }

        public List<StepConfig> getStepsAsList() {
            ArrayList<StepConfig> stepList = new ArrayList<StepConfig>(this.steps.size());
            for (StepConfig stepCfg : this.steps.values()) {
                stepList.add(stepCfg);
            }
            return stepList;
        }

        public StepConfig getStepByName(String name) {
            return this.steps.get(name);
        }

        void addStep(StepConfig step) {
            this.steps.put(step.getName(), step);
        }

        public String toString() {
            StringBuilder buffer = new StringBuilder(super.toString());
            buffer.append(" (name=").append(this.name);
            buffer.append(" managed-bean=").append(this.managedBean);
            buffer.append(" icon=").append(this.icon);
            buffer.append(" title=").append(this.title);
            buffer.append(" titleId=").append(this.titleId);
            buffer.append(" subTitle=").append(this.subTitle);
            buffer.append(" subTitleId=").append(this.subTitleId);
            buffer.append(" description=").append(this.description);
            buffer.append(" descriptionId=").append(this.descriptionId);
            buffer.append(" errorMsgId=").append(this.errorMsgId).append(")");
            return buffer.toString();
        }
    }

    public static abstract class AbstractConfig
    implements Serializable {
        protected String title;
        protected String titleId;
        protected String description;
        protected String descriptionId;

        protected AbstractConfig() {
        }

        public AbstractConfig(String title, String titleId, String description, String descriptionId) {
            this.title = title;
            this.titleId = titleId;
            this.description = description;
            this.descriptionId = descriptionId;
        }

        public String getDescription() {
            return this.description;
        }

        public String getDescriptionId() {
            return this.descriptionId;
        }

        public String getTitle() {
            return this.title;
        }

        public String getTitleId() {
            return this.titleId;
        }
    }
}

