/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.web.forms;

import java.util.HashMap;
import java.util.Map;
import java.util.Random;
import junit.framework.TestCase;
import org.alfresco.web.forms.XMLUtil;

public class XMLUtilTest
extends TestCase {
    public static final String SOME_XML = " <model name='test1:testModelOne' xmlns='http://www.alfresco.org/model/dictionary/1.0'>   <description>Test model one</description>   <author>Alfresco</author>   <published>2008-01-01</published>   <version>1.0</version>   <imports>      <import uri='http://www.alfresco.org/model/dictionary/1.0' prefix='d'/>   </imports>   <namespaces>      <namespace uri='http://www.alfresco.org/test/testmodel1/1.0' prefix='test1'/>   </namespaces>   <types>      <type name='test1:base'>        <title>Base</title>        <description>The Base Type</description>        <properties>           <property name='test1:prop1'>              <type>d:text</type>           </property>        </properties>      </type>   </types> </model>";
    private static final int threadCount = 5;
    private static final int loopCount = 50;
    private static final int randomNextInt = 100;
    private Map<String, Throwable> errors = new HashMap<String, Throwable>();

    protected void setUp() throws Exception {
    }

    public void testConcurrentParse() {
        int i;
        ThreadGroup threadGroup = new ThreadGroup(this.getName());
        Thread[] threads = new Thread[5];
        for (i = 0; i < 5; ++i) {
            threads[i] = new Thread(threadGroup, new TestRun("" + i), String.format("XMLUtilTest-%02d", i));
            threads[i].start();
        }
        for (i = 0; i < threads.length; ++i) {
            try {
                threads[i].join();
                continue;
            }
            catch (InterruptedException e) {
                // empty catch block
            }
        }
        if (this.errors.size() != 0) {
            XMLUtilTest.fail();
        }
    }

    class TestRun
    extends Thread {
        private String arg;

        public TestRun(String arg) {
            this.arg = arg;
        }

        public String getArg() {
            return this.arg;
        }

        public void run() {
            Random random = new Random(System.currentTimeMillis());
            for (int i = 0; i < 50; ++i) {
                try {
                    XMLUtil.parse(XMLUtilTest.SOME_XML);
                }
                catch (Throwable t) {
                    t.printStackTrace();
                    XMLUtilTest.this.errors.put(this.arg, t);
                    break;
                }
                int msecs = random.nextInt(100);
                try {
                    Thread.sleep(msecs);
                    continue;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
    }
}

