/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.web.ui.common.component;

import java.io.IOException;
import java.text.MessageFormat;
import java.util.Map;
import java.util.ResourceBundle;
import javax.faces.component.UICommand;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import javax.faces.el.MethodBinding;
import javax.faces.el.ValueBinding;
import javax.faces.event.AbortProcessingException;
import javax.faces.event.ActionEvent;
import javax.faces.event.FacesEvent;
import javax.faces.model.SelectItem;
import org.alfresco.web.app.Application;
import org.alfresco.web.ui.common.Utils;

public class UIGenericPicker
extends UICommand {
    private static final int ACTION_NONE = -1;
    private static final int ACTION_SEARCH = 0;
    private static final int ACTION_CLEAR = 1;
    private static final int ACTION_FILTER = 2;
    private static final int ACTION_ADD = 3;
    private static final String FIELD_FILTER = "_filter";
    private static final String FIELD_CONTAINS = "_contains";
    private static final String FIELD_RESULTS = "_results";
    private static final String MSG_SEARCH = "search";
    private static final String MSG_CLEAR = "clear";
    private static final String MSG_ADD = "add";
    private static final String MSG_RESULTS1 = "results_contains";
    private static final String MSG_RESULTS2 = "results_contains_filter";
    private static final int DEFAULT_HEIGHT = 100;
    private static final int DEFAULT_WIDTH = 250;
    private MethodBinding queryCallback = null;
    private Boolean showFilter = null;
    private Boolean showContains = null;
    private Boolean showAddButton = null;
    private Boolean filterRefresh = null;
    private Boolean multiSelect = null;
    private String addButtonLabel = null;
    private String searchButtonLabel = null;
    private Integer width = null;
    private Integer height = null;
    private SelectItem[] filters = null;
    private int filterIndex = 0;
    private String contains = "";
    private String[] selectedResults = null;
    private SelectItem[] currentResults = null;

    public UIGenericPicker() {
        this.setRendererType(null);
    }

    public String getFamily() {
        return "org.alfresco.faces.GenericPicker";
    }

    public void restoreState(FacesContext context, Object state) {
        Object[] values = (Object[])state;
        super.restoreState(context, values[0]);
        this.showFilter = (Boolean)values[1];
        this.showContains = (Boolean)values[2];
        this.showAddButton = (Boolean)values[3];
        this.addButtonLabel = (String)values[4];
        this.width = (Integer)values[5];
        this.height = (Integer)values[6];
        this.filterIndex = (Integer)values[7];
        this.contains = (String)values[8];
        this.queryCallback = (MethodBinding)UIGenericPicker.restoreAttachedState((FacesContext)context, (Object)values[9]);
        this.selectedResults = (String[])values[10];
        this.currentResults = (SelectItem[])values[11];
        this.filters = (SelectItem[])values[12];
        this.filterRefresh = (Boolean)values[13];
        this.multiSelect = (Boolean)values[14];
        this.searchButtonLabel = (String)values[15];
    }

    public Object saveState(FacesContext context) {
        Object[] values = new Object[]{super.saveState(context), this.showFilter, this.showContains, this.showAddButton, this.addButtonLabel, this.width, this.height, this.filterIndex, this.contains, UIGenericPicker.saveAttachedState((FacesContext)context, (Object)this.queryCallback), this.selectedResults, this.currentResults, this.filters, this.filterRefresh, this.multiSelect, this.searchButtonLabel};
        return values;
    }

    public void decode(FacesContext context) {
        Map requestMap = context.getExternalContext().getRequestParameterMap();
        Map valuesMap = context.getExternalContext().getRequestParameterValuesMap();
        String fieldId = this.getHiddenFieldName();
        String value = (String)requestMap.get(fieldId);
        int action = -1;
        if (value != null && value.length() != 0) {
            action = Integer.parseInt(value);
        }
        int filterIndex = 0;
        String strFilterIndex = (String)requestMap.get(fieldId + FIELD_FILTER);
        if (strFilterIndex != null && strFilterIndex.length() != 0) {
            filterIndex = Integer.parseInt(strFilterIndex);
        }
        String contains = (String)requestMap.get(fieldId + FIELD_CONTAINS);
        String[] results = (String[])valuesMap.get(fieldId + FIELD_RESULTS);
        PickerEvent event = new PickerEvent((UIComponent)this, action, filterIndex, contains, results);
        this.queueEvent((FacesEvent)event);
    }

    public void broadcast(FacesEvent event) throws AbortProcessingException {
        if (event instanceof PickerEvent) {
            PickerEvent pickerEvent = (PickerEvent)event;
            this.filterIndex = pickerEvent.FilterIndex;
            this.contains = pickerEvent.Contains;
            this.selectedResults = pickerEvent.Results;
            switch (pickerEvent.Action) {
                case 3: {
                    super.broadcast(event);
                    break;
                }
                case 1: {
                    this.contains = "";
                    this.filterIndex = 0;
                    this.selectedResults = null;
                    this.currentResults = null;
                    break;
                }
                case 0: 
                case 2: {
                    MethodBinding callback = this.getQueryCallback();
                    if (callback == null) break;
                    Object result = callback.invoke(this.getFacesContext(), new Object[]{this.filterIndex, this.contains.trim()});
                    this.currentResults = result instanceof SelectItem[] ? (SelectItem[])result : null;
                }
            }
        } else {
            super.broadcast(event);
        }
    }

    public void encodeBegin(FacesContext context) throws IOException {
        int i;
        if (!this.isRendered()) {
            return;
        }
        ResponseWriter out = context.getResponseWriter();
        ResourceBundle bundle = Application.getBundle(context);
        String clientId = this.getClientId(context);
        out.write("<table border=0 cellspacing=4 cellpadding=0>");
        out.write("<tr valign=top><td>");
        if (this.getShowFilter()) {
            out.write("<select name='");
            out.write(clientId + FIELD_FILTER);
            out.write("' size='1'");
            if (this.getFilterRefresh()) {
                out.write(" onchange=\"");
                out.write(this.generateFormSubmit(context, 2));
                out.write("\"");
            }
            out.write(">");
            SelectItem[] items = this.getFilterOptions();
            if (items != null) {
                for (i = 0; i < items.length; ++i) {
                    out.write("<option value=\"");
                    out.write(items[i].getValue().toString());
                    if (this.filterIndex != i) {
                        out.write("\">");
                    } else {
                        out.write("\" selected=\"true\">");
                    }
                    out.write(Utils.encode((String)items[i].getLabel()));
                    out.write("</option>");
                }
            }
            out.write("</select>");
        }
        out.write("</td><td align=right>");
        if (this.getShowContains()) {
            out.write("<input name='");
            out.write(clientId + FIELD_CONTAINS);
            out.write("' type='text' maxlength='256' style='width:");
            out.write(this.getShowFilter() ? "120" : "180");
            out.write("px' value=\"");
            out.write(Utils.encode((String)this.contains));
            out.write("\">&nbsp;");
        }
        out.write("<input type='submit' value='");
        String msg = this.getSearchButtonLabel();
        if (msg == null || msg.length() == 0) {
            msg = bundle.getString(MSG_SEARCH);
        }
        out.write(Utils.encode((String)msg));
        out.write("' onclick=\"");
        out.write(this.generateFormSubmit(context, 0));
        out.write("\">");
        out.write("</td></tr>");
        if (this.currentResults != null && this.getShowContains()) {
            String resultsMsg;
            out.write("<tr><td colspan=3>");
            if (!this.getShowFilter()) {
                resultsMsg = MessageFormat.format(bundle.getString(MSG_RESULTS1), Utils.encode((String)this.contains));
            } else {
                String filterMsg = this.filters[this.filterIndex].getLabel();
                resultsMsg = MessageFormat.format(bundle.getString(MSG_RESULTS2), Utils.encode((String)this.contains), filterMsg);
            }
            out.write(resultsMsg);
            out.write("&nbsp;");
            out.write("<a href='#' onclick=\"");
            out.write(this.generateFormSubmit(context, 1));
            out.write("\">");
            out.write(Utils.encode((String)bundle.getString(MSG_CLEAR)));
            out.write("</a></td></tr>");
        }
        out.write("<tr><td colspan=2>");
        out.write("<select size='8' style='");
        out.write(this.currentResults != null && this.currentResults.length != 0 ? "min-width:" : "width:");
        out.write(Integer.toString(this.getWidth()));
        out.write("px;height:");
        out.write(Integer.toString(this.getHeight()));
        out.write("px' name='");
        out.write(clientId + FIELD_RESULTS);
        out.write("' id='");
        out.write(clientId + FIELD_RESULTS);
        out.write("'");
        if (this.getMultiSelect()) {
            out.write(" multiple");
        }
        out.write(">");
        if (this.currentResults != null) {
            for (i = 0; i < this.currentResults.length; ++i) {
                out.write("<option value=\"");
                out.write(this.currentResults[i].getValue().toString());
                out.write("\">");
                out.write(Utils.encode((String)this.currentResults[i].getLabel()));
                out.write("</option>");
            }
        }
        out.write("</select>");
        out.write("</td></tr>");
        if (this.getShowAddButton()) {
            out.write("<tr><td colspan=2>");
            out.write("<input type='submit' value='");
            msg = this.getAddButtonLabel();
            if (msg == null || msg.length() == 0) {
                msg = bundle.getString(MSG_ADD);
            }
            out.write(Utils.encode((String)msg));
            out.write("' onclick=\"");
            out.write(this.generateFormSubmit(context, 3));
            out.write("\">");
            out.write("</td></tr>");
        }
        out.write("</table>");
    }

    public SelectItem[] getFilterOptions() {
        ValueBinding vb;
        if (this.filters == null && (vb = this.getValueBinding("filters")) != null) {
            this.filters = (SelectItem[])vb.getValue(this.getFacesContext());
        }
        return this.filters;
    }

    public int getFilterIndex() {
        return this.filterIndex;
    }

    public String getSearchButtonLabel() {
        ValueBinding vb = this.getValueBinding("searchButtonLabel");
        if (vb != null) {
            this.searchButtonLabel = (String)vb.getValue(this.getFacesContext());
        }
        return this.searchButtonLabel;
    }

    public void setSearchButtonLabel(String searchButtonLabel) {
        this.searchButtonLabel = searchButtonLabel;
    }

    public String getAddButtonLabel() {
        ValueBinding vb = this.getValueBinding("addButtonLabel");
        if (vb != null) {
            this.addButtonLabel = (String)vb.getValue(this.getFacesContext());
        }
        return this.addButtonLabel;
    }

    public void setAddButtonLabel(String addButtonLabel) {
        this.addButtonLabel = addButtonLabel;
    }

    public boolean getShowAddButton() {
        ValueBinding vb = this.getValueBinding("showAddButton");
        if (vb != null) {
            this.showAddButton = (Boolean)vb.getValue(this.getFacesContext());
        }
        return this.showAddButton != null ? this.showAddButton : true;
    }

    public void setShowAddButton(boolean showAddButton) {
        this.showAddButton = showAddButton;
    }

    public boolean getShowContains() {
        ValueBinding vb = this.getValueBinding("showContains");
        if (vb != null) {
            this.showContains = (Boolean)vb.getValue(this.getFacesContext());
        }
        return this.showContains != null ? this.showContains : true;
    }

    public void setShowContains(boolean showContains) {
        this.showContains = showContains;
    }

    public boolean getShowFilter() {
        ValueBinding vb = this.getValueBinding("showFilter");
        if (vb != null) {
            this.showFilter = (Boolean)vb.getValue(this.getFacesContext());
        }
        return this.showFilter != null ? this.showFilter : true;
    }

    public void setShowFilter(boolean showFilter) {
        this.showFilter = showFilter;
    }

    public boolean getFilterRefresh() {
        ValueBinding vb = this.getValueBinding("filterRefresh");
        if (vb != null) {
            this.filterRefresh = (Boolean)vb.getValue(this.getFacesContext());
        }
        return this.filterRefresh != null ? this.filterRefresh : false;
    }

    public void setFilterRefresh(boolean filterRefresh) {
        this.filterRefresh = filterRefresh;
    }

    public boolean getMultiSelect() {
        ValueBinding vb = this.getValueBinding("multiSelect");
        if (vb != null) {
            this.multiSelect = (Boolean)vb.getValue(this.getFacesContext());
        }
        return this.multiSelect != null ? this.multiSelect : true;
    }

    public void setMultiSelect(boolean multiSelect) {
        this.multiSelect = multiSelect;
    }

    public int getWidth() {
        ValueBinding vb = this.getValueBinding("width");
        if (vb != null) {
            this.width = (Integer)vb.getValue(this.getFacesContext());
        }
        return this.width != null ? this.width : 250;
    }

    public void setWidth(int width) {
        this.width = width;
    }

    public int getHeight() {
        ValueBinding vb = this.getValueBinding("height");
        if (vb != null) {
            this.height = (Integer)vb.getValue(this.getFacesContext());
        }
        return this.height != null ? this.height : 100;
    }

    public void setHeight(int height) {
        this.height = height;
    }

    public MethodBinding getQueryCallback() {
        return this.queryCallback;
    }

    public void setQueryCallback(MethodBinding binding) {
        this.queryCallback = binding;
    }

    public String[] getSelectedResults() {
        return this.selectedResults;
    }

    private String getHiddenFieldName() {
        return this.getClientId(this.getFacesContext());
    }

    private String generateFormSubmit(FacesContext context, int action) {
        return Utils.generateFormSubmit(context, (UIComponent)this, this.getHiddenFieldName(), Integer.toString(action));
    }

    public static class PickerEvent
    extends ActionEvent {
        public int Action;
        public int FilterIndex;
        public String Contains;
        public String[] Results;

        public PickerEvent(UIComponent component, int action, int filterIndex, String contains, String[] results) {
            super(component);
            this.Action = action;
            this.FilterIndex = filterIndex;
            this.Contains = contains;
            this.Results = results;
        }
    }
}

