/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.web.ui.common.component.data;

import java.io.IOException;
import java.util.Map;
import javax.faces.component.UICommand;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import javax.faces.el.ValueBinding;
import javax.faces.event.AbortProcessingException;
import javax.faces.event.ActionEvent;
import javax.faces.event.FacesEvent;
import org.alfresco.web.data.IDataContainer;
import org.alfresco.web.ui.common.Utils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class UISortLink
extends UICommand {
    private static Log s_logger = LogFactory.getLog(IDataContainer.class);
    private String mode = "case-insensitive";
    private String label;
    private String tooltip;
    private boolean descending = false;

    public UISortLink() {
        this.setRendererType(null);
    }

    public void encodeBegin(FacesContext context) throws IOException {
        ResponseWriter out = context.getResponseWriter();
        IDataContainer dataContainer = this.getDataContainer();
        if (dataContainer == null) {
            throw new IllegalStateException("Must nest UISortLink inside component implementing IDataContainer!");
        }
        boolean bPreviouslySorted = false;
        boolean descending = true;
        String lastSortedColumn = dataContainer.getCurrentSortColumn();
        if (lastSortedColumn != null && lastSortedColumn.equals(this.getValue())) {
            descending = !dataContainer.isCurrentSortDescending();
            bPreviouslySorted = true;
        }
        StringBuilder buf = new StringBuilder(256);
        buf.append("<nobr><a href='#' onclick=\"");
        buf.append(Utils.generateFormSubmit(context, (UIComponent)this, this.getHiddenFieldName(context), this.getClientId(context)));
        buf.append('\"');
        if (this.getAttributes().get("style") != null) {
            buf.append(" style=\"").append(this.getAttributes().get("style")).append('\"');
        }
        if (this.getAttributes().get("styleClass") != null) {
            buf.append(" class=").append(this.getAttributes().get("styleClass"));
        }
        if (this.getAttributes().get("tooltip") != null) {
            buf.append(" title=\"").append(this.getAttributes().get("tooltip")).append('\"');
        }
        buf.append('>');
        buf.append(Utils.encode((String)((String)this.getAttributes().get("label"))));
        if (bPreviouslySorted) {
            if (descending) {
                buf.append(" ").append(Utils.buildImageTag(context, "/images/icons/sort_up.gif", 10, 6, null));
            } else {
                buf.append(" ").append(Utils.buildImageTag(context, "/images/icons/sort_down.gif", 10, 6, null));
            }
        } else {
            buf.append(" ").append(Utils.buildImageTag(context, "/images/icons/sort_flat.gif", 10, 7, null));
        }
        buf.append("</a></nobr>");
        out.write(buf.toString());
    }

    public void decode(FacesContext context) {
        String fieldId;
        Map requestMap = context.getExternalContext().getRequestParameterMap();
        String value = (String)requestMap.get(fieldId = this.getHiddenFieldName(context));
        if (value != null && value.equals(this.getClientId(context))) {
            SortEvent actionEvent = new SortEvent((UIComponent)this, (String)this.getValue());
            this.queueEvent((FacesEvent)actionEvent);
        }
    }

    public void broadcast(FacesEvent event) throws AbortProcessingException {
        if (!(event instanceof SortEvent)) {
            super.broadcast(event);
        } else if (((SortEvent)event).Column.equals(this.getColumn())) {
            if (s_logger.isDebugEnabled()) {
                s_logger.debug((Object)("Handling sort event for column: " + ((SortEvent)event).Column));
            }
            this.descending = this.getColumn().equals(this.getDataContainer().getCurrentSortColumn()) ? !this.descending : true;
            this.getDataContainer().sort(this.getColumn(), this.descending, this.getMode());
        }
    }

    private String getHiddenFieldName(FacesContext context) {
        UIComponent dataContainer = (UIComponent)Utils.getParentDataContainer(context, (UIComponent)this);
        return dataContainer.getClientId(context) + ':' + "sort";
    }

    public String getColumn() {
        return (String)this.getValue();
    }

    public String getMode() {
        return this.mode;
    }

    public void setMode(String sortMode) {
        this.mode = sortMode;
    }

    public boolean isDescending() {
        return this.descending;
    }

    public String getLabel() {
        ValueBinding vb = this.getValueBinding("label");
        if (vb != null) {
            this.label = (String)vb.getValue(this.getFacesContext());
        }
        return this.label;
    }

    public void setLabel(String label) {
        this.label = label;
    }

    public String getTooltip() {
        ValueBinding vb = this.getValueBinding("tooltip");
        if (vb != null) {
            this.tooltip = (String)vb.getValue(this.getFacesContext());
        }
        return this.tooltip;
    }

    public void setTooltip(String tooltip) {
        this.tooltip = tooltip;
    }

    public void restoreState(FacesContext context, Object state) {
        Object[] values = (Object[])state;
        super.restoreState(context, values[0]);
        this.descending = (Boolean)values[1];
        this.mode = (String)values[2];
        this.label = (String)values[3];
        this.tooltip = (String)values[4];
    }

    public Object saveState(FacesContext context) {
        Object[] values = new Object[]{super.saveState(context), this.descending ? Boolean.TRUE : Boolean.FALSE, this.mode, this.label, this.tooltip};
        return values;
    }

    private IDataContainer getDataContainer() {
        return Utils.getParentDataContainer(this.getFacesContext(), (UIComponent)this);
    }

    private static class SortEvent
    extends ActionEvent {
        public String Column = null;

        public SortEvent(UIComponent component, String column) {
            super(component);
            this.Column = column;
        }
    }
}

