/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.web.ui.common.component.debug;

import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import javax.faces.context.FacesContext;
import org.alfresco.repo.admin.patch.AppliedPatch;
import org.alfresco.repo.admin.patch.PatchService;
import org.alfresco.service.ServiceRegistry;
import org.alfresco.service.descriptor.Descriptor;
import org.alfresco.service.descriptor.DescriptorService;
import org.alfresco.web.app.Application;
import org.alfresco.web.bean.repository.Repository;
import org.alfresco.web.ui.common.component.debug.BaseDebugComponent;
import org.springframework.web.context.WebApplicationContext;
import org.springframework.web.jsf.FacesContextUtils;

public class UIRepositoryProperties
extends BaseDebugComponent {
    public String getFamily() {
        return "org.alfresco.faces.debug.RepositoryProperties";
    }

    public Map getDebugData() {
        TreeMap<String, Object> properties = new TreeMap<String, Object>();
        FacesContext fc = FacesContext.getCurrentInstance();
        ServiceRegistry services = Repository.getServiceRegistry(fc);
        DescriptorService descriptorService = services.getDescriptorService();
        Descriptor installedRepoDescriptor = descriptorService.getInstalledRepositoryDescriptor();
        properties.put("Installed Version", installedRepoDescriptor.getVersion());
        properties.put("Installed Schema", installedRepoDescriptor.getSchema());
        Descriptor systemDescriptor = descriptorService.getServerDescriptor();
        properties.put("Server Version", systemDescriptor.getVersion());
        properties.put("Server Schema", systemDescriptor.getSchema());
        WebApplicationContext cx = FacesContextUtils.getRequiredWebApplicationContext((FacesContext)fc);
        PatchService patchService = (PatchService)cx.getBean("PatchService");
        List patches = patchService.getPatches(null, null);
        for (AppliedPatch patch : patches) {
            StringBuilder data = new StringBuilder(256);
            data.append(patch.getAppliedOnDate()).append(" - ").append(patch.getDescription()).append(" - ").append(patch.getSucceeded() ? Application.getMessage(fc, "repository_patch_succeeded") : Application.getMessage(fc, "repository_patch_failed"));
            properties.put(patch.getId(), data);
        }
        return properties;
    }
}

