/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.web.ui.common.converter;

import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.TimeZone;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.convert.DateTimeConverter;
import org.springframework.extensions.surf.util.ISO8601DateFormat;

public class XMLDateConverter
extends DateTimeConverter {
    public static final String CONVERTER_ID = "org.alfresco.faces.XMLDateConverter";

    public Object getAsObject(FacesContext context, UIComponent component, String value) {
        return ISO8601DateFormat.parse((String)value);
    }

    public String getAsString(FacesContext context, UIComponent component, Object value) {
        String str = null;
        if (value instanceof String) {
            Date date = ISO8601DateFormat.parse((String)((String)value));
            str = super.getAsString(context, component, (Object)date);
        } else if (value instanceof List) {
            StringBuilder buffer = new StringBuilder();
            for (Object date : (List)value) {
                if (buffer.length() != 0) {
                    buffer.append(", ");
                }
                buffer.append(super.getAsString(context, component, date));
            }
            str = buffer.toString();
        } else {
            str = super.getAsString(context, component, value);
        }
        return str;
    }

    public TimeZone getTimeZone() {
        return TimeZone.getDefault();
    }

    public Locale getLocale() {
        FacesContext context = FacesContext.getCurrentInstance();
        Locale locale = context.getViewRoot().getLocale();
        if (locale == null) {
            locale = Locale.getDefault();
        }
        return locale;
    }
}

