/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.web.ui.repo.component;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.faces.component.UIComponent;
import javax.faces.component.UIInput;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import javax.faces.el.ValueBinding;
import org.alfresco.model.ContentModel;
import org.alfresco.repo.search.impl.lucene.LuceneQueryParser;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.NodeService;
import org.alfresco.service.cmr.search.LimitBy;
import org.alfresco.service.cmr.search.ResultSet;
import org.alfresco.service.cmr.search.SearchParameters;
import org.alfresco.service.namespace.QName;
import org.alfresco.web.app.Application;
import org.alfresco.web.bean.repository.Repository;
import org.alfresco.web.ui.common.Utils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class UIContentSelector
extends UIInput {
    private static final Log logger = LogFactory.getLog(UIContentSelector.class);
    private static final String ACTION_SEARCH = "0";
    private static final String FIELD_CONTAINS = "_contains";
    private static final String FIELD_AVAILABLE = "_available";
    private static final String MSG_SEARCH = "search";
    protected String availableOptionsSize;
    protected Boolean disabled;
    private Boolean multiSelect;
    protected List<NodeRef> availableOptions;

    public String getFamily() {
        return "org.alfresco.faces.ContentSelector";
    }

    public UIContentSelector() {
        this.setRendererType(null);
    }

    public void restoreState(FacesContext context, Object state) {
        Object[] values = (Object[])state;
        super.restoreState(context, values[0]);
        this.availableOptions = (List)values[1];
        this.availableOptionsSize = (String)values[2];
        this.disabled = (Boolean)values[3];
        this.multiSelect = (Boolean)values[4];
    }

    public Object saveState(FacesContext context) {
        Object[] values = new Object[10];
        values[0] = super.saveState(context);
        values[1] = this.availableOptions;
        values[2] = this.availableOptionsSize;
        values[3] = this.disabled;
        values[4] = this.multiSelect;
        return values;
    }

    public void decode(FacesContext context) {
        Map requestMap = context.getExternalContext().getRequestParameterMap();
        Map valuesMap = context.getExternalContext().getRequestParameterValuesMap();
        String fieldId = this.getHiddenFieldName();
        String value = (String)requestMap.get(fieldId);
        if (value != null && value.equals(ACTION_SEARCH)) {
            String contains = (String)requestMap.get(fieldId + FIELD_CONTAINS);
            this.availableOptions = new ArrayList<NodeRef>();
            this.getAvailableOptions(FacesContext.getCurrentInstance(), contains);
        } else {
            String[] addedItems = (String[])valuesMap.get(fieldId + FIELD_AVAILABLE);
            this.setSubmittedValue(addedItems);
        }
    }

    public void encodeBegin(FacesContext context) throws IOException {
        if (!this.isRendered()) {
            return;
        }
        ResponseWriter out = context.getResponseWriter();
        NodeService nodeService = Repository.getServiceRegistry(context).getNodeService();
        if (!this.isDisabled()) {
            out.write("<table border='0' cellspacing='4' cellpadding='0' class='");
            if (this.getAttributes().get("styleClass") != null) {
                out.write((String)this.getAttributes().get("styleClass"));
            } else {
                out.write("selector");
            }
            out.write("'");
            if (this.getAttributes().get("style") != null) {
                out.write(" style='");
                out.write((String)this.getAttributes().get("style"));
                out.write("'");
            }
            out.write(">");
            out.write("<tr><td colspan='2'><input type='text' maxlength='1024' size='32' name='");
            out.write(this.getClientId(context) + FIELD_CONTAINS);
            out.write("'/>&nbsp;&nbsp;<input type='submit' value='");
            out.write(Application.getMessage(context, MSG_SEARCH));
            out.write("' onclick=\"");
            out.write(this.generateFormSubmit(context, ACTION_SEARCH));
            out.write("\"/></td></tr>");
            this.renderAvailableOptions(context, out, nodeService);
            out.write("</table>");
        }
    }

    public boolean isDisabled() {
        ValueBinding vb;
        if (this.disabled == null && (vb = this.getValueBinding("disabled")) != null) {
            this.disabled = (Boolean)vb.getValue(this.getFacesContext());
        }
        if (this.disabled == null) {
            this.disabled = Boolean.FALSE;
        }
        return this.disabled;
    }

    public void setDisabled(boolean disabled) {
        this.disabled = disabled;
    }

    public String getAvailableOptionsSize() {
        if (this.availableOptionsSize == null) {
            this.availableOptionsSize = "6";
        }
        return this.availableOptionsSize;
    }

    public void setAvailableOptionsSize(String availableOptionsSize) {
        this.availableOptionsSize = availableOptionsSize;
    }

    public boolean getMultiSelect() {
        ValueBinding vb = this.getValueBinding("multiSelect");
        if (vb != null) {
            this.multiSelect = (Boolean)vb.getValue(this.getFacesContext());
        }
        return this.multiSelect != null ? this.multiSelect : true;
    }

    public void setMultiSelect(boolean multiSelect) {
        this.multiSelect = multiSelect;
    }

    protected void renderAvailableOptions(FacesContext context, ResponseWriter out, NodeService nodeService) throws IOException {
        boolean itemsPresent = this.availableOptions != null && this.availableOptions.size() > 0;
        out.write("<tr><td colspan='2'><select ");
        if (!itemsPresent) {
            out.write("style='width:240px;' ");
        }
        out.write("name='");
        out.write(this.getClientId(context) + FIELD_AVAILABLE);
        out.write("' size='");
        if (this.getMultiSelect()) {
            out.write(this.getAvailableOptionsSize());
            out.write("' multiple");
        } else {
            out.write("1'");
        }
        out.write(">");
        if (itemsPresent) {
            for (NodeRef item : this.availableOptions) {
                out.write("<option value='");
                out.write(item.toString());
                out.write("'>");
                out.write(Utils.encode((String)Repository.getDisplayPath(nodeService.getPath(item))));
                out.write("/");
                out.write(Utils.encode((String)Repository.getNameForNode(nodeService, item)));
                out.write("</option>");
            }
        }
        out.write("</select></td></tr>");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void getAvailableOptions(FacesContext context, String contains) {
        StringBuilder query = new StringBuilder("+TYPE:\"");
        query.append(ContentModel.TYPE_CONTENT);
        query.append("\"");
        if (contains != null && contains.length() > 0) {
            String safeContains = LuceneQueryParser.escape((String)contains.trim());
            query.append(" AND +@");
            String nameAttr = Repository.escapeQName(QName.createQName((String)"http://www.alfresco.org/model/content/1.0", (String)"name"));
            query.append(nameAttr);
            query.append(":\"*" + safeContains + "\"*");
        }
        int maxResults = Application.getClientConfig(context).getSelectorsSearchMaxResults();
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Query: " + query.toString()));
            logger.debug((Object)("Max results size: " + maxResults));
        }
        SearchParameters searchParams = new SearchParameters();
        searchParams.addStore(Repository.getStoreRef());
        searchParams.setLanguage("lucene");
        searchParams.setQuery(query.toString());
        if (maxResults > 0) {
            searchParams.setLimit(maxResults);
            searchParams.setLimitBy(LimitBy.FINAL_SIZE);
        }
        ResultSet results = null;
        try {
            results = Repository.getServiceRegistry(context).getSearchService().query(searchParams);
            this.availableOptions = results.getNodeRefs();
        }
        finally {
            if (results != null) {
                results.close();
            }
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Found " + this.availableOptions.size() + " available options"));
        }
    }

    private String getHiddenFieldName() {
        return this.getClientId(this.getFacesContext());
    }

    private String generateFormSubmit(FacesContext context, String action) {
        return Utils.generateFormSubmit(context, (UIComponent)this, this.getHiddenFieldName(), action);
    }
}

