/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.web.ui.repo.component;

import java.io.IOException;
import java.util.Iterator;
import java.util.List;
import javax.faces.component.UICommand;
import javax.faces.component.UIComponent;
import javax.faces.component.UIOutput;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import javax.faces.el.MethodBinding;
import javax.faces.el.ValueBinding;
import org.alfresco.web.app.Application;
import org.alfresco.web.app.servlet.FacesHelper;
import org.alfresco.web.config.DialogsConfigElement;
import org.alfresco.web.ui.common.Utils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.extensions.webscripts.ui.common.component.SelfRenderingComponent;

public class UIDialogButtons
extends SelfRenderingComponent {
    protected static final String BINDING_EXPRESSION_START = "#{";
    private static final Log logger = LogFactory.getLog(UIDialogButtons.class);

    public String getFamily() {
        return "org.alfresco.faces.DialogButtons";
    }

    public void encodeBegin(FacesContext context) throws IOException {
        if (!this.isRendered()) {
            return;
        }
        if (this.getChildCount() == 0) {
            this.generateButtons(context);
        }
        ResponseWriter out = context.getResponseWriter();
        out.write("<table cellpadding=\"1\" cellspacing=\"1\" border=\"0\">");
    }

    public void encodeChildren(FacesContext context) throws IOException {
        if (!this.isRendered()) {
            return;
        }
        ResponseWriter out = context.getResponseWriter();
        Iterator i = this.getChildren().iterator();
        while (i.hasNext()) {
            out.write("<tr><td align=\"center\">");
            UIComponent child = (UIComponent)i.next();
            Utils.encodeRecursive(context, child);
            out.write("</td></tr>");
        }
    }

    public void encodeEnd(FacesContext context) throws IOException {
        if (!this.isRendered()) {
            return;
        }
        ResponseWriter out = context.getResponseWriter();
        out.write("</table>");
    }

    public boolean getRendersChildren() {
        return true;
    }

    protected void generateButtons(FacesContext context) {
        String styleClass;
        MethodBinding methodBinding;
        ValueBinding valueBinding;
        if (Application.getDialogManager().isOKButtonVisible()) {
            UICommand okButton = (UICommand)context.getApplication().createComponent("javax.faces.HtmlCommandButton");
            okButton.setRendererType("javax.faces.Button");
            FacesHelper.setupComponentId(context, (UIComponent)okButton, "finish-button");
            valueBinding = context.getApplication().createValueBinding("#{DialogManager.finishButtonLabel}");
            okButton.setValueBinding("value", valueBinding);
            methodBinding = context.getApplication().createMethodBinding("#{DialogManager.finish}", null);
            okButton.setAction(methodBinding);
            valueBinding = context.getApplication().createValueBinding("#{DialogManager.finishButtonDisabled}");
            okButton.setValueBinding("disabled", valueBinding);
            styleClass = (String)this.getAttributes().get("styleClass");
            if (styleClass != null) {
                okButton.getAttributes().put("styleClass", styleClass);
            }
            this.getChildren().add(okButton);
        }
        this.generateAdditionalButtons(context);
        UICommand cancelButton = (UICommand)context.getApplication().createComponent("javax.faces.HtmlCommandButton");
        cancelButton.setRendererType("javax.faces.Button");
        FacesHelper.setupComponentId(context, (UIComponent)cancelButton, "cancel-button");
        valueBinding = context.getApplication().createValueBinding("#{DialogManager.cancelButtonLabel}");
        cancelButton.setValueBinding("value", valueBinding);
        methodBinding = context.getApplication().createMethodBinding("#{DialogManager.cancel}", null);
        cancelButton.setAction(methodBinding);
        styleClass = (String)this.getAttributes().get("styleClass");
        if (styleClass != null) {
            cancelButton.getAttributes().put("styleClass", styleClass);
        }
        cancelButton.getAttributes().put("immediate", Boolean.TRUE);
        this.getChildren().add(cancelButton);
    }

    protected void generateAdditionalButtons(FacesContext context) {
        List<DialogsConfigElement.DialogButtonConfig> buttons = Application.getDialogManager().getAdditionalButtons();
        if (buttons != null && buttons.size() > 0) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Adding " + buttons.size() + " additional buttons: " + buttons));
            }
            this.addSpacingRow(context);
            for (DialogsConfigElement.DialogButtonConfig buttonCfg : buttons) {
                String onclick;
                String styleClass;
                UICommand button = (UICommand)context.getApplication().createComponent("javax.faces.HtmlCommandButton");
                button.setRendererType("javax.faces.Button");
                FacesHelper.setupComponentId(context, (UIComponent)button, buttonCfg.getId());
                String label = buttonCfg.getLabel();
                if (label != null) {
                    if (label.startsWith(BINDING_EXPRESSION_START)) {
                        ValueBinding binding = context.getApplication().createValueBinding(label);
                        button.setValueBinding("value", binding);
                    } else {
                        button.setValue((Object)label);
                    }
                } else {
                    String labelId = buttonCfg.getLabelId();
                    label = Application.getMessage(context, labelId);
                    button.setValue((Object)label);
                }
                String action = buttonCfg.getAction();
                MethodBinding methodBinding = context.getApplication().createMethodBinding(action, null);
                button.setAction(methodBinding);
                String disabled = buttonCfg.getDisabled();
                if (disabled != null && disabled.length() > 0) {
                    if (disabled.startsWith(BINDING_EXPRESSION_START)) {
                        ValueBinding binding = context.getApplication().createValueBinding(disabled);
                        button.setValueBinding("disabled", binding);
                    } else {
                        button.getAttributes().put("disabled", Boolean.parseBoolean(disabled));
                    }
                }
                if ((styleClass = (String)this.getAttributes().get("styleClass")) != null) {
                    button.getAttributes().put("styleClass", styleClass);
                }
                if ((onclick = buttonCfg.getOnclick()) != null && onclick.length() > 0) {
                    button.getAttributes().put("onclick", onclick);
                }
                this.getChildren().add(button);
                if (!logger.isDebugEnabled()) continue;
                logger.debug((Object)("Added button with id of: " + button.getId()));
            }
            this.addSpacingRow(context);
        }
    }

    protected void addSpacingRow(FacesContext context) {
        UIOutput spacingRow = (UIOutput)context.getApplication().createComponent("javax.faces.Output");
        spacingRow.setRendererType("javax.faces.Text");
        FacesHelper.setupComponentId(context, (UIComponent)spacingRow, null);
        spacingRow.setValue((Object)"<div class=\"wizardButtonSpacing\" />");
        spacingRow.getAttributes().put("escape", Boolean.FALSE);
        this.getChildren().add(spacingRow);
    }
}

