/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.web.ui.repo.component;

import java.io.IOException;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import javax.faces.el.ValueBinding;
import org.alfresco.web.app.Application;
import org.alfresco.web.bean.repository.Repository;
import org.springframework.extensions.webscripts.ui.common.component.SelfRenderingComponent;

public class UINodeInfo
extends SelfRenderingComponent {
    protected static final String NODE_INFO_SCRIPTS_WRITTEN = "_alfNodeInfoScripts";
    protected Object value = null;

    public String getFamily() {
        return "org.alfresco.faces.NodeInfo";
    }

    public void restoreState(FacesContext context, Object state) {
        Object[] values = (Object[])state;
        super.restoreState(context, values[0]);
        this.value = values[1];
    }

    public Object saveState(FacesContext context) {
        Object[] values = new Object[]{super.saveState(context), this.value};
        return values;
    }

    public void encodeBegin(FacesContext context) throws IOException {
        if (!this.isRendered()) {
            return;
        }
        if (Application.getClientConfig(context).isNodeSummaryEnabled()) {
            ResponseWriter out = context.getResponseWriter();
            UINodeInfo.outputNodeInfoScripts(context, out);
            String noderef = Repository.getStoreRef().toString() + '/' + (String)this.getValue();
            out.write("<span onclick=\"AlfNodeInfoMgr.toggle('");
            out.write(noderef);
            out.write("',this);\">");
        }
    }

    protected static void outputNodeInfoScripts(FacesContext context, ResponseWriter out) throws IOException {
        Object present = context.getExternalContext().getRequestMap().get(NODE_INFO_SCRIPTS_WRITTEN);
        if (present == null) {
            out.write("<script>var AlfNodeInfoMgr = new Alfresco.PanelManager(\"NodeInfoBean.sendNodeInfo\", \"noderef\");</script>");
            context.getExternalContext().getRequestMap().put(NODE_INFO_SCRIPTS_WRITTEN, Boolean.TRUE);
        }
    }

    public void encodeEnd(FacesContext context) throws IOException {
        if (!this.isRendered()) {
            return;
        }
        if (Application.getClientConfig(context).isNodeSummaryEnabled()) {
            context.getResponseWriter().write("</span>");
        }
    }

    public Object getValue() {
        ValueBinding vb = this.getValueBinding("value");
        if (vb != null) {
            this.value = vb.getValue(this.getFacesContext());
        }
        return this.value;
    }

    public void setValue(Object value) {
        this.value = value;
    }
}

