/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.web.ui.repo.component.property;

import java.io.IOException;
import javax.faces.component.NamingContainer;
import javax.faces.component.UIComponent;
import javax.faces.component.UIPanel;
import javax.faces.context.FacesContext;
import javax.faces.el.ValueBinding;
import org.alfresco.web.app.servlet.FacesHelper;
import org.alfresco.web.ui.repo.component.property.UIPropertySheet;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public abstract class PropertySheetItem
extends UIPanel
implements NamingContainer {
    private static Log logger = LogFactory.getLog(PropertySheetItem.class);
    protected String name;
    protected String displayLabel;
    protected String converter;
    protected Boolean readOnly;
    protected Boolean ignoreIfMissing;
    protected String componentGenerator;
    protected String resolvedDisplayLabel;

    public void encodeBegin(FacesContext context) throws IOException {
        UIComponent parent = this.getParent();
        if (!(parent instanceof UIPropertySheet)) {
            throw new IllegalStateException(this.getIncorrectParentMsg());
        }
        int howManyKids = this.getChildren().size();
        if (howManyKids == 0) {
            this.generateItem(context, (UIPropertySheet)parent);
        }
        super.encodeBegin(context);
    }

    public String getDisplayLabel() {
        ValueBinding vb;
        if (this.displayLabel == null && (vb = this.getValueBinding("display-label")) != null) {
            this.displayLabel = (String)vb.getValue(this.getFacesContext());
        }
        return this.displayLabel;
    }

    public void setDisplayLabel(String displayLabel) {
        this.displayLabel = displayLabel;
    }

    public String getName() {
        ValueBinding vb;
        if (this.name == null && (vb = this.getValueBinding("name")) != null) {
            this.name = (String)vb.getValue(this.getFacesContext());
        }
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getConverter() {
        ValueBinding vb;
        if (this.converter == null && (vb = this.getValueBinding("converter")) != null) {
            this.converter = (String)vb.getValue(this.getFacesContext());
        }
        return this.converter;
    }

    public void setComponentGenerator(String componentGenerator) {
        this.componentGenerator = componentGenerator;
    }

    public String getComponentGenerator() {
        ValueBinding vb;
        if (this.componentGenerator == null && (vb = this.getValueBinding("component-generator")) != null) {
            this.componentGenerator = (String)vb.getValue(this.getFacesContext());
        }
        return this.componentGenerator;
    }

    public void setConverter(String converter) {
        this.converter = converter;
    }

    public boolean isReadOnly() {
        ValueBinding vb;
        if (this.readOnly == null && (vb = this.getValueBinding("readOnly")) != null) {
            this.readOnly = (Boolean)vb.getValue(this.getFacesContext());
        }
        if (this.readOnly == null) {
            this.readOnly = Boolean.FALSE;
        }
        return this.readOnly;
    }

    public void setReadOnly(boolean readOnly) {
        this.readOnly = readOnly;
    }

    public boolean getIgnoreIfMissing() {
        ValueBinding vb;
        if (this.ignoreIfMissing == null && (vb = this.getValueBinding("ignoreIfMissing")) != null) {
            this.ignoreIfMissing = (Boolean)vb.getValue(this.getFacesContext());
        }
        if (this.ignoreIfMissing == null) {
            this.ignoreIfMissing = Boolean.TRUE;
        }
        return this.ignoreIfMissing;
    }

    public void setIgnoreIfMissing(boolean ignoreIfMissing) {
        this.ignoreIfMissing = ignoreIfMissing;
    }

    public void restoreState(FacesContext context, Object state) {
        Object[] values = (Object[])state;
        super.restoreState(context, values[0]);
        this.name = (String)values[1];
        this.displayLabel = (String)values[2];
        this.readOnly = (Boolean)values[3];
        this.converter = (String)values[4];
        this.componentGenerator = (String)values[5];
        this.resolvedDisplayLabel = (String)values[6];
        this.ignoreIfMissing = (Boolean)values[7];
    }

    public Object saveState(FacesContext context) {
        Object[] values = new Object[]{super.saveState(context), this.name, this.displayLabel, this.readOnly, this.converter, this.componentGenerator, this.resolvedDisplayLabel, this.ignoreIfMissing};
        return values;
    }

    public String getResolvedDisplayLabel() {
        return this.resolvedDisplayLabel;
    }

    protected abstract void generateItem(FacesContext var1, UIPropertySheet var2) throws IOException;

    protected abstract String getIncorrectParentMsg();

    protected void generateLabel(FacesContext context, UIPropertySheet propSheet, String displayLabel) {
        UIComponent label = FacesHelper.getComponentGenerator(context, "LabelGenerator").generateAndAdd(context, propSheet, this);
        this.resolvedDisplayLabel = displayLabel;
        label.getAttributes().put("value", displayLabel + ":");
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Created label " + label.getClientId(context) + " for '" + this.name + "' and added it to component " + (Object)((Object)this)));
        }
    }
}

