/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.web.ui.repo.component.property;

import java.io.IOException;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import org.alfresco.model.ContentModel;
import org.alfresco.service.cmr.repository.ChildAssociationRef;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.NodeService;
import org.alfresco.service.namespace.QName;
import org.alfresco.web.bean.repository.Node;
import org.alfresco.web.bean.repository.Repository;
import org.alfresco.web.bean.repository.User;
import org.alfresco.web.ui.common.Utils;
import org.alfresco.web.ui.repo.component.property.BaseAssociationEditor;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class UIChildAssociationEditor
extends BaseAssociationEditor {
    private static final Log logger = LogFactory.getLog(UIChildAssociationEditor.class);

    public String getFamily() {
        return "org.alfresco.faces.ChildAssociationEditor";
    }

    protected void populateAssocationMaps(Node node, NodeService nodeService) {
        if (this.originalAssocs == null) {
            this.originalAssocs = new LinkedHashMap();
            List assocs = (List)node.getChildAssociations().get(this.associationName);
            if (assocs != null) {
                for (ChildAssociationRef assoc : assocs) {
                    this.originalAssocs.put(assoc.getChildRef().toString(), assoc);
                }
            }
        }
        this.added = node.getAddedChildAssociations().get(this.associationName);
        if (this.added == null) {
            this.added = new LinkedHashMap();
            node.getAddedChildAssociations().put(this.associationName, this.added);
        }
        this.removed = node.getRemovedChildAssociations().get(this.associationName);
        if (this.removed == null) {
            this.removed = new LinkedHashMap();
            node.getRemovedChildAssociations().put(this.associationName, this.removed);
        }
    }

    protected void renderExistingAssociations(FacesContext context, ResponseWriter out, NodeService nodeService, boolean allowMany) throws IOException {
        boolean itemsRendered = false;
        for (ChildAssociationRef assoc : this.originalAssocs.values()) {
            if (this.removed.containsKey(assoc.getChildRef().toString())) continue;
            this.renderExistingAssociation(context, out, nodeService, assoc.getChildRef(), allowMany);
            itemsRendered = true;
        }
        for (ChildAssociationRef assoc : this.added.values()) {
            this.renderExistingAssociation(context, out, nodeService, assoc.getChildRef(), allowMany);
            itemsRendered = true;
        }
        if (!itemsRendered && allowMany) {
            this.renderNone(context, out);
        }
    }

    protected void renderReadOnlyAssociations(FacesContext context, ResponseWriter out, NodeService nodeService) throws IOException {
        if (this.originalAssocs.size() > 0) {
            out.write("<table cellspacing='0' cellpadding='2' border='0'>");
            Iterator iter = this.originalAssocs.values().iterator();
            while (iter.hasNext()) {
                out.write("<tr><td>");
                ChildAssociationRef assoc = (ChildAssociationRef)iter.next();
                NodeRef targetNode = assoc.getChildRef();
                if (ContentModel.TYPE_PERSON.equals((Object)nodeService.getType(targetNode))) {
                    out.write(Utils.encode((String)User.getFullName(nodeService, targetNode)));
                } else if (ContentModel.TYPE_AUTHORITY_CONTAINER.equals((Object)nodeService.getType(targetNode))) {
                    String groupDisplayName = (String)((Object)nodeService.getProperty(targetNode, ContentModel.PROP_AUTHORITY_DISPLAY_NAME));
                    if (groupDisplayName == null || groupDisplayName.length() == 0) {
                        String group = (String)((Object)nodeService.getProperty(targetNode, ContentModel.PROP_AUTHORITY_NAME));
                        groupDisplayName = group.substring("GROUP_".length());
                    }
                    out.write(groupDisplayName);
                } else {
                    out.write(Repository.getDisplayPath(nodeService.getPath(targetNode)));
                    out.write("/");
                    out.write(Repository.getNameForNode(nodeService, targetNode));
                }
                out.write("</td></tr>");
            }
            out.write("</table>");
        }
    }

    protected void removeTarget(Node node, String childRef) {
        if (node != null && childRef != null) {
            Map<String, ChildAssociationRef> added;
            QName assocQName = Repository.resolveToQName(this.associationName);
            ChildAssociationRef childAssoc = new ChildAssociationRef(assocQName, node.getNodeRef(), assocQName, new NodeRef(childRef));
            if (this.originalAssocs.containsKey(childRef)) {
                Map<String, ChildAssociationRef> removed = node.getRemovedChildAssociations().get(this.associationName);
                removed.put(childRef, childAssoc);
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("Added association to " + childRef + " to the removed list"));
                }
            }
            if ((added = node.getAddedChildAssociations().get(this.associationName)).containsKey(childRef)) {
                added.remove(childRef);
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("Removed association to " + childRef + " from the added list"));
                }
            }
        }
    }

    protected void addTarget(Node node, String[] toAdd) {
        if (node != null && toAdd != null && toAdd.length > 0) {
            for (int x = 0; x < toAdd.length; ++x) {
                Map<String, ChildAssociationRef> removed;
                String childRef = toAdd[x];
                if (!this.originalAssocs.containsKey(childRef)) {
                    QName assocQName = Repository.resolveToQName(this.associationName);
                    ChildAssociationRef childAssoc = new ChildAssociationRef(assocQName, node.getNodeRef(), assocQName, new NodeRef(childRef));
                    Map<String, ChildAssociationRef> added = node.getAddedChildAssociations().get(this.associationName);
                    added.put(childRef, childAssoc);
                    if (logger.isDebugEnabled()) {
                        logger.debug((Object)("Added association to " + childRef + " to the added list"));
                    }
                }
                if (!(removed = node.getRemovedChildAssociations().get(this.associationName)).containsKey(childRef)) continue;
                removed.remove(childRef);
                if (!logger.isDebugEnabled()) continue;
                logger.debug((Object)("Removed association to " + childRef + " from the removed list"));
            }
        }
    }
}

