/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.web.ui.repo.component.shelf;

import java.io.IOException;
import java.util.List;
import java.util.Map;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import javax.faces.el.MethodBinding;
import javax.faces.el.ValueBinding;
import javax.faces.event.AbortProcessingException;
import javax.faces.event.ActionEvent;
import javax.faces.event.FacesEvent;
import org.alfresco.model.ContentModel;
import org.alfresco.repo.web.scripts.FileTypeImageUtils;
import org.alfresco.service.cmr.dictionary.DictionaryService;
import org.alfresco.web.app.Application;
import org.alfresco.web.bean.repository.Node;
import org.alfresco.web.bean.repository.Repository;
import org.alfresco.web.ui.common.Utils;
import org.alfresco.web.ui.repo.component.shelf.UIShelfItem;

public class UIShortcutsShelfItem
extends UIShelfItem {
    private static final String MSG_REMOVE_ITEM = "remove_item";
    private static final int ACTION_CLICK_ITEM = 0;
    private static final int ACTION_REMOVE_ITEM = 1;
    private Object value = null;
    private MethodBinding clickActionListener;
    private MethodBinding removeActionListener;

    public void restoreState(FacesContext context, Object state) {
        Object[] values = (Object[])state;
        super.restoreState(context, values[0]);
        this.value = values[1];
        this.clickActionListener = (MethodBinding)UIShortcutsShelfItem.restoreAttachedState((FacesContext)context, (Object)values[2]);
        this.removeActionListener = (MethodBinding)UIShortcutsShelfItem.restoreAttachedState((FacesContext)context, (Object)values[3]);
    }

    public Object saveState(FacesContext context) {
        Object[] values = new Object[]{super.saveState(context), this.value, UIShortcutsShelfItem.saveAttachedState((FacesContext)context, (Object)this.clickActionListener), UIShortcutsShelfItem.saveAttachedState((FacesContext)context, (Object)this.removeActionListener)};
        return values;
    }

    public Object getValue() {
        ValueBinding vb;
        if (this.value == null && (vb = this.getValueBinding("value")) != null) {
            this.value = vb.getValue(this.getFacesContext());
        }
        return this.value;
    }

    public void setValue(Object value) {
        this.value = value;
    }

    public void setClickActionListener(MethodBinding binding) {
        this.clickActionListener = binding;
    }

    public MethodBinding getClickActionListener() {
        return this.clickActionListener;
    }

    public void setRemoveActionListener(MethodBinding binding) {
        this.removeActionListener = binding;
    }

    public MethodBinding getRemoveActionListener() {
        return this.removeActionListener;
    }

    public void decode(FacesContext context) {
        String fieldId;
        Map requestMap = context.getExternalContext().getRequestParameterMap();
        String value = (String)requestMap.get(fieldId = this.getHiddenFieldName());
        if (value != null && value.length() != 0) {
            int sepIndex = value.indexOf(58);
            int action = Integer.parseInt(value.substring(0, sepIndex));
            int index = Integer.parseInt(value.substring(sepIndex + 1));
            ShortcutEvent event = new ShortcutEvent((UIComponent)this, action, index);
            this.queueEvent((FacesEvent)event);
        }
    }

    public void encodeBegin(FacesContext context) throws IOException {
        if (!this.isRendered()) {
            return;
        }
        ResponseWriter out = context.getResponseWriter();
        List items = (List)this.getValue();
        out.write("<table border=\"0\" cellspacing=\"3\" cellpadding=\"0\" width=\"100%\" valign=\"top\">");
        if (items != null) {
            DictionaryService dd = Repository.getServiceRegistry(FacesContext.getCurrentInstance()).getDictionaryService();
            for (int i = 0; i < items.size(); ++i) {
                Node item = (Node)items.get(i);
                out.write("<tr><td width=16>");
                if (dd.isSubClass(item.getType(), ContentModel.TYPE_FOLDER)) {
                    String icon = (String)item.getProperties().get("app:icon");
                    icon = icon != null ? "/images/icons/" + icon + "-16.gif" : "/images/icons/space_small.gif";
                    out.write(Utils.buildImageTag(context, icon, 16, 16, null, null, "absmiddle"));
                } else if (dd.isSubClass(item.getType(), ContentModel.TYPE_CONTENT)) {
                    String image = FileTypeImageUtils.getFileTypeImage((String)item.getName(), (boolean)true);
                    out.write(Utils.buildImageTag(context, image, null, "absmiddle"));
                }
                out.write("</td><td width=100%><nobr>&nbsp;");
                out.write(this.buildActionLink(0, i, item.getName()));
                out.write("</nobr></td><td align=right><nobr>");
                out.write(this.buildActionLink(1, i, Application.getMessage(context, MSG_REMOVE_ITEM), "/images/icons/delete.gif"));
                out.write("</nobr></td></tr>");
            }
        }
        out.write("</table>");
    }

    public void broadcast(FacesEvent event) throws AbortProcessingException {
        if (event instanceof ShortcutEvent) {
            ShortcutEvent shortcutEvent = (ShortcutEvent)event;
            List items = (List)this.getValue();
            if (items != null && items.size() > shortcutEvent.Index) {
                switch (shortcutEvent.Action) {
                    case 0: {
                        Utils.processActionMethod(this.getFacesContext(), this.getClickActionListener(), shortcutEvent);
                        break;
                    }
                    case 1: {
                        Utils.processActionMethod(this.getFacesContext(), this.getRemoveActionListener(), shortcutEvent);
                    }
                }
            }
        } else {
            super.broadcast(event);
        }
    }

    private String getHiddenFieldName() {
        return this.getClientId(this.getFacesContext());
    }

    private String buildActionLink(int action, int index, String text) {
        FacesContext context = this.getFacesContext();
        StringBuilder buf = new StringBuilder(200);
        buf.append("<a href='#' onclick=\"");
        buf.append(Utils.generateFormSubmit(context, (UIComponent)this, this.getHiddenFieldName(), UIShortcutsShelfItem.encodeValues(action, index)));
        buf.append("\">");
        buf.append(Utils.cropEncode((String)text));
        buf.append("</a>");
        return buf.toString();
    }

    private String buildActionLink(int action, int index, String text, String image) {
        FacesContext context = this.getFacesContext();
        StringBuilder buf = new StringBuilder(256);
        buf.append("<a href='#' onclick=\"");
        buf.append(Utils.generateFormSubmit(context, (UIComponent)this, this.getHiddenFieldName(), UIShortcutsShelfItem.encodeValues(action, index)));
        buf.append("\">");
        if (image != null) {
            buf.append(Utils.buildImageTag(context, image, text));
        } else {
            buf.append(Utils.encode((String)text));
        }
        buf.append("</a>");
        return buf.toString();
    }

    private static String encodeValues(int action, int index) {
        return Integer.toString(action) + ':' + Integer.toString(index);
    }

    public static class ShortcutEvent
    extends ActionEvent {
        public int Action;
        public int Index;

        public ShortcutEvent(UIComponent component, int action, int index) {
            super(component);
            this.Action = action;
            this.Index = index;
        }
    }
}

