/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.web.ui.repo.component.template;

import java.util.Map;
import javax.faces.context.FacesContext;
import org.alfresco.repo.web.scripts.FileTypeImageUtils;
import org.alfresco.service.ServiceRegistry;
import org.alfresco.service.cmr.repository.FileTypeImageSize;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.TemplateImageResolver;
import org.alfresco.web.app.Application;
import org.alfresco.web.bean.repository.Repository;
import org.alfresco.web.bean.repository.User;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultModelHelper {
    public static final TemplateImageResolver imageResolver = new TemplateImageResolver(){

        public String resolveImagePathForName(String filename, FileTypeImageSize size) {
            return FileTypeImageUtils.getFileTypeImage((FacesContext)FacesContext.getCurrentInstance(), (String)filename, (FileTypeImageSize)size);
        }
    };

    private DefaultModelHelper() {
    }

    public static Map<String, Object> buildDefaultModel(ServiceRegistry services, User user, NodeRef template) {
        return DefaultModelHelper.buildDefaultModel(services, user, template, imageResolver);
    }

    public static Map<String, Object> buildDefaultModel(ServiceRegistry services, User user, NodeRef template, TemplateImageResolver resolver) {
        if (services == null) {
            throw new IllegalArgumentException("ServiceRegistry is mandatory.");
        }
        if (user == null) {
            throw new IllegalArgumentException("Current User is mandatory.");
        }
        NodeRef companyRootRef = new NodeRef(Repository.getStoreRef(), Application.getCompanyRootId());
        NodeRef userRootRef = new NodeRef(Repository.getStoreRef(), user.getHomeSpaceId());
        return services.getTemplateService().buildDefaultModel(user.getPerson(), companyRootRef, userRootRef, template, resolver);
    }
}

