/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.web.ui.repo.renderer;

import java.io.IOException;
import java.util.Date;
import java.util.List;
import java.util.Map;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import javax.faces.convert.Converter;
import javax.faces.event.FacesEvent;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.NodeService;
import org.alfresco.web.app.Application;
import org.alfresco.web.bean.repository.Repository;
import org.alfresco.web.ui.common.Utils;
import org.alfresco.web.ui.common.converter.XMLDateConverter;
import org.alfresco.web.ui.common.renderer.BaseRenderer;
import org.alfresco.web.ui.repo.component.UIMultiValueEditor;

public abstract class BaseMultiValueRenderer
extends BaseRenderer {
    protected static final String MSG_REMOVE = "remove";
    protected static final String MSG_SELECT_BUTTON = "select_button";
    protected static final String MSG_ADD_TO_LIST_BUTTON = "add_to_list_button";
    protected boolean highlightedRow;

    public void decode(FacesContext context, UIComponent component) {
        Map requestMap = context.getExternalContext().getRequestParameterMap();
        String fieldId = this.getHiddenFieldName(component);
        String value = (String)requestMap.get(fieldId);
        int action = -1;
        int removeIndex = -1;
        if (value != null && value.length() != 0) {
            int sepIdx = value.indexOf(";");
            if (sepIdx != -1) {
                action = Integer.parseInt(value.substring(0, sepIdx));
                removeIndex = Integer.parseInt(value.substring(sepIdx + 1));
            } else {
                action = Integer.parseInt(value);
            }
        }
        if (action != -1) {
            UIMultiValueEditor.MultiValueEditorEvent event = new UIMultiValueEditor.MultiValueEditorEvent(component, action, removeIndex);
            component.queueEvent((FacesEvent)event);
        }
        super.decode(context, component);
    }

    public void encodeBegin(FacesContext context, UIComponent component) throws IOException {
        if (!component.isRendered()) {
            return;
        }
        this.highlightedRow = false;
        if (component instanceof UIMultiValueEditor) {
            ResponseWriter out = context.getResponseWriter();
            Map attrs = component.getAttributes();
            UIMultiValueEditor editor = (UIMultiValueEditor)component;
            out.write("<table border='0' cellspacing='3' cellpadding='3'");
            BaseMultiValueRenderer.outputAttribute(out, attrs.get("style"), "style");
            BaseMultiValueRenderer.outputAttribute(out, attrs.get("styleClass"), "class");
            out.write(">");
            this.renderPreWrappedComponent(context, out, editor);
        }
    }

    public void encodeEnd(FacesContext context, UIComponent component) throws IOException {
        if (!component.isRendered()) {
            return;
        }
        if (component instanceof UIMultiValueEditor) {
            ResponseWriter out = context.getResponseWriter();
            UIMultiValueEditor editor = (UIMultiValueEditor)component;
            NodeService nodeService = Repository.getServiceRegistry(context).getNodeService();
            this.renderPostWrappedComponent(context, out, editor);
            out.write("<tr><td style='padding-top:8px'>");
            out.write(editor.getSelectedItemsMsg());
            out.write("</td></tr>");
            out.write("<tr><td><table cellspacing='0' cellpadding='2' border='0' class='selectedItems'>");
            out.write("<tr><td colspan='2' class='selectedItemsHeader'>");
            out.write(Application.getMessage(context, "name"));
            out.write("</td></tr>");
            List currentItems = (List)editor.getValue();
            if (currentItems != null && currentItems.size() > 0) {
                for (int x = 0; x < currentItems.size(); ++x) {
                    Object obj = currentItems.get(x);
                    if (obj == null) continue;
                    if (obj instanceof NodeRef) {
                        if (nodeService.exists((NodeRef)obj)) {
                            this.renderExistingItem(context, component, out, nodeService, x, obj);
                            continue;
                        }
                        currentItems.remove(x);
                        continue;
                    }
                    this.renderExistingItem(context, component, out, nodeService, x, obj);
                }
            } else {
                out.write("<tr><td class='selectedItemsRow'>");
                out.write(editor.getNoSelectedItemsMsg());
                out.write("</td></tr>");
            }
            out.write("</table></td></tr></table>\n");
            out.write("<input type='hidden' id='");
            out.write(component.getClientId(context));
            out.write("_current_value");
            out.write("' name='");
            out.write(component.getClientId(context));
            out.write("_current_value");
            out.write("' value='");
            if (currentItems != null && currentItems.size() > 0) {
                out.write(currentItems.toString());
            }
            out.write("' />");
        }
    }

    protected abstract void renderPreWrappedComponent(FacesContext var1, ResponseWriter var2, UIMultiValueEditor var3) throws IOException;

    protected abstract void renderPostWrappedComponent(FacesContext var1, ResponseWriter var2, UIMultiValueEditor var3) throws IOException;

    protected void renderExistingItem(FacesContext context, UIComponent component, ResponseWriter out, NodeService nodeService, int index, Object value) throws IOException {
        out.write("<tr><td class='");
        if (this.highlightedRow) {
            out.write("selectedItemsRowAlt");
        } else {
            out.write("selectedItemsRow");
        }
        out.write("'>");
        if (value instanceof NodeRef) {
            out.write(Utils.encode((String)Repository.getNameForNode(nodeService, (NodeRef)value)));
        } else if (value instanceof Date) {
            XMLDateConverter converter = (XMLDateConverter)context.getApplication().createConverter("org.alfresco.faces.XMLDateConverter");
            UIComponent childComponent = (UIComponent)component.getChildren().get(0);
            Boolean showTime = (Boolean)childComponent.getAttributes().get("showTime");
            if (showTime != null && showTime.booleanValue()) {
                converter.setPattern(Application.getMessage(context, "date_time_pattern"));
            } else {
                converter.setPattern(Application.getMessage(context, "date_pattern"));
            }
            out.write(converter.getAsString(context, childComponent, value));
        } else if (value instanceof Boolean) {
            Converter converter = context.getApplication().createConverter("org.alfresco.faces.BooleanLabelConverter");
            out.write(converter.getAsString(context, (UIComponent)component.getChildren().get(0), value));
        } else {
            out.write(Utils.encode((String)value.toString()));
        }
        out.write("&nbsp;&nbsp;");
        out.write("</td><td class='");
        if (this.highlightedRow) {
            out.write("selectedItemsRowAlt");
        } else {
            out.write("selectedItemsRow");
        }
        out.write("'><a href='#' title='");
        out.write(Application.getMessage(context, MSG_REMOVE));
        out.write("' onclick=\"");
        out.write(this.generateFormSubmit(context, component, "0;" + index));
        out.write("\"><img src='");
        out.write(context.getExternalContext().getRequestContextPath());
        out.write("/images/icons/delete.gif' border='0' width='13' height='16'/></a>");
        this.highlightedRow = !this.highlightedRow;
    }

    protected String getHiddenFieldName(UIComponent component) {
        return component.getClientId(FacesContext.getCurrentInstance());
    }

    protected String generateFormSubmit(FacesContext context, UIComponent component, String action) {
        return Utils.generateFormSubmit(context, component, this.getHiddenFieldName(component), action);
    }
}

