/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.web.ui.wcm.component;

import java.io.IOException;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;
import javax.faces.application.Application;
import javax.faces.component.UIComponent;
import javax.faces.component.UIParameter;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import javax.faces.el.MethodBinding;
import javax.faces.el.ValueBinding;
import javax.transaction.UserTransaction;
import org.alfresco.model.ContentModel;
import org.alfresco.model.WCMWorkflowModel;
import org.alfresco.repo.avm.AVMNodeConverter;
import org.alfresco.repo.domain.PropertyValue;
import org.alfresco.repo.workflow.WorkflowModel;
import org.alfresco.service.cmr.dictionary.DataTypeDefinition;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.workflow.WorkflowTask;
import org.alfresco.service.cmr.workflow.WorkflowTaskQuery;
import org.alfresco.service.cmr.workflow.WorkflowTaskState;
import org.alfresco.service.namespace.QName;
import org.alfresco.util.Pair;
import org.alfresco.wcm.sandbox.SandboxConstants;
import org.alfresco.web.bean.repository.Repository;
import org.alfresco.web.bean.wcm.AVMUtil;
import org.alfresco.web.ui.common.Utils;
import org.alfresco.web.ui.common.component.UIActionLink;
import org.alfresco.web.ui.repo.component.UIActions;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.extensions.webscripts.ui.common.ConstantMethodBinding;
import org.springframework.extensions.webscripts.ui.common.component.SelfRenderingComponent;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UIPendingSubmissions
extends SelfRenderingComponent {
    private static final String ACT_SHOW_TASK = "showTask";
    private static final String ACT_DETAILS = "pending_details";
    private static final String ACT_PREVIEW = "pending_preview";
    private static final String ACT_DIFF = "pending_diff";
    private static final String ACT_PROMOTE = "pending_promote";
    private static final String ACT_ABORT = "pending_abort";
    private static final String REQUEST_TASKID = "_taskid";
    private static final String REQUEST_TASKTYPE = "_tasktype";
    private static final String REQUEST_LABEL = "_label";
    private static final String REQUEST_PREVIEW_REF = "_prevhref";
    private static final String REQUEST_WORKFLOWID = "_workflowid";
    private static Log logger = LogFactory.getLog(UIPendingSubmissions.class);
    private static final String MSG_LABEL = "label";
    private static final String MSG_DESCRIPTION = "description";
    private static final String MSG_SUBMITTED = "submitted";
    private static final String MSG_USERNAME = "username";
    private static final String MSG_LAUNCH_DATE = "launch_date";
    private static final String MSG_ACTIONS = "actions";
    private static final String MSG_NO_PENDING = "no_pending_submissions";
    private String value;

    public String getFamily() {
        return "org.alfresco.faces.PendingSubmissions";
    }

    public void restoreState(FacesContext context, Object state) {
        Object[] values = (Object[])state;
        super.restoreState(context, values[0]);
        this.value = (String)values[1];
    }

    public Object saveState(FacesContext context) {
        Object[] values = new Object[]{super.saveState(context), this.value};
        return values;
    }

    public boolean getRendersChildren() {
        return true;
    }

    public void encodeChildren(FacesContext context) throws IOException {
    }

    public void encodeBegin(FacesContext context) throws IOException {
        if (!this.isRendered()) {
            return;
        }
        ResponseWriter out = context.getResponseWriter();
        ResourceBundle bundle = org.alfresco.web.app.Application.getBundle(context);
        UserTransaction tx = null;
        try {
            tx = Repository.getUserTransaction(FacesContext.getCurrentInstance(), true);
            tx.begin();
            String sandbox = this.getValue();
            if (sandbox == null) {
                throw new IllegalArgumentException("Sandbox must be specified.");
            }
            String sandboxPreviewUrl = AVMUtil.getPreviewURI(sandbox);
            PropertyValue val = Repository.getServiceRegistry(context).getAVMService().getStoreProperty(sandbox, SandboxConstants.PROP_WEB_PROJECT_NODE_REF);
            NodeRef webProject = (NodeRef)val.getValue(DataTypeDefinition.NODE_REF);
            WorkflowTaskQuery query = new WorkflowTaskQuery();
            query.setTaskName(QName.createQName((String)"http://www.alfresco.org/model/wcmworkflow/1.0", (String)"submitpendingTask"));
            query.setTaskState(WorkflowTaskState.IN_PROGRESS);
            HashMap<QName, NodeRef> processProps = new HashMap<QName, NodeRef>();
            processProps.put(WCMWorkflowModel.ASSOC_WEBPROJECT, webProject);
            query.setProcessCustomProps(processProps);
            query.setOrderBy(new WorkflowTaskQuery.OrderBy[]{WorkflowTaskQuery.OrderBy.TaskDue_Desc, WorkflowTaskQuery.OrderBy.TaskActor_Asc});
            List pendingTasks = Repository.getServiceRegistry(context).getWorkflowService().queryTasks(query);
            if (pendingTasks.size() == 0) {
                out.write(bundle.getString(MSG_NO_PENDING));
            } else {
                out.write("<script type='text/javascript'>");
                out.write("\nfunction diff(pendingStoreUrl, stagingStoreUrl) {");
                out.write("\nwindow.open(pendingStoreUrl, 'pendingPreview', ");
                out.write("'left=40,top=150,width=450,height=300,scrollbars=yes,resizable=yes');");
                out.write("\nwindow.open(stagingStoreUrl, 'stagingPreview', ");
                out.write("'left=520,top=150,width=450,height=300,scrollbars=yes,resizable=yes');");
                out.write("\n}\n</script>");
                out.write("<table class='pendingSubmissionsList' cellspacing=2 cellpadding=1 border=0 width=100%>");
                out.write("<tr align=left><th>");
                out.write(bundle.getString(MSG_DESCRIPTION));
                out.write("</th><th>");
                out.write(bundle.getString(MSG_LABEL));
                out.write("</th><th>");
                out.write(bundle.getString(MSG_SUBMITTED));
                out.write("</th><th>");
                out.write(bundle.getString(MSG_USERNAME));
                out.write("</th><th>");
                out.write(bundle.getString(MSG_LAUNCH_DATE));
                out.write("</th><th>");
                out.write(bundle.getString(MSG_ACTIONS));
                out.write("</th></tr>");
                Map requestMap = context.getExternalContext().getRequestMap();
                for (WorkflowTask task : pendingTasks) {
                    String desc = (String)task.properties.get(WorkflowModel.PROP_DESCRIPTION);
                    String label = (String)task.properties.get(WCMWorkflowModel.PROP_LABEL);
                    String submitted = Utils.getDateTimeFormat(context).format(task.path.instance.startDate);
                    String username = (String)((Object)Repository.getServiceRegistry(context).getNodeService().getProperty(task.path.instance.initiator, ContentModel.PROP_USERNAME));
                    Date launchDate = (Date)task.properties.get(WCMWorkflowModel.PROP_LAUNCH_DATE);
                    String launch = Utils.getDateTimeFormat(context).format(launchDate);
                    out.write("<tr><td>");
                    UIActionLink showTask = this.findAction(ACT_SHOW_TASK, sandbox);
                    if (showTask == null) {
                        HashMap<String, String> params = new HashMap<String, String>(1);
                        params.put("id", "#{_taskid}");
                        params.put("type", "#{_tasktype}");
                        showTask = this.createAction(context, sandbox, ACT_SHOW_TASK, "#{_label}", null, "#{WorkflowBean.setupTaskDialog}", "dialog:manageTask", null, params);
                    }
                    requestMap.put(REQUEST_LABEL, desc);
                    requestMap.put(REQUEST_TASKID, task.id);
                    requestMap.put(REQUEST_TASKTYPE, task.definition.metadata.getName().toString());
                    Utils.encodeRecursive(context, (UIComponent)showTask);
                    requestMap.remove(REQUEST_LABEL);
                    requestMap.remove(REQUEST_TASKID);
                    requestMap.remove(REQUEST_TASKTYPE);
                    out.write("</td><td>");
                    out.write(Utils.encode((String)label));
                    out.write("</td><td>");
                    out.write(submitted);
                    out.write("</td><td>");
                    out.write(Utils.encode((String)username));
                    out.write("</td><td>");
                    out.write(launch);
                    out.write("</td><td><nobr>");
                    UIActionLink details = this.findAction(ACT_DETAILS, sandbox);
                    if (details == null) {
                        HashMap<String, String> params = new HashMap<String, String>(1);
                        params.put("id", "#{_taskid}");
                        params.put("type", "#{_tasktype}");
                        details = this.createAction(context, sandbox, ACT_DETAILS, null, "/images/icons/Details.gif", "#{WorkflowBean.setupTaskDialog}", "dialog:manageTask", null, params);
                    }
                    requestMap.put(REQUEST_TASKID, task.id);
                    requestMap.put(REQUEST_TASKTYPE, task.definition.metadata.getName().toString());
                    Utils.encodeRecursive(context, (UIComponent)details);
                    out.write("&nbsp;&nbsp;");
                    requestMap.remove(REQUEST_TASKID);
                    requestMap.remove(REQUEST_TASKTYPE);
                    NodeRef pkg = task.path.instance.workflowPackage;
                    Pair pkgPath = AVMNodeConverter.ToAVMVersionPath((NodeRef)pkg);
                    String workflowStore = AVMUtil.getStoreName((String)pkgPath.getSecond());
                    String workflowPreviewUrl = AVMUtil.getPreviewURI(workflowStore);
                    UIActionLink preview = this.findAction(ACT_PREVIEW, sandbox);
                    if (preview == null) {
                        preview = this.createAction(context, sandbox, ACT_PREVIEW, null, "/images/icons/preview_website.gif", null, null, "#{_prevhref}", null);
                    }
                    requestMap.put(REQUEST_PREVIEW_REF, workflowPreviewUrl);
                    Utils.encodeRecursive(context, (UIComponent)preview);
                    requestMap.remove(REQUEST_PREVIEW_REF);
                    out.write("&nbsp;&nbsp;");
                    out.write("<a href='#' onclick='diff(\"");
                    out.write(workflowPreviewUrl);
                    out.write("\",\"");
                    out.write(sandboxPreviewUrl);
                    out.write("\"); return false;'>");
                    out.write("<img border='0' align='absmiddle' title='");
                    out.write(org.alfresco.web.app.Application.getMessage(context, ACT_DIFF));
                    out.write("' alt='");
                    out.write(org.alfresco.web.app.Application.getMessage(context, ACT_DIFF));
                    out.write("' src='");
                    out.write(context.getExternalContext().getRequestContextPath());
                    out.write("/images/icons/diff.gif'/></a>&nbsp;&nbsp;");
                    UIActionLink promote = this.findAction(ACT_PROMOTE, sandbox);
                    if (promote == null) {
                        HashMap<String, String> params = new HashMap<String, String>(1);
                        params.put("taskId", "#{_taskid}");
                        promote = this.createAction(context, sandbox, ACT_PROMOTE, null, "/images/icons/promote_submission.gif", "#{AVMBrowseBean.promotePendingSubmission}", null, null, params);
                    }
                    requestMap.put(REQUEST_TASKID, task.id);
                    Utils.encodeRecursive(context, (UIComponent)promote);
                    requestMap.remove(REQUEST_TASKID);
                    out.write("&nbsp;&nbsp;");
                    UIActionLink abort = this.findAction(ACT_ABORT, sandbox);
                    if (abort == null) {
                        HashMap<String, String> params = new HashMap<String, String>(1);
                        params.put("workflowInstanceId", "#{_workflowid}");
                        abort = this.createAction(context, sandbox, ACT_ABORT, null, "/images/icons/abort_submission.gif", "#{AVMBrowseBean.cancelPendingSubmission}", null, null, params);
                    }
                    requestMap.put(REQUEST_WORKFLOWID, task.path.instance.id);
                    Utils.encodeRecursive(context, (UIComponent)abort);
                    requestMap.remove(REQUEST_WORKFLOWID);
                    out.write("&nbsp;&nbsp;");
                    out.write("</nobr></td></tr>");
                }
                out.write("</table>");
            }
            tx.commit();
        }
        catch (Throwable err) {
            try {
                if (tx != null) {
                    tx.rollback();
                }
            }
            catch (Exception tex) {
                // empty catch block
            }
            throw new RuntimeException(err);
        }
    }

    private UIActionLink findAction(String name, String sandbox) {
        UIActionLink action = null;
        String actionId = name + '_' + sandbox;
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Finding action Id: " + actionId));
        }
        for (UIComponent component : this.getChildren()) {
            if (!actionId.equals(component.getId())) continue;
            action = (UIActionLink)component;
            if (!logger.isDebugEnabled()) break;
            logger.debug((Object)("...found action Id: " + actionId));
            break;
        }
        return action;
    }

    private UIActionLink createAction(FacesContext fc, String sandbox, String name, String label, String icon, String actionListener, String outcome, String url, Map<String, String> params) {
        Application facesApp = fc.getApplication();
        UIActionLink control = (UIActionLink)facesApp.createComponent("org.alfresco.faces.ActionLink");
        String id = name + '_' + sandbox;
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("...creating action Id: " + id));
        }
        control.setRendererType("org.alfresco.faces.ActionLinkRenderer");
        control.setId(id);
        if (label == null) {
            control.setValue(org.alfresco.web.app.Application.getMessage(fc, name));
        } else {
            ValueBinding vb = facesApp.createValueBinding(label);
            control.setValueBinding("value", vb);
        }
        control.setShowLink(icon == null);
        control.setImage(icon);
        if (actionListener != null) {
            control.setActionListener(facesApp.createMethodBinding(actionListener, UIActions.ACTION_CLASS_ARGS));
            if (params == null) {
                UIParameter param = (UIParameter)facesApp.createComponent("javax.faces.Parameter");
                param.setId(id + "_1");
                param.setName("sandbox");
                param.setValue((Object)sandbox);
                control.getChildren().add(param);
            } else {
                int idIndex = 1;
                for (String key : params.keySet()) {
                    UIParameter param = (UIParameter)facesApp.createComponent("javax.faces.Parameter");
                    param.setId(id + '_' + Integer.toString(idIndex++));
                    param.setName(key);
                    String value = params.get(key);
                    if (value.startsWith("#{")) {
                        ValueBinding vb = facesApp.createValueBinding(value);
                        param.setValueBinding("value", vb);
                    } else {
                        param.setValue((Object)params.get(key));
                    }
                    control.getChildren().add(param);
                }
            }
        }
        if (outcome != null) {
            control.setAction((MethodBinding)new ConstantMethodBinding(outcome));
        }
        if (url != null) {
            if (url.startsWith("#{")) {
                ValueBinding vb = facesApp.createValueBinding(url);
                control.setValueBinding("href", vb);
            } else {
                control.setHref(url);
            }
            control.setTarget("new");
        }
        this.getChildren().add(control);
        return control;
    }

    public String getValue() {
        ValueBinding vb = this.getValueBinding("value");
        if (vb != null) {
            this.value = (String)vb.getValue(this.getFacesContext());
        }
        return this.value;
    }

    public void setValue(String value) {
        this.value = value;
    }
}

