/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.api;

import com.facebook.api.FacebookRestClient;
import java.util.EnumSet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class FacebookMethod
extends Enum<FacebookMethod>
implements CharSequence {
    public static final /* enum */ FacebookMethod AUTH_CREATE_TOKEN = new FacebookMethod("facebook.auth.createToken");
    public static final /* enum */ FacebookMethod AUTH_GET_SESSION = new FacebookMethod("facebook.auth.getSession", 1);
    public static final /* enum */ FacebookMethod FQL_QUERY = new FacebookMethod("facebook.fql.query", 1);
    public static final /* enum */ FacebookMethod EVENTS_GET = new FacebookMethod("facebook.events.get", 5);
    public static final /* enum */ FacebookMethod EVENTS_GET_MEMBERS = new FacebookMethod("facebook.events.getMembers", 1);
    public static final /* enum */ FacebookMethod FRIENDS_GET = new FacebookMethod("facebook.friends.get");
    public static final /* enum */ FacebookMethod FRIENDS_GET_APP_USERS = new FacebookMethod("facebook.friends.getAppUsers");
    public static final /* enum */ FacebookMethod FRIENDS_GET_REQUESTS = new FacebookMethod("facebook.friends.getRequests");
    public static final /* enum */ FacebookMethod FRIENDS_ARE_FRIENDS = new FacebookMethod("facebook.friends.areFriends", 2);
    public static final /* enum */ FacebookMethod USERS_GET_INFO = new FacebookMethod("facebook.users.getInfo", 2);
    public static final /* enum */ FacebookMethod USERS_GET_LOGGED_IN_USER = new FacebookMethod("facebook.users.getLoggedInUser");
    public static final /* enum */ FacebookMethod USERS_IS_APP_ADDED = new FacebookMethod("facebook.users.isAppAdded");
    public static final /* enum */ FacebookMethod PHOTOS_GET = new FacebookMethod("facebook.photos.get", 2);
    public static final /* enum */ FacebookMethod PHOTOS_GET_ALBUMS = new FacebookMethod("facebook.photos.getAlbums", 1);
    public static final /* enum */ FacebookMethod PHOTOS_GET_TAGS = new FacebookMethod("facebook.photos.getTags", 1);
    public static final /* enum */ FacebookMethod PHOTOS_CREATE_ALBUM = new FacebookMethod("facebook.photos.createAlbum", 3);
    public static final /* enum */ FacebookMethod PHOTOS_ADD_TAG = new FacebookMethod("facebook.photos.addTag", 5);
    public static final /* enum */ FacebookMethod PHOTOS_UPLOAD = new FacebookMethod("facebook.photos.upload", 3, true);
    public static final /* enum */ FacebookMethod NOTIFICATIONS_GET = new FacebookMethod("facebook.notifications.get");
    public static final /* enum */ FacebookMethod NOTIFICATIONS_SEND = new FacebookMethod("facebook.notifications.send", 5);
    public static final /* enum */ FacebookMethod NOTIFICATIONS_SEND_REQUEST = new FacebookMethod("facebook.notifications.sendRequest", 5);
    public static final /* enum */ FacebookMethod GROUPS_GET = new FacebookMethod("facebook.groups.get", 1);
    public static final /* enum */ FacebookMethod GROUPS_GET_MEMBERS = new FacebookMethod("facebook.groups.getMembers", 1);
    public static final /* enum */ FacebookMethod PROFILE_SET_FBML = new FacebookMethod("facebook.profile.setFBML", 2);
    public static final /* enum */ FacebookMethod PROFILE_GET_FBML = new FacebookMethod("facebook.profile.getFBML", 1);
    public static final /* enum */ FacebookMethod FBML_REFRESH_REF_URL = new FacebookMethod("facebook.fbml.refreshRefUrl", 1);
    public static final /* enum */ FacebookMethod FBML_REFRESH_IMG_SRC = new FacebookMethod("facebook.fbml.refreshImgSrc", 1);
    public static final /* enum */ FacebookMethod FEED_PUBLISH_ACTION_OF_USER = new FacebookMethod("facebook.feed.publishActionOfUser", 11);
    public static final /* enum */ FacebookMethod FEED_PUBLISH_STORY_TO_USER = new FacebookMethod("facebook.feed.publishStoryToUser", 11);
    private String methodName;
    private int numParams;
    private int maxParamsWithSession;
    private boolean takesFile;
    private static EnumSet<FacebookMethod> preAuth;
    private static EnumSet<FacebookMethod> postAuth;
    private static final /* synthetic */ FacebookMethod[] ENUM$VALUES;

    static {
        ENUM$VALUES = new FacebookMethod[]{AUTH_CREATE_TOKEN, AUTH_GET_SESSION, FQL_QUERY, EVENTS_GET, EVENTS_GET_MEMBERS, FRIENDS_GET, FRIENDS_GET_APP_USERS, FRIENDS_GET_REQUESTS, FRIENDS_ARE_FRIENDS, USERS_GET_INFO, USERS_GET_LOGGED_IN_USER, USERS_IS_APP_ADDED, PHOTOS_GET, PHOTOS_GET_ALBUMS, PHOTOS_GET_TAGS, PHOTOS_CREATE_ALBUM, PHOTOS_ADD_TAG, PHOTOS_UPLOAD, NOTIFICATIONS_GET, NOTIFICATIONS_SEND, NOTIFICATIONS_SEND_REQUEST, GROUPS_GET, GROUPS_GET_MEMBERS, PROFILE_SET_FBML, PROFILE_GET_FBML, FBML_REFRESH_REF_URL, FBML_REFRESH_IMG_SRC, FEED_PUBLISH_ACTION_OF_USER, FEED_PUBLISH_STORY_TO_USER};
        preAuth = null;
        postAuth = null;
    }

    public static EnumSet<FacebookMethod> preAuthMethods() {
        if (preAuth == null) {
            preAuth = EnumSet.of(AUTH_CREATE_TOKEN, AUTH_GET_SESSION);
        }
        return preAuth;
    }

    public static EnumSet<FacebookMethod> postAuthMethods() {
        if (postAuth == null) {
            postAuth = EnumSet.complementOf(FacebookMethod.preAuthMethods());
        }
        return postAuth;
    }

    private FacebookMethod(String name) {
        this(name, 0, false);
    }

    private FacebookMethod(String name, int maxParams) {
        this(name, maxParams, false);
    }

    private FacebookMethod(String name, int maxParams, boolean takesFile) {
        assert (name != null && name.length() != 0);
        this.methodName = name;
        this.numParams = maxParams;
        this.maxParamsWithSession = maxParams + FacebookRestClient.NUM_AUTOAPPENDED_PARAMS;
        this.takesFile = takesFile;
    }

    public String methodName() {
        return this.methodName;
    }

    public int numParams() {
        return this.numParams;
    }

    public boolean requiresSession() {
        return FacebookMethod.postAuthMethods().contains(this);
    }

    public int numTotalParams() {
        return this.requiresSession() ? this.maxParamsWithSession : this.numParams;
    }

    public boolean takesFile() {
        return this.takesFile;
    }

    @Override
    public char charAt(int index) {
        return this.methodName.charAt(index);
    }

    @Override
    public int length() {
        return this.methodName.length();
    }

    @Override
    public CharSequence subSequence(int start, int end) {
        return this.methodName.subSequence(start, end);
    }

    @Override
    public String toString() {
        return this.methodName;
    }

    public static FacebookMethod[] values() {
        FacebookMethod[] facebookMethodArray = ENUM$VALUES;
        int n = facebookMethodArray.length;
        FacebookMethod[] facebookMethodArray2 = new FacebookMethod[n];
        System.arraycopy(ENUM$VALUES, 0, facebookMethodArray2, 0, n);
        return facebookMethodArray2;
    }

    public static FacebookMethod valueOf(String string) {
        return Enum.valueOf(FacebookMethod.class, string);
    }
}

