/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.encoding;

import java.io.ByteArrayInputStream;
import java.io.InputStreamReader;
import java.nio.charset.Charset;
import org.alfresco.encoding.AbstractCharactersetFinder;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class BomCharactersetFinder
extends AbstractCharactersetFinder {
    private static Log logger = LogFactory.getLog(BomCharactersetFinder.class);

    public void setBufferSize(int bufferSize) {
        logger.warn((Object)("Setting the buffersize has no effect for charset finder: " + BomCharactersetFinder.class.getName()));
    }

    protected int getBufferSize() {
        return 64;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Charset detectCharsetImpl(byte[] buffer) throws Exception {
        Charset charset = null;
        ByteArrayInputStream bis = null;
        try {
            bis = new ByteArrayInputStream(buffer);
            bis.mark(3);
            char[] byteHeader = new char[3];
            InputStreamReader in = new InputStreamReader(bis);
            int bytesRead = in.read(byteHeader);
            bis.reset();
            charset = bytesRead < 2 ? Charset.forName("Cp1252") : (byteHeader[0] == '\u00fe' && byteHeader[1] == '\u00ff' ? Charset.forName("UTF-16BE") : (byteHeader[0] == '\u00ff' && byteHeader[1] == '\u00fe' ? Charset.forName("UTF-16LE") : (bytesRead >= 3 && byteHeader[0] == '\u00ef' && byteHeader[1] == '\u00bb' && byteHeader[2] == '\u00bf' ? Charset.forName("UTF-8") : null)));
            Charset charset2 = charset;
            return charset2;
        }
        finally {
            if (bis != null) {
                try {
                    bis.close();
                }
                catch (Throwable e) {}
            }
        }
    }
}

