/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.webservice.util;

import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Properties;
import javax.xml.rpc.ServiceException;
import org.alfresco.webservice.accesscontrol.AccessControlServiceLocator;
import org.alfresco.webservice.accesscontrol.AccessControlServiceSoapBindingStub;
import org.alfresco.webservice.action.ActionServiceLocator;
import org.alfresco.webservice.action.ActionServiceSoapBindingStub;
import org.alfresco.webservice.administration.AdministrationServiceLocator;
import org.alfresco.webservice.administration.AdministrationServiceSoapBindingStub;
import org.alfresco.webservice.authentication.AuthenticationServiceLocator;
import org.alfresco.webservice.authentication.AuthenticationServiceSoapBindingStub;
import org.alfresco.webservice.authoring.AuthoringServiceLocator;
import org.alfresco.webservice.authoring.AuthoringServiceSoapBindingStub;
import org.alfresco.webservice.classification.ClassificationServiceLocator;
import org.alfresco.webservice.classification.ClassificationServiceSoapBindingStub;
import org.alfresco.webservice.content.ContentServiceLocator;
import org.alfresco.webservice.content.ContentServiceSoapBindingStub;
import org.alfresco.webservice.dictionary.DictionaryServiceLocator;
import org.alfresco.webservice.dictionary.DictionaryServiceSoapBindingStub;
import org.alfresco.webservice.repository.RepositoryServiceLocator;
import org.alfresco.webservice.repository.RepositoryServiceSoapBindingStub;
import org.alfresco.webservice.util.AuthenticationUtils;
import org.alfresco.webservice.util.WebServiceException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public final class WebServiceFactory {
    private static Log logger = LogFactory.getLog(WebServiceFactory.class);
    private static final String PROPERTY_FILE_NAME = "alfresco/webserviceclient.properties";
    private static final String REPO_LOCATION = "repository.location";
    private static final String REPO_WEBAPP = "repository.webapp";
    private static volatile boolean loadedProperties = false;
    private static final String DEFAULT_ENDPOINT_ADDRESS = "http://localhost:8080/alfresco/api";
    private static String endPointAddress = "http://localhost:8080/alfresco/api";
    private static final String DEFAULT_REPO_WEBAPP = "alfresco";
    private static String endPointWebapp = "alfresco";
    private static int timeoutMilliseconds = 60000;
    private static final String AUTHENTICATION_SERVICE_ADDRESS = "/AuthenticationService";
    private static final String REPOSITORY_SERVICE_ADDRESS = "/RepositoryService";
    private static final String CONTENT_SERVICE_ADDRESS = "/ContentService";
    private static final String AUTHORING_SERVICE_ADDRESS = "/AuthoringService";
    private static final String CLASSIFICATION_SERVICE_ADDRESS = "/ClassificationService";
    private static final String ACTION_SERVICE_ADDRESS = "/ActionService";
    private static final String ACCESS_CONTROL_ADDRESS = "/AccessControlService";
    private static final String ADMINISTRATION_ADDRESS = "/AdministrationService";
    private static final String DICTIONARY_SERVICE_ADDRESS = "/DictionaryService";

    public static void setEndpointAddress(String endPointAddress) {
        WebServiceFactory.endPointAddress = endPointAddress;
    }

    public static void setTimeoutMilliseconds(int timeoutMilliseconds) {
        WebServiceFactory.timeoutMilliseconds = timeoutMilliseconds;
    }

    public static String getHost() {
        try {
            URL url = new URL(WebServiceFactory.getEndpointAddress());
            return url.getHost();
        }
        catch (MalformedURLException exception) {
            throw new RuntimeException("Unable to get host string", exception);
        }
    }

    public static int getPort() {
        try {
            URL url = new URL(WebServiceFactory.getEndpointAddress());
            return url.getPort();
        }
        catch (MalformedURLException exception) {
            throw new RuntimeException("Unable to get host string", exception);
        }
    }

    public static AuthenticationServiceSoapBindingStub getAuthenticationService() {
        AuthenticationServiceSoapBindingStub authenticationService = null;
        try {
            AuthenticationServiceLocator locator = new AuthenticationServiceLocator();
            locator.setAuthenticationServiceEndpointAddress(WebServiceFactory.getEndpointAddress() + AUTHENTICATION_SERVICE_ADDRESS);
            authenticationService = (AuthenticationServiceSoapBindingStub)locator.getAuthenticationService();
        }
        catch (ServiceException jre) {
            if (logger.isDebugEnabled() && jre.getLinkedCause() != null) {
                jre.getLinkedCause().printStackTrace();
            }
            throw new WebServiceException("Error creating authentication service: " + jre.getMessage(), jre);
        }
        authenticationService.setTimeout(timeoutMilliseconds);
        return authenticationService;
    }

    public static RepositoryServiceSoapBindingStub getRepositoryService() {
        return WebServiceFactory.getRepositoryService(WebServiceFactory.getEndpointAddress());
    }

    public static RepositoryServiceSoapBindingStub getRepositoryService(String endpointAddress) {
        RepositoryServiceSoapBindingStub repositoryService = null;
        try {
            RepositoryServiceLocator locator = new RepositoryServiceLocator(AuthenticationUtils.getEngineConfiguration());
            locator.setRepositoryServiceEndpointAddress(endpointAddress + REPOSITORY_SERVICE_ADDRESS);
            repositoryService = (RepositoryServiceSoapBindingStub)locator.getRepositoryService();
            repositoryService.setMaintainSession(true);
        }
        catch (ServiceException jre) {
            if (logger.isDebugEnabled() && jre.getLinkedCause() != null) {
                jre.getLinkedCause().printStackTrace();
            }
            throw new WebServiceException("Error creating repositoryService service: " + jre.getMessage(), jre);
        }
        repositoryService.setTimeout(timeoutMilliseconds);
        return repositoryService;
    }

    public static AuthoringServiceSoapBindingStub getAuthoringService() {
        return WebServiceFactory.getAuthoringService(WebServiceFactory.getEndpointAddress());
    }

    public static AuthoringServiceSoapBindingStub getAuthoringService(String endpointAddress) {
        AuthoringServiceSoapBindingStub authoringService = null;
        try {
            AuthoringServiceLocator locator = new AuthoringServiceLocator(AuthenticationUtils.getEngineConfiguration());
            locator.setAuthoringServiceEndpointAddress(endpointAddress + AUTHORING_SERVICE_ADDRESS);
            authoringService = (AuthoringServiceSoapBindingStub)locator.getAuthoringService();
            authoringService.setMaintainSession(true);
        }
        catch (ServiceException jre) {
            if (logger.isDebugEnabled() && jre.getLinkedCause() != null) {
                jre.getLinkedCause().printStackTrace();
            }
            throw new WebServiceException("Error creating authoring service: " + jre.getMessage(), jre);
        }
        authoringService.setTimeout(timeoutMilliseconds);
        return authoringService;
    }

    public static ClassificationServiceSoapBindingStub getClassificationService() {
        return WebServiceFactory.getClassificationService(WebServiceFactory.getEndpointAddress());
    }

    public static ClassificationServiceSoapBindingStub getClassificationService(String endpointAddress) {
        ClassificationServiceSoapBindingStub classificationService = null;
        try {
            ClassificationServiceLocator locator = new ClassificationServiceLocator(AuthenticationUtils.getEngineConfiguration());
            locator.setClassificationServiceEndpointAddress(endpointAddress + CLASSIFICATION_SERVICE_ADDRESS);
            classificationService = (ClassificationServiceSoapBindingStub)locator.getClassificationService();
            classificationService.setMaintainSession(true);
        }
        catch (ServiceException jre) {
            if (logger.isDebugEnabled() && jre.getLinkedCause() != null) {
                jre.getLinkedCause().printStackTrace();
            }
            throw new WebServiceException("Error creating classification service: " + jre.getMessage(), jre);
        }
        classificationService.setTimeout(timeoutMilliseconds);
        return classificationService;
    }

    public static ActionServiceSoapBindingStub getActionService() {
        return WebServiceFactory.getActionService(WebServiceFactory.getEndpointAddress());
    }

    public static ActionServiceSoapBindingStub getActionService(String endpointAddress) {
        ActionServiceSoapBindingStub actionService = null;
        try {
            ActionServiceLocator locator = new ActionServiceLocator(AuthenticationUtils.getEngineConfiguration());
            locator.setActionServiceEndpointAddress(endpointAddress + ACTION_SERVICE_ADDRESS);
            actionService = (ActionServiceSoapBindingStub)locator.getActionService();
            actionService.setMaintainSession(true);
        }
        catch (ServiceException jre) {
            if (logger.isDebugEnabled() && jre.getLinkedCause() != null) {
                jre.getLinkedCause().printStackTrace();
            }
            throw new WebServiceException("Error creating action service: " + jre.getMessage(), jre);
        }
        actionService.setTimeout(timeoutMilliseconds);
        return actionService;
    }

    public static ContentServiceSoapBindingStub getContentService() {
        return WebServiceFactory.getContentService(WebServiceFactory.getEndpointAddress());
    }

    public static ContentServiceSoapBindingStub getContentService(String endpointAddress) {
        ContentServiceSoapBindingStub contentService = null;
        try {
            ContentServiceLocator locator = new ContentServiceLocator(AuthenticationUtils.getEngineConfiguration());
            locator.setContentServiceEndpointAddress(endpointAddress + CONTENT_SERVICE_ADDRESS);
            contentService = (ContentServiceSoapBindingStub)locator.getContentService();
            contentService.setMaintainSession(true);
        }
        catch (ServiceException jre) {
            if (logger.isDebugEnabled() && jre.getLinkedCause() != null) {
                jre.getLinkedCause().printStackTrace();
            }
            throw new WebServiceException("Error creating content service: " + jre.getMessage(), jre);
        }
        contentService.setTimeout(timeoutMilliseconds);
        return contentService;
    }

    public static AccessControlServiceSoapBindingStub getAccessControlService() {
        return WebServiceFactory.getAccessControlService(WebServiceFactory.getEndpointAddress());
    }

    public static AccessControlServiceSoapBindingStub getAccessControlService(String enpointAddress) {
        AccessControlServiceSoapBindingStub accessControlService = null;
        try {
            AccessControlServiceLocator locator = new AccessControlServiceLocator(AuthenticationUtils.getEngineConfiguration());
            locator.setAccessControlServiceEndpointAddress(enpointAddress + ACCESS_CONTROL_ADDRESS);
            accessControlService = (AccessControlServiceSoapBindingStub)locator.getAccessControlService();
            accessControlService.setMaintainSession(true);
        }
        catch (ServiceException jre) {
            if (logger.isDebugEnabled() && jre.getLinkedCause() != null) {
                jre.getLinkedCause().printStackTrace();
            }
            throw new WebServiceException("Error creating access control service: " + jre.getMessage(), jre);
        }
        accessControlService.setTimeout(timeoutMilliseconds);
        return accessControlService;
    }

    public static AdministrationServiceSoapBindingStub getAdministrationService() {
        return WebServiceFactory.getAdministrationService(WebServiceFactory.getEndpointAddress());
    }

    public static AdministrationServiceSoapBindingStub getAdministrationService(String endpointAddress) {
        AdministrationServiceSoapBindingStub administrationService = null;
        try {
            AdministrationServiceLocator locator = new AdministrationServiceLocator(AuthenticationUtils.getEngineConfiguration());
            locator.setAdministrationServiceEndpointAddress(endpointAddress + ADMINISTRATION_ADDRESS);
            administrationService = (AdministrationServiceSoapBindingStub)locator.getAdministrationService();
            administrationService.setMaintainSession(true);
        }
        catch (ServiceException jre) {
            if (logger.isDebugEnabled() && jre.getLinkedCause() != null) {
                jre.getLinkedCause().printStackTrace();
            }
            throw new WebServiceException("Error creating administration service: " + jre.getMessage(), jre);
        }
        administrationService.setTimeout(timeoutMilliseconds);
        return administrationService;
    }

    public static DictionaryServiceSoapBindingStub getDictionaryService() {
        return WebServiceFactory.getDictionaryService(WebServiceFactory.getEndpointAddress());
    }

    public static DictionaryServiceSoapBindingStub getDictionaryService(String endpointAddress) {
        DictionaryServiceSoapBindingStub dictionaryService = null;
        try {
            DictionaryServiceLocator locator = new DictionaryServiceLocator(AuthenticationUtils.getEngineConfiguration());
            locator.setDictionaryServiceEndpointAddress(endpointAddress + DICTIONARY_SERVICE_ADDRESS);
            dictionaryService = (DictionaryServiceSoapBindingStub)locator.getDictionaryService();
            dictionaryService.setMaintainSession(true);
        }
        catch (ServiceException jre) {
            if (logger.isDebugEnabled() && jre.getLinkedCause() != null) {
                jre.getLinkedCause().printStackTrace();
            }
            throw new WebServiceException("Error creating dictionary service: " + jre.getMessage(), jre);
        }
        dictionaryService.setTimeout(timeoutMilliseconds);
        return dictionaryService;
    }

    private static synchronized void loadProperties(String propertyFileName) {
        if (loadedProperties) {
            return;
        }
        Properties props = new Properties();
        InputStream is = Thread.currentThread().getContextClassLoader().getResourceAsStream(PROPERTY_FILE_NAME);
        if (is != null) {
            try {
                props.load(is);
            }
            catch (Exception e) {
                logger.debug((Object)("Unable to load webservice client properties from " + propertyFileName + ": " + e.getMessage()));
            }
        }
        if (props.getProperty(REPO_LOCATION) != null) {
            endPointAddress = props.getProperty(REPO_LOCATION);
        }
        if (props.getProperty(REPO_WEBAPP) != null) {
            endPointWebapp = props.getProperty(REPO_WEBAPP);
        }
        loadedProperties = true;
    }

    public static String getEndpointAddress() {
        if (!loadedProperties) {
            WebServiceFactory.loadProperties(PROPERTY_FILE_NAME);
        }
        return endPointAddress;
    }

    public static String getEndpointWebapp() {
        if (!loadedProperties) {
            WebServiceFactory.loadProperties(PROPERTY_FILE_NAME);
        }
        return endPointWebapp;
    }
}

