/*
 * Decompiled with CFR 0.152.
 */
package info.bliki.html.wikipedia;

import info.bliki.html.wikipedia.ATag;
import info.bliki.html.wikipedia.CaptionTag;
import info.bliki.html.wikipedia.HTMLTag;
import info.bliki.html.wikipedia.IHTMLToWiki;
import info.bliki.html.wikipedia.ImgTag;
import info.bliki.html.wikipedia.ListTag;
import info.bliki.html.wikipedia.NoOutputTag;
import info.bliki.html.wikipedia.OpenCloseHTMLTag;
import info.bliki.html.wikipedia.OpenCloseTag;
import info.bliki.html.wikipedia.TableTag;
import info.bliki.html.wikipedia.TdTag;
import info.bliki.html.wikipedia.ThTag;
import info.bliki.html.wikipedia.TrTag;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.htmlcleaner.BaseToken;
import org.htmlcleaner.ContentToken;
import org.htmlcleaner.EndTagToken;
import org.htmlcleaner.TagNode;

public class ToWikipedia
implements IHTMLToWiki {
    private static final Map<String, HTMLTag> TAG_MAP = new HashMap<String, HTMLTag>();
    private final boolean fNoDiv;
    private final boolean fNoFont;

    static {
        TAG_MAP.put("a", new ATag());
        TAG_MAP.put("b", new OpenCloseTag("'''", "'''"));
        TAG_MAP.put("strong", new OpenCloseTag("'''", "'''"));
        TAG_MAP.put("i", new OpenCloseTag("''", "''"));
        TAG_MAP.put("em", new OpenCloseTag("''", "''"));
        TAG_MAP.put("table", new TableTag());
        TAG_MAP.put("caption", new CaptionTag());
        TAG_MAP.put("tr", new TrTag());
        TAG_MAP.put("td", new TdTag());
        TAG_MAP.put("th", new ThTag());
        TAG_MAP.put("img", new ImgTag());
        TAG_MAP.put("p", new OpenCloseTag("\n", "\n\n"));
        TAG_MAP.put("code", new OpenCloseTag("<code>", "</code>"));
        TAG_MAP.put("blockquote", new OpenCloseTag("<blockquote>", "</blockquote>"));
        TAG_MAP.put("u", new OpenCloseTag("<u>", "</u>"));
        TAG_MAP.put("s", new OpenCloseTag("<s>", "</s>"));
        TAG_MAP.put("sub", new OpenCloseTag("<sub>", "</sub>"));
        TAG_MAP.put("sup", new OpenCloseTag("<sup>", "</sup>"));
        TAG_MAP.put("div", new OpenCloseHTMLTag("\n<div", "\n</div>"));
        TAG_MAP.put("font", new OpenCloseHTMLTag("<font", "</font>"));
        TAG_MAP.put("pre", new OpenCloseTag("\n<pre>", "\n</pre>\n"));
        TAG_MAP.put("h1", new OpenCloseTag("\n= ", " =\n", true));
        TAG_MAP.put("h2", new OpenCloseTag("\n== ", " ==\n", true));
        TAG_MAP.put("h3", new OpenCloseTag("\n=== ", " ===\n", true));
        TAG_MAP.put("h4", new OpenCloseTag("\n==== ", " ====\n", true));
        TAG_MAP.put("h5", new OpenCloseTag("\n===== ", " =====\n", true));
        TAG_MAP.put("h6", new OpenCloseTag("\n====== ", " ======\n", true));
        TAG_MAP.put("ul", new ListTag("*"));
        TAG_MAP.put("ol", new ListTag("#"));
        TAG_MAP.put("script", new NoOutputTag());
    }

    public ToWikipedia(boolean noDiv, boolean noFont) {
        this.fNoDiv = noDiv;
        this.fNoFont = noFont;
    }

    public ToWikipedia() {
        this(false, false);
    }

    public void nodesToText(List nodes, StringBuilder resultBuffer) {
        if (nodes != null && !nodes.isEmpty()) {
            for (Object item : nodes) {
                if (item == null) continue;
                if (item instanceof List) {
                    this.nodesToText((List)item, resultBuffer);
                    continue;
                }
                if (item instanceof EndTagToken) {
                    EndTagToken node = (EndTagToken)item;
                    if (node.getName().equals("br")) {
                        resultBuffer.append("<br>");
                        continue;
                    }
                    if (!node.getName().equals("hr")) continue;
                    resultBuffer.append("\n----\n");
                    continue;
                }
                if (!(item instanceof BaseToken)) continue;
                this.nodeToWiki((BaseToken)item, resultBuffer);
            }
        }
    }

    public void nodeToWiki(BaseToken item, StringBuilder resultBuffer) {
        if (item instanceof ContentToken) {
            ContentToken contentToken = (ContentToken)item;
            resultBuffer.append(contentToken.getContent());
        } else if (item instanceof TagNode) {
            TagNode node = (TagNode)item;
            String name = node.getName();
            HTMLTag tag = TAG_MAP.get(name);
            if (tag != null) {
                boolean showWithoutTag = false;
                if (this.fNoDiv && node.getName().equals("div")) {
                    showWithoutTag = true;
                }
                if (this.fNoFont && node.getName().equals("font")) {
                    showWithoutTag = true;
                }
                tag.content(this, node, resultBuffer, showWithoutTag);
            } else {
                List children = node.getChildren();
                if (children.size() != 0) {
                    this.nodesToText(children, resultBuffer);
                }
            }
        }
    }
}

