/*
 * Decompiled with CFR 0.152.
 */
package info.bliki.wiki.filter;

import info.bliki.wiki.filter.WikipediaScanner;
import info.bliki.wiki.tags.util.WikiTagNode;
import org.htmlcleaner.Utils;

public abstract class AbstractParser
extends WikipediaScanner {
    protected char fCurrentCharacter;
    protected int fCurrentPosition;
    protected boolean fWhiteStart = false;
    protected int fWhiteStartPosition = 0;

    public AbstractParser(String stringSource) {
        super(stringSource);
    }

    protected final boolean readUntil(String untilString) {
        int index = this.fStringSource.indexOf(untilString, this.fCurrentPosition);
        if (index != -1) {
            this.fCurrentPosition = index + untilString.length();
            return true;
        }
        return false;
    }

    protected final boolean readUntilIgnoreCase(String startString, String endString) {
        int index = Utils.indexOfIgnoreCase(this.fStringSource, startString, endString, this.fCurrentPosition);
        if (index != -1) {
            this.fCurrentPosition = index + startString.length() + endString.length();
            return true;
        }
        return false;
    }

    protected final boolean readUntilChar(char testedChar) {
        int temp = this.fCurrentPosition;
        try {
            while ((this.fCurrentCharacter = this.fSource[this.fCurrentPosition++]) != testedChar) {
            }
            return true;
        }
        catch (IndexOutOfBoundsException e) {
            this.fCurrentPosition = temp;
            return false;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected final boolean readUntilEOL() {
        try {
            while (true) {
                this.fCurrentCharacter = this.fSource[this.fCurrentPosition++];
                if (this.fCurrentCharacter == '\n' || this.fCurrentCharacter == '\r') {
                    return true;
                }
                if (this.fCurrentCharacter != '<') continue;
                this.readSpecialWikiTags();
            }
        }
        catch (IndexOutOfBoundsException e) {
            --this.fCurrentPosition;
            return true;
        }
    }

    protected boolean readSpecialWikiTags() {
        block7: {
            String tagName;
            block9: {
                block8: {
                    WikiTagNode tagNode;
                    if (this.fSource[this.fCurrentPosition] == '/' || (tagNode = this.parseTag(this.fCurrentPosition)) == null) break block7;
                    tagName = tagNode.getTagName();
                    if (!tagName.equals("nowiki")) break block8;
                    if (this.readUntilIgnoreCase("</", "nowiki>")) {
                        return true;
                    }
                }
                if (!tagName.equals("source")) break block9;
                if (this.readUntilIgnoreCase("</", "source>")) {
                    return true;
                }
            }
            try {
                if (tagName.equals("math") && this.readUntilIgnoreCase("</", "math>")) {
                    return true;
                }
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                // empty catch block
            }
        }
        return false;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected boolean isEmptyLine(int diff) {
        int temp = this.fCurrentPosition - diff;
        try {
            while (true) {
                char ch;
                if (!Character.isWhitespace(ch = this.fSource[temp])) {
                    return false;
                }
                if (ch == '\n') {
                    return true;
                }
                ++temp;
            }
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            return true;
        }
    }

    protected int readWhitespaceUntilEndOfLine(int diff) {
        int temp = this.fCurrentPosition - diff;
        while (this.fSource.length > temp) {
            char ch = this.fSource[temp];
            if (!Character.isWhitespace(ch)) {
                return -1;
            }
            if (ch == '\n') {
                this.fCurrentPosition = temp;
                return temp;
            }
            ++temp;
        }
        this.fCurrentPosition = temp - 1;
        return temp;
    }

    protected int readWhitespaceUntilStartOfLine(int diff) {
        int temp = this.fCurrentPosition - diff;
        while (temp >= 0) {
            char ch = this.fSource[temp];
            if (!Character.isWhitespace(ch)) {
                return -1;
            }
            if (ch == '\n') {
                return temp;
            }
            --temp;
        }
        return temp;
    }
}

