/*
 * Decompiled with CFR 0.152.
 */
package info.bliki.wiki.filter;

import info.bliki.wiki.filter.ITextConverter;
import info.bliki.wiki.model.IWikiModel;
import info.bliki.wiki.model.ImageFormat;
import info.bliki.wiki.tags.HTMLTag;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import org.htmlcleaner.BaseToken;
import org.htmlcleaner.ContentToken;
import org.htmlcleaner.EndTagToken;
import org.htmlcleaner.TagNode;
import org.htmlcleaner.TagToken;
import org.htmlcleaner.Utils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HTMLConverter
implements ITextConverter {
    private boolean fNoLinks;

    public HTMLConverter(boolean noLinks) {
        this.fNoLinks = noLinks;
    }

    public HTMLConverter() {
        this(false);
    }

    @Override
    public void nodesToText(List<BaseToken> nodes, Appendable resultBuffer, IWikiModel model) throws IOException {
        if (nodes != null && !nodes.isEmpty()) {
            for (BaseToken item : nodes) {
                TagToken node;
                if (item == null) continue;
                if (item instanceof List) {
                    this.nodesToText((List)((Object)item), resultBuffer, model);
                    continue;
                }
                if (item instanceof ContentToken) {
                    ContentToken contentToken = (ContentToken)item;
                    String content = contentToken.getContent();
                    content = Utils.escapeXml(content, true, true, true);
                    resultBuffer.append(content);
                    continue;
                }
                if (item instanceof HTMLTag) {
                    ((HTMLTag)item).renderHTML(this, resultBuffer, model);
                    continue;
                }
                if (item instanceof TagNode) {
                    node = (TagNode)item;
                    Map<String, Object> map = ((TagNode)node).getObjectAttributes();
                    if (map != null && map.size() > 0) {
                        Object attValue = map.get("wikiobject");
                        if (!(attValue instanceof ImageFormat)) continue;
                        this.imageNodeToText((TagNode)node, (ImageFormat)attValue, resultBuffer, model);
                        continue;
                    }
                    this.nodeToHTML((TagNode)node, resultBuffer, model);
                    continue;
                }
                if (!(item instanceof EndTagToken)) continue;
                node = (EndTagToken)item;
                resultBuffer.append('<');
                resultBuffer.append(node.getName());
                resultBuffer.append("/>");
            }
        }
    }

    protected void nodeToHTML(TagNode node, Appendable resultBuffer, IWikiModel model) throws IOException {
        String name = node.getName();
        if (name.equals("div") || name.equals("p") || name.equals("table") || name.equals("ul") || name.equals("ol") || name.equals("li") || name.equals("th") || name.equals("tr") || name.equals("td") || name.equals("pre")) {
            resultBuffer.append('\n');
        }
        resultBuffer.append('<');
        resultBuffer.append(name);
        Map<String, String> tagAtttributes = node.getAttributes();
        for (String attName : tagAtttributes.keySet()) {
            if (attName.length() < 1 || !Character.isLetter(attName.charAt(0))) continue;
            String attValue = tagAtttributes.get(attName);
            resultBuffer.append(" " + attName + "=\"" + attValue + "\"");
        }
        List children = node.getChildren();
        if (children.size() == 0 && !name.equals("a")) {
            resultBuffer.append(" />");
        } else {
            resultBuffer.append('>');
            if (children.size() != 0) {
                this.nodesToText(children, resultBuffer, model);
            }
            resultBuffer.append("</");
            resultBuffer.append(node.getName());
            resultBuffer.append('>');
        }
    }

    @Override
    public void imageNodeToText(TagNode imageTagNode, ImageFormat imageFormat, Appendable resultBuffer, IWikiModel model) throws IOException {
        Map<String, String> map = imageTagNode.getAttributes();
        String caption = imageFormat.getCaption();
        if (caption != null && caption.length() > 0) {
            caption = Utils.escapeXml(caption, true, false, false);
        }
        String location = imageFormat.getLocation();
        String type = imageFormat.getType();
        int pxSize = imageFormat.getSize();
        if (pxSize != -1) {
            resultBuffer.append("<div style=\"");
            resultBuffer.append("wigth:");
            resultBuffer.append(Integer.toString(pxSize));
            resultBuffer.append("px");
            resultBuffer.append("\">");
        }
        resultBuffer.append("<a class=\"internal\" href=\"");
        resultBuffer.append(map.get("href"));
        resultBuffer.append("\" ");
        if (caption != null && caption.length() > 0) {
            resultBuffer.append("title=\"");
            resultBuffer.append(caption);
            resultBuffer.append('\"');
        }
        resultBuffer.append('>');
        resultBuffer.append("<img src=\"");
        resultBuffer.append(map.get("src"));
        resultBuffer.append("\"");
        if (caption != null && caption.length() > 0) {
            resultBuffer.append(" alt=\"").append(caption).append("\"");
            resultBuffer.append(" title=\"").append(caption).append("\"");
        }
        if (location != null || type != null) {
            StringBuilder clazz = new StringBuilder();
            resultBuffer.append(" class=\"");
            if (location != null) {
                clazz.append(" location-").append(location);
            }
            if (type != null) {
                clazz.append(" type-").append(type);
            }
            resultBuffer.append(clazz.toString().trim());
            resultBuffer.append("\"");
        }
        if (pxSize != -1) {
            resultBuffer.append(" width=\"").append(Integer.toString(pxSize)).append("px\"");
        }
        resultBuffer.append(" />\n");
        resultBuffer.append("</a>");
        List children = imageTagNode.getChildren();
        if (children.size() != 0) {
            this.nodesToText(children, resultBuffer, model);
        }
        if (pxSize != -1) {
            resultBuffer.append("</div>\n");
        }
    }

    @Override
    public boolean noLinks() {
        return this.fNoLinks;
    }
}

