/*
 * Decompiled with CFR 0.152.
 */
package info.bliki.wiki.filter;

import info.bliki.wiki.filter.WPCell;
import info.bliki.wiki.filter.WPList;
import info.bliki.wiki.filter.WPListElement;
import info.bliki.wiki.filter.WPRow;
import info.bliki.wiki.filter.WPTable;
import info.bliki.wiki.model.IWikiModel;
import info.bliki.wiki.tags.TableOfContentTag;
import info.bliki.wiki.tags.util.NodeAttribute;
import info.bliki.wiki.tags.util.WikiTagNode;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.htmlcleaner.Utils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WikipediaScanner {
    public static final String TAG_NAME = "$TAG_NAME";
    public static final int EOF = -1;
    protected final char[] fSource;
    protected int fScannerPosition;
    protected IWikiModel fWikiModel = null;
    protected final String fStringSource;

    public WikipediaScanner(String src) {
        this(src, 0);
    }

    public void setModel(IWikiModel wikiModel) {
        this.fWikiModel = wikiModel;
    }

    public WikipediaScanner(String src, int position) {
        this.fSource = src.toCharArray();
        this.fStringSource = src;
        this.fScannerPosition = position;
    }

    public int getPosition() {
        return this.fScannerPosition;
    }

    public void setPosition(int newPos) {
        this.fScannerPosition = newPos;
    }

    public WPTable wpTable(TableOfContentTag tableOfContentTag) {
        WPRow row;
        ArrayList<WPCell> cells;
        WPCell cell;
        WPTable table;
        block31: {
            block30: {
                table = null;
                cell = null;
                cells = new ArrayList<WPCell>();
                row = new WPRow(cells);
                if (this.fScannerPosition < 0) {
                    this.fScannerPosition = 0;
                }
                if (this.fSource[this.fScannerPosition++] == '{') break block30;
                return null;
            }
            if (this.fSource[this.fScannerPosition++] == '|') break block31;
            return null;
        }
        try {
            ArrayList<WPRow> rows = new ArrayList<WPRow>();
            table = new WPTable(rows);
            int startPos = this.fScannerPosition;
            this.nextNewline();
            table.setParams(new String(this.fSource, startPos, this.fScannerPosition - startPos));
            int ch = 32;
            while (true) {
                ch = this.fSource[this.fScannerPosition++];
                block3 : switch (ch) {
                    case 10: {
                        ch = this.fSource[this.fScannerPosition++];
                        block8 : switch (ch) {
                            case 124: {
                                if (cell != null) {
                                    cell.createTagStack(table, this.fStringSource, this.fWikiModel, this.fScannerPosition - 2);
                                    cell = null;
                                }
                                ch = this.fSource[this.fScannerPosition++];
                                switch (ch) {
                                    case 45: {
                                        this.addTableRow(table, row);
                                        cells = new ArrayList();
                                        row = new WPRow(cells);
                                        startPos = this.fScannerPosition;
                                        this.nextNewline();
                                        row.setParams(new String(this.fSource, startPos, this.fScannerPosition - startPos));
                                        break block8;
                                    }
                                    case 43: {
                                        this.addTableRow(table, row);
                                        cells = new ArrayList();
                                        row = new WPRow(cells);
                                        row.setType(4);
                                        cell = new WPCell(this.fScannerPosition);
                                        cell.setType(4);
                                        cells.add(cell);
                                        this.nextNewline();
                                        cell.createTagStack(table, this.fStringSource, this.fWikiModel, this.fScannerPosition);
                                        cell = null;
                                        this.addTableRow(table, row);
                                        cells = new ArrayList();
                                        row = new WPRow(cells);
                                        break block8;
                                    }
                                    case 125: {
                                        this.addTableRow(table, row);
                                        return table;
                                    }
                                }
                                --this.fScannerPosition;
                                cell = new WPCell(this.fScannerPosition);
                                cells.add(cell);
                                break;
                            }
                            case 33: {
                                if (cell != null) {
                                    cell.createTagStack(table, this.fStringSource, this.fWikiModel, this.fScannerPosition - 2);
                                    cell = null;
                                }
                                ch = this.fSource[this.fScannerPosition++];
                                cell = new WPCell(this.fScannerPosition - 1);
                                cell.setType(2);
                                cells.add(cell);
                                break;
                            }
                            case 123: {
                                if (this.fSource[this.fScannerPosition] != '|') break block3;
                                this.fScannerPosition = this.indexEndOfTable();
                                break;
                            }
                            default: {
                                --this.fScannerPosition;
                                break;
                            }
                        }
                        break;
                    }
                    case 124: {
                        ch = this.fSource[this.fScannerPosition++];
                        if (ch == 124) {
                            if (cell != null) {
                                cell.createTagStack(table, this.fStringSource, this.fWikiModel, this.fScannerPosition - 2);
                                cell = null;
                            }
                            cell = new WPCell(this.fScannerPosition);
                            cells.add(cell);
                            break;
                        }
                        --this.fScannerPosition;
                        break;
                    }
                    case 33: {
                        ch = this.fSource[this.fScannerPosition++];
                        if (ch == 33) {
                            if (cell != null) {
                                cell.createTagStack(table, this.fStringSource, this.fWikiModel, this.fScannerPosition - 2);
                                cell = null;
                            }
                            cell = new WPCell(this.fScannerPosition);
                            cell.setType(2);
                            cells.add(cell);
                            break;
                        }
                        --this.fScannerPosition;
                    }
                }
            }
        }
        catch (IndexOutOfBoundsException e) {
            this.fScannerPosition = this.fSource.length;
            if (cell != null) {
                cell.createTagStack(table, this.fStringSource, this.fWikiModel, this.fScannerPosition);
                cell = null;
            }
            if (table != null && row != null) {
                this.addTableRow(table, row);
            }
            if (table != null) {
                return table;
            }
            return null;
        }
    }

    private void addTableRow(WPTable table, WPRow row) {
        if (row.getParams() != null) {
            table.add(row);
        } else if (row.size() > 0) {
            table.add(row);
        }
    }

    public WPList wpList() {
        WPList list = null;
        WPListElement listElement = null;
        try {
            char ch;
            if (this.fScannerPosition < 0) {
                this.fScannerPosition = 0;
                ch = '\n';
            } else {
                ch = this.fSource[this.fScannerPosition++];
            }
            list = new WPList();
            while (true) {
                int temp;
                if (ch == '\n' || this.fScannerPosition == 0) {
                    if (listElement != null) {
                        listElement.createTagStack(this.fSource, this.fWikiModel, this.fScannerPosition - 1);
                        list.add(listElement);
                        listElement = null;
                    }
                    ch = this.fSource[this.fScannerPosition++];
                    block1 : switch (ch) {
                        case '#': 
                        case '*': {
                            int startPos;
                            int count = 1;
                            while (this.fSource[this.fScannerPosition] == '*' || this.fSource[this.fScannerPosition] == '#') {
                                ++count;
                                ++this.fScannerPosition;
                            }
                            char[] sequence = new char[count];
                            System.arraycopy(this.fSource, this.fScannerPosition - count, sequence, 0, count);
                            int type = this.fSource[this.fScannerPosition - 1] == '#' ? 2 : 1;
                            do {
                                if (Character.isWhitespace(ch = this.fSource[this.fScannerPosition++])) continue;
                                startPos = this.fScannerPosition - 1;
                                listElement = new WPListElement(type, count, sequence, startPos);
                                break block1;
                            } while (ch != 10);
                            startPos = --this.fScannerPosition;
                            listElement = new WPListElement(type, count, sequence, startPos);
                            listElement.createTagStack(this.fSource, this.fWikiModel, startPos);
                            list.add(listElement);
                            listElement = null;
                            break;
                        }
                        default: {
                            return list;
                        }
                    }
                }
                if ((ch = this.fSource[this.fScannerPosition++]) != 60 || (temp = this.readSpecialWikiTags(this.fScannerPosition)) < 0) continue;
                this.fScannerPosition = temp;
                ch = this.fSource[this.fScannerPosition++];
            }
        }
        catch (IndexOutOfBoundsException e) {
            this.fScannerPosition = this.fSource.length + 1;
            if (list != null) {
                if (listElement != null) {
                    listElement.createTagStack(this.fSource, this.fWikiModel, this.fScannerPosition - 1);
                    list.add(listElement);
                    listElement = null;
                }
                return list;
            }
            return null;
        }
    }

    public int nextNewline() {
        while (this.fSource[this.fScannerPosition++] != '\n') {
        }
        return --this.fScannerPosition;
    }

    public int indexEndOfComment() {
        try {
            char ch;
            while ((ch = this.fSource[this.fScannerPosition++]) != '-' || this.fSource[this.fScannerPosition] != '-' || this.fSource[this.fScannerPosition + 1] != '>') {
            }
            return this.fScannerPosition + 2;
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            return -1;
        }
    }

    public int indexOf(char ch) {
        try {
            while (this.fSource[this.fScannerPosition++] != ch) {
            }
            return this.fScannerPosition - 1;
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            return -1;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public int indexOf(char ch, char stop) {
        try {
            while (true) {
                char c;
                if ((c = this.fSource[this.fScannerPosition]) == ch) {
                    return this.fScannerPosition;
                }
                if (c == stop) {
                    return -1;
                }
                ++this.fScannerPosition;
            }
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            return -1;
        }
    }

    public int indexEndOfNowiki() {
        try {
            char ch;
            while ((ch = this.fSource[this.fScannerPosition++]) != '<' || this.fSource[this.fScannerPosition] != '/' || this.fSource[this.fScannerPosition + 1] != 'n' || this.fSource[this.fScannerPosition + 2] != 'o' || this.fSource[this.fScannerPosition + 3] != 'w' || this.fSource[this.fScannerPosition + 4] != 'i' || this.fSource[this.fScannerPosition + 5] != 'k' || this.fSource[this.fScannerPosition + 6] != 'i' || this.fSource[this.fScannerPosition + 7] != '>') {
            }
            return this.fScannerPosition + 8;
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            return -1;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public int indexEndOfTable() {
        int count = 1;
        try {
            while (true) {
                char ch;
                if ((ch = this.fSource[this.fScannerPosition++]) == '<' && this.fSource[this.fScannerPosition] == '!' && this.fSource[this.fScannerPosition + 1] == '-' && this.fSource[this.fScannerPosition + 2] == '-') {
                    this.fScannerPosition = this.indexEndOfComment();
                    if (this.fScannerPosition != -1) continue;
                    return -1;
                }
                if (ch == '<' && this.fSource[this.fScannerPosition] == 'n' && this.fSource[this.fScannerPosition + 1] == 'o' && this.fSource[this.fScannerPosition + 2] == 'w' && this.fSource[this.fScannerPosition + 3] == 'i' && this.fSource[this.fScannerPosition + 4] == 'k' && this.fSource[this.fScannerPosition + 5] == 'i' && this.fSource[this.fScannerPosition + 6] == '>') {
                    this.fScannerPosition = this.indexEndOfNowiki();
                    if (this.fScannerPosition != -1) continue;
                    return -1;
                }
                if (ch == '\n' && this.fSource[this.fScannerPosition] == '|' && this.fSource[this.fScannerPosition + 1] == '}') {
                    if (--count != 0) continue;
                    return this.fScannerPosition + 2;
                }
                if (ch != '\n' || this.fSource[this.fScannerPosition] != '{' || this.fSource[this.fScannerPosition + 1] != '|') continue;
                ++count;
            }
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            return -1;
        }
    }

    /*
     * Enabled aggressive exception aggregation
     */
    public int indexOfAttributes() {
        try {
            char ch = this.fSource[this.fScannerPosition];
            while (true) {
                if (ch == '[') {
                    int countBrackets = 1;
                    ++this.fScannerPosition;
                    while (countBrackets > 0) {
                        if ((ch = this.fSource[this.fScannerPosition++]) == '[') {
                            ++countBrackets;
                            continue;
                        }
                        if (ch != ']') continue;
                        --countBrackets;
                    }
                    ch = this.fSource[this.fScannerPosition];
                    continue;
                }
                if (ch == '{') {
                    int countCurlyBrackets = 1;
                    ++this.fScannerPosition;
                    while (countCurlyBrackets > 0) {
                        if ((ch = this.fSource[this.fScannerPosition++]) == '{') {
                            ++countCurlyBrackets;
                            continue;
                        }
                        if (ch != '}') continue;
                        --countCurlyBrackets;
                    }
                    ch = this.fSource[this.fScannerPosition];
                    continue;
                }
                if (ch == '|') {
                    if (this.fSource[this.fScannerPosition + 1] == '|') {
                        return -1;
                    }
                    return this.fScannerPosition;
                }
                if (this.fSource[this.fScannerPosition] == '\n') {
                    return -1;
                }
                ch = this.fSource[++this.fScannerPosition];
            }
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            return -1;
        }
    }

    public void scanWhiteSpace() {
        while (Character.isWhitespace(this.fSource[this.fScannerPosition++])) {
        }
        --this.fScannerPosition;
    }

    public StringBuilder replaceTemplateParameters(String template, Map<String, String> fTemplateParameters) {
        StringBuilder buffer = null;
        int bufferStart = 0;
        try {
            int parameterStart = -1;
            while (true) {
                char ch;
                if ((ch = this.fSource[this.fScannerPosition++]) == '{' && this.fSource[this.fScannerPosition] == '{' && this.fSource[this.fScannerPosition + 1] == '{') {
                    this.fScannerPosition += 2;
                    parameterStart = this.fScannerPosition;
                    continue;
                }
                if (ch != '}' || parameterStart <= 0 || this.fScannerPosition >= this.fSource.length - 1 || this.fSource[this.fScannerPosition] != '}' || this.fSource[this.fScannerPosition + 1] != '}') continue;
                List<String> list = WikipediaScanner.splitByPipe(this.fSource, parameterStart, this.fScannerPosition - 1, null);
                if (list.size() > 0) {
                    String parameterString = list.get(0);
                    String value = null;
                    if (fTemplateParameters != null) {
                        value = fTemplateParameters.get(parameterString);
                    }
                    if (value == null && list.size() > 1) {
                        value = list.get(1);
                    }
                    if (value != null) {
                        if (buffer == null) {
                            buffer = new StringBuilder(template.length() + 128);
                        }
                        if (bufferStart < this.fScannerPosition) {
                            buffer.append(this.fSource, bufferStart, parameterStart - bufferStart - 3);
                        }
                        buffer.append(value);
                        bufferStart = this.fScannerPosition + 2;
                    }
                }
                this.fScannerPosition += 2;
                parameterStart = -1;
            }
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            if (buffer != null && bufferStart < this.fScannerPosition) {
                buffer.append(this.fSource, bufferStart, this.fScannerPosition - bufferStart - 1);
            }
            return buffer;
        }
    }

    public static List<String> splitByPipe(char[] src, int currOffset, int endOffset, List<String> resultList) {
        if (resultList == null) {
            resultList = new ArrayList<String>();
        }
        int lastOffset = currOffset;
        try {
            while (currOffset < endOffset) {
                int temp;
                char ch;
                if ((ch = src[currOffset++]) == '[' && src[currOffset] == '[') {
                    if ((temp = WikipediaScanner.findNestedEnd(src, '[', ']', ++currOffset)) < 0) continue;
                    currOffset = temp;
                    continue;
                }
                if (ch == '{' && src[currOffset] == '{') {
                    if ((temp = WikipediaScanner.findNestedEnd(src, '{', '}', ++currOffset)) < 0) continue;
                    currOffset = temp;
                    continue;
                }
                if (ch != '|') continue;
                String value = new String(src, lastOffset, currOffset - lastOffset - 1).trim();
                resultList.add(value);
                lastOffset = currOffset;
            }
            if (currOffset > lastOffset) {
                resultList.add(new String(src, lastOffset, currOffset - lastOffset));
            } else if (currOffset == lastOffset) {
                resultList.add("");
            }
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            // empty catch block
        }
        return resultList;
    }

    public static final int findNestedEnd(char[] sourceArray, char startCh, char endChar, int startPosition) {
        int level = 1;
        int position = startPosition;
        try {
            while (true) {
                char ch;
                if ((ch = sourceArray[position++]) == startCh && sourceArray[position] == startCh) {
                    ++position;
                    ++level;
                    continue;
                }
                if (ch != endChar || sourceArray[position] != endChar) continue;
                ++position;
                if (--level == 0) break;
            }
            return position;
        }
        catch (IndexOutOfBoundsException e) {
            return -1;
        }
    }

    public static final int findNestedParamEnd(char[] sourceArray, char startCh, char endChar, int startPosition) {
        int level = 1;
        int position = startPosition;
        try {
            while (true) {
                char ch;
                if ((ch = sourceArray[position++]) == startCh && sourceArray[position] == startCh && sourceArray[position + 1] == startCh) {
                    position += 2;
                    ++level;
                    continue;
                }
                if (ch != endChar || sourceArray[position] != endChar || sourceArray[position + 1] != endChar) continue;
                position += 2;
                if (--level == 0) break;
            }
            return position;
        }
        catch (IndexOutOfBoundsException e) {
            return -1;
        }
    }

    protected final int findTemplateEnd(int startPosition) {
        int temp = WikipediaScanner.findNestedEnd(this.fSource, '{', '}', startPosition);
        if (temp >= 0) {
            return temp;
        }
        return -1;
    }

    protected final int findTemplateParameterEnd(int startPosition) {
        int temp = WikipediaScanner.findNestedParamEnd(this.fSource, '{', '}', startPosition);
        if (temp >= 0) {
            return temp;
        }
        return -1;
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected WikiTagNode parseTag(int start) {
        done = false;
        attributes = new ArrayList<NodeAttribute>();
        state = 0;
        this.fScannerPosition = start;
        bookmarks = new int[8];
        bookmarks[0] = this.fScannerPosition;
        try {
            block11: while (true) lbl-1000:
            // 27 sources

            {
                if (done) {
                    return this.makeTag(start, this.fScannerPosition, attributes);
                }
                bookmarks[state + 1] = this.fScannerPosition;
                ch = this.fSource[this.fScannerPosition++];
                switch (state) {
                    case 0: {
                        if ('\uffffffff' == ch || '>' == ch || '<' == ch) {
                            if ('<' == ch) {
                                bookmarks[state + 1] = --this.fScannerPosition;
                            }
                            this.whitespace(attributes, bookmarks);
                            done = true;
                            ** break;
                        }
                        if (Character.isWhitespace(ch)) continue block11;
                        this.whitespace(attributes, bookmarks);
                        state = 1;
                        ** break;
                    }
                    case 1: {
                        if ('\uffffffff' == ch || '>' == ch || '<' == ch) {
                            if ('<' == ch) {
                                bookmarks[state + 1] = --this.fScannerPosition;
                            }
                            this.standalone(attributes, bookmarks);
                            done = true;
                            ** break;
                        }
                        if (Character.isWhitespace(ch)) {
                            bookmarks[6] = bookmarks[2];
                            state = 6;
                            ** break;
                        }
                        if ('=' != ch) continue block11;
                        state = 2;
                        ** break;
                    }
                    case 2: {
                        if ('\uffffffff' == ch || '>' == ch) {
                            this.empty(attributes, bookmarks);
                            done = true;
                            ** break;
                        }
                        if ('\'' == ch) {
                            state = 4;
                            bookmarks[4] = bookmarks[3];
                            ** break;
                        }
                        if ('\"' == ch) {
                            state = 5;
                            bookmarks[5] = bookmarks[3];
                            ** break;
                        }
                        if (Character.isWhitespace(ch)) continue block11;
                        state = 3;
                        ** break;
                    }
                    case 3: {
                        if ('\uffffffff' == ch || '>' == ch) {
                            this.naked(attributes, bookmarks);
                            done = true;
                            ** break;
                        }
                        if (Character.isWhitespace(ch)) {
                            this.naked(attributes, bookmarks);
                            bookmarks[0] = bookmarks[4];
                            state = 0;
                            ** break;
                        }
                        if (ch != '/' || this.fSource[this.fScannerPosition] != '>') continue block11;
                        this.naked(attributes, bookmarks);
                        bookmarks[0] = bookmarks[4];
                        --this.fScannerPosition;
                        state = 0;
                        ** break;
                    }
                    case 4: {
                        if ('\uffffffff' == ch) {
                            this.single_quote(attributes, bookmarks);
                            done = true;
                            ** break;
                        }
                        if ('\'' != ch) continue block11;
                        this.single_quote(attributes, bookmarks);
                        bookmarks[0] = bookmarks[5] + 1;
                        state = 0;
                        ** break;
                    }
                    case 5: {
                        if ('\uffffffff' == ch) {
                            this.double_quote(attributes, bookmarks);
                            done = true;
                            ** break;
                        }
                        if ('\"' != ch) continue block11;
                        this.double_quote(attributes, bookmarks);
                        bookmarks[0] = bookmarks[6] + 1;
                        state = 0;
                        ** break;
                    }
                    case 6: {
                        if ('\uffffffff' == ch) {
                            this.standalone(attributes, bookmarks);
                            bookmarks[0] = bookmarks[6];
                            --this.fScannerPosition;
                            state = 0;
                            ** break;
                        }
                        if (Character.isWhitespace(ch)) continue block11;
                        if ('=' == ch) {
                            bookmarks[2] = bookmarks[6];
                            bookmarks[3] = bookmarks[7];
                            state = 2;
                            ** break;
                        }
                        this.standalone(attributes, bookmarks);
                        bookmarks[0] = bookmarks[6];
                        --this.fScannerPosition;
                        state = 0;
                        continue block11;
                    }
                }
                break;
            }
            throw new IllegalStateException("how did we get in state " + state);
        }
        catch (IndexOutOfBoundsException e) {
            if (state == 3) {
                this.naked(attributes, bookmarks);
            }
            return null;
        }
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected List<NodeAttribute> parseAttributes(int start, int end) {
        done = false;
        attributes = new ArrayList<NodeAttribute>();
        state = 0;
        this.fScannerPosition = start;
        bookmarks = new int[8];
        bookmarks[0] = this.fScannerPosition;
        try {
            block11: while (true) lbl-1000:
            // 26 sources

            {
                if (done || this.fScannerPosition >= end) {
                    if (state == 3 || state == 4 || state == 5) {
                        bookmarks[state + 1] = this.fScannerPosition;
                        this.naked(attributes, bookmarks);
                    }
                    return attributes;
                }
                bookmarks[state + 1] = this.fScannerPosition;
                ch = this.fSource[this.fScannerPosition++];
                switch (state) {
                    case 0: {
                        if ('\uffffffff' == ch || '>' == ch || '<' == ch) {
                            if ('<' == ch) {
                                bookmarks[state + 1] = --this.fScannerPosition;
                            }
                            this.whitespace(attributes, bookmarks);
                            done = true;
                            ** break;
                        }
                        if (Character.isWhitespace(ch)) continue block11;
                        this.whitespace(attributes, bookmarks);
                        state = 1;
                        ** break;
                    }
                    case 1: {
                        if ('\uffffffff' == ch || '>' == ch || '<' == ch) {
                            if ('<' == ch) {
                                bookmarks[state + 1] = --this.fScannerPosition;
                            }
                            this.standalone(attributes, bookmarks);
                            done = true;
                            ** break;
                        }
                        if (Character.isWhitespace(ch)) {
                            bookmarks[6] = bookmarks[2];
                            state = 6;
                            ** break;
                        }
                        if ('=' != ch) continue block11;
                        state = 2;
                        ** break;
                    }
                    case 2: {
                        if ('\uffffffff' == ch || '>' == ch) {
                            this.empty(attributes, bookmarks);
                            done = true;
                            ** break;
                        }
                        if ('\'' == ch) {
                            state = 4;
                            bookmarks[4] = bookmarks[3];
                            ** break;
                        }
                        if ('\"' == ch) {
                            state = 5;
                            bookmarks[5] = bookmarks[3];
                            ** break;
                        }
                        if (Character.isWhitespace(ch)) continue block11;
                        state = 3;
                        ** break;
                    }
                    case 3: {
                        if ('\uffffffff' == ch || '>' == ch) {
                            this.naked(attributes, bookmarks);
                            done = true;
                            ** break;
                        }
                        if (!Character.isWhitespace(ch)) continue block11;
                        this.naked(attributes, bookmarks);
                        bookmarks[0] = bookmarks[4];
                        state = 0;
                        ** break;
                    }
                    case 4: {
                        if ('\uffffffff' == ch) {
                            this.single_quote(attributes, bookmarks);
                            done = true;
                            ** break;
                        }
                        if ('\'' != ch) continue block11;
                        this.single_quote(attributes, bookmarks);
                        bookmarks[0] = bookmarks[5] + 1;
                        state = 0;
                        ** break;
                    }
                    case 5: {
                        if ('\uffffffff' == ch) {
                            this.double_quote(attributes, bookmarks);
                            done = true;
                            ** break;
                        }
                        if ('\"' != ch) continue block11;
                        this.double_quote(attributes, bookmarks);
                        bookmarks[0] = bookmarks[6] + 1;
                        state = 0;
                        ** break;
                    }
                    case 6: {
                        if ('\uffffffff' == ch) {
                            this.standalone(attributes, bookmarks);
                            bookmarks[0] = bookmarks[6];
                            --this.fScannerPosition;
                            state = 0;
                            ** break;
                        }
                        if (Character.isWhitespace(ch)) continue block11;
                        if ('=' == ch) {
                            bookmarks[2] = bookmarks[6];
                            bookmarks[3] = bookmarks[7];
                            state = 2;
                            ** break;
                        }
                        this.standalone(attributes, bookmarks);
                        bookmarks[0] = bookmarks[6];
                        --this.fScannerPosition;
                        state = 0;
                        continue block11;
                    }
                }
                break;
            }
            throw new IllegalStateException("how did we get in state " + state);
        }
        catch (IndexOutOfBoundsException var8_8) {
            return null;
        }
    }

    protected WikiTagNode makeTag(int start, int end, ArrayList<NodeAttribute> attributes) {
        int length = end - start;
        if (length != 0) {
            if (2 > length) {
                return null;
            }
            return new WikiTagNode(start, end, attributes);
        }
        return null;
    }

    private void whitespace(ArrayList<NodeAttribute> attributes, int[] bookmarks) {
    }

    private void standalone(ArrayList<NodeAttribute> attributes, int[] bookmarks) {
        attributes.add(new NodeAttribute(this.fSource, bookmarks[1], bookmarks[2], -1, -1, '\u0000'));
    }

    private void empty(ArrayList<NodeAttribute> attributes, int[] bookmarks) {
        attributes.add(new NodeAttribute(this.fSource, bookmarks[1], bookmarks[2], bookmarks[2] + 1, -1, '\u0000'));
    }

    private void naked(ArrayList<NodeAttribute> attributes, int[] bookmarks) {
        attributes.add(new NodeAttribute(this.fSource, bookmarks[1], bookmarks[2], bookmarks[3], bookmarks[4], '\u0000'));
    }

    private void single_quote(ArrayList<NodeAttribute> attributes, int[] bookmarks) {
        attributes.add(new NodeAttribute(this.fSource, bookmarks[1], bookmarks[2], bookmarks[4] + 1, bookmarks[5], '\''));
    }

    private void double_quote(ArrayList<NodeAttribute> attributes, int[] bookmarks) {
        attributes.add(new NodeAttribute(this.fSource, bookmarks[1], bookmarks[2], bookmarks[5] + 1, bookmarks[6], '\"'));
    }

    public static void main(String[] args) {
        String test = " href='www.test.org' color=red";
        WikipediaScanner scanner = new WikipediaScanner(test);
        List<NodeAttribute> attributes = scanner.parseAttributes(0, test.length());
        System.out.println(attributes);
    }

    protected int readSpecialWikiTags(int start) {
        try {
            WikiTagNode tagNode;
            if (this.fSource[start] != '/' && (tagNode = this.parseTag(start)) != null) {
                String tagName = tagNode.getTagName();
                if (tagName.equals("nowiki")) {
                    return this.readUntilIgnoreCase(this.fScannerPosition, "</", "nowiki>");
                }
                if (tagName.equals("source")) {
                    return this.readUntilIgnoreCase(this.fScannerPosition, "</", "source>");
                }
                if (tagName.equals("math")) {
                    return this.readUntilIgnoreCase(this.fScannerPosition, "</", "math>");
                }
            }
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            // empty catch block
        }
        return -1;
    }

    protected final int readUntilIgnoreCase(int start, String startString, String endString) {
        int index = Utils.indexOfIgnoreCase(this.fStringSource, startString, endString, start);
        if (index != -1) {
            return index + startString.length() + endString.length();
        }
        return -1;
    }
}

