/*
 * Decompiled with CFR 0.152.
 */
package info.bliki.wiki.tags;

import info.bliki.wiki.filter.ITextConverter;
import info.bliki.wiki.model.IWikiModel;
import info.bliki.wiki.model.Reference;
import info.bliki.wiki.tags.HTMLTag;
import java.io.IOException;
import java.util.List;

public class ReferencesTag
extends HTMLTag {
    public ReferencesTag() {
        super("references");
    }

    public void renderHTML(ITextConverter converter, Appendable writer, IWikiModel model) throws IOException {
        List<Reference> list = model.getReferences();
        if (list != null) {
            writer.append("<ol class=\"references\">\n");
            int i = 0;
            while (i < list.size()) {
                Reference ref = list.get(i);
                int counter = ref.getCounter();
                writer.append("<li id=\"_note-");
                if (counter == 0) {
                    String i1 = Integer.toString(i + 1);
                    writer.append(i1);
                    writer.append("\"><b><a href=\"#_ref-");
                    writer.append(i1);
                    writer.append("\" title=\"\">&uarr;</a></b> ");
                } else {
                    String nameAttribute = ref.getAttribute();
                    writer.append(nameAttribute);
                    writer.append("\">&uarr; ");
                    int j = 0;
                    while (j <= counter) {
                        char ch = j >= "abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRTSUVWXYZ".length() ? (char)'Z' : (char)"abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRTSUVWXYZ".charAt(j);
                        String note = String.valueOf(nameAttribute) + '_' + ch;
                        writer.append("<a href=\"#_ref-");
                        writer.append(note);
                        writer.append("\" title=\"\"><sup><i><b>" + ch + "</b></i></sup></a> ");
                        ++j;
                    }
                }
                writer.append(ref.getRefString());
                writer.append("</li>");
                ++i;
            }
            writer.append("</ol>");
        }
    }

    public boolean isReduceTokenStack() {
        return false;
    }

    public String getParents() {
        return "|applet|blockquote|body|button|center|dd|del|div|fieldset|form|iframe|ins|li|map|noframes|noscript|object|td|th|";
    }
}

