/*
 * Decompiled with CFR 0.152.
 */
package org.htmlcleaner;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.htmlcleaner.BaseToken;
import org.htmlcleaner.TagToken;
import org.htmlcleaner.XmlSerializer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TagNode
extends TagToken {
    private TagNode parent = null;
    private Map<String, String> attributes = new TreeMap<String, String>();
    private HashMap<String, Object> objectAttributes = null;
    private List children = new ArrayList();
    private List itemsToMove = null;
    private transient boolean isFormed = false;

    public TagNode() {
    }

    public TagNode(String name) {
        super(name.toLowerCase());
    }

    public Map<String, String> getAttributes() {
        return this.attributes;
    }

    public Map<String, Object> getObjectAttributes() {
        return this.objectAttributes;
    }

    public List getChildren() {
        return this.children;
    }

    public TagNode getParent() {
        return this.parent;
    }

    public void setParent(TagNode parent) {
        this.parent = parent;
    }

    @Override
    public void addAttribute(String attName, String attValue) {
        if (attName != null && !"".equals(attName.trim())) {
            this.attributes.put(attName.toLowerCase(), attValue == null ? "" : attValue);
        }
    }

    public void addObjectAttribute(String attName, Object attValue) {
        if (attName != null && attValue != null) {
            if (this.objectAttributes == null) {
                this.objectAttributes = new HashMap(4);
            }
            this.objectAttributes.put(attName, attValue);
        }
    }

    public void addChild(Object child) {
        this.children.add(child);
        if (child instanceof TagNode) {
            TagNode childTagNode = (TagNode)child;
            childTagNode.parent = this;
        }
    }

    public void addChildren(List children) {
        if (children != null) {
            for (BaseToken child : children) {
                this.addChild(child);
            }
        }
    }

    public void addItemForMoving(Object item) {
        if (this.itemsToMove == null) {
            this.itemsToMove = new ArrayList();
        }
        this.itemsToMove.add(item);
    }

    public List getItemsToMove() {
        return this.itemsToMove;
    }

    public void setItemsToMove(List itemsToMove) {
        this.itemsToMove = itemsToMove;
    }

    public boolean isFormed() {
        return this.isFormed;
    }

    public void setFormed() {
        this.isFormed = true;
    }

    @Override
    public void serialize(XmlSerializer xmlSerializer) throws IOException {
        xmlSerializer.serialize(this);
    }

    public TagNode makeCopy() {
        TagNode copy = new TagNode(this.name);
        copy.attributes = this.attributes;
        copy.objectAttributes = this.objectAttributes;
        return copy;
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        TagNode tt = (TagNode)super.clone();
        tt.parent = this.parent;
        tt.itemsToMove = this.itemsToMove;
        tt.isFormed = this.isFormed;
        tt.children = new ArrayList(this.children);
        tt.attributes = new TreeMap<String, String>(this.attributes);
        tt.objectAttributes = this.objectAttributes == null ? null : new HashMap<String, Object>(this.objectAttributes);
        return tt;
    }

    @Override
    public String getParents() {
        return null;
    }
}

