/*
 * Decompiled with CFR 0.152.
 */
package net.sf.ehcache.hibernate.management.impl;

import java.util.ArrayList;
import javax.management.MBeanNotificationInfo;
import javax.management.NotCompliantMBeanException;
import javax.management.Notification;
import javax.management.openmbean.CompositeData;
import javax.management.openmbean.TabularData;
import net.sf.ehcache.hibernate.management.api.HibernateStats;
import net.sf.ehcache.hibernate.management.impl.BaseEmitterBean;
import net.sf.ehcache.hibernate.management.impl.CacheRegionStats;
import net.sf.ehcache.hibernate.management.impl.CollectionStats;
import net.sf.ehcache.hibernate.management.impl.EntityStats;
import net.sf.ehcache.hibernate.management.impl.QueryStats;
import org.hibernate.SessionFactory;
import org.hibernate.stat.Statistics;

public class HibernateStatsImpl
extends BaseEmitterBean
implements HibernateStats {
    private static final double MILLIS_PER_SECOND = 1000.0;
    private static final MBeanNotificationInfo[] NOTIFICATION_INFO;
    private final Statistics statistics;

    public HibernateStatsImpl(SessionFactory sessionFactory) throws NotCompliantMBeanException {
        super(HibernateStats.class);
        this.statistics = sessionFactory.getStatistics();
    }

    public void clearStats() {
        this.statistics.clear();
        this.sendNotification("CacheStatisticsReset");
    }

    public void disableStats() {
        this.setStatisticsEnabled(false);
    }

    public void enableStats() {
        this.setStatisticsEnabled(true);
    }

    public long getCloseStatementCount() {
        return this.statistics.getCloseStatementCount();
    }

    public long getConnectCount() {
        return this.statistics.getConnectCount();
    }

    public long getDBSQLExecutionSample() {
        throw new UnsupportedOperationException("Use getQueryExecutionCount() instead");
    }

    public long getFlushCount() {
        return this.statistics.getFlushCount();
    }

    public long getOptimisticFailureCount() {
        return this.statistics.getOptimisticFailureCount();
    }

    public long getPrepareStatementCount() {
        return this.statistics.getPrepareStatementCount();
    }

    public long getQueryExecutionCount() {
        return this.statistics.getQueryExecutionCount();
    }

    public double getQueryExecutionRate() {
        long startTime = this.statistics.getStartTime();
        long now = System.currentTimeMillis();
        double deltaSecs = (double)(now - startTime) / 1000.0;
        return (double)this.getQueryExecutionCount() / deltaSecs;
    }

    public long getQueryExecutionSample() {
        throw new UnsupportedOperationException("TODO: need to impl. rates for query execution");
    }

    public long getSessionCloseCount() {
        return this.statistics.getSessionCloseCount();
    }

    public long getSessionOpenCount() {
        return this.statistics.getSessionOpenCount();
    }

    public long getSuccessfulTransactionCount() {
        return this.statistics.getSuccessfulTransactionCount();
    }

    public long getTransactionCount() {
        return this.statistics.getTransactionCount();
    }

    public boolean isStatisticsEnabled() {
        return this.statistics.isStatisticsEnabled();
    }

    public void setStatisticsEnabled(boolean flag) {
        this.statistics.setStatisticsEnabled(flag);
        this.sendNotification("CacheStatisticsEnabled", flag);
    }

    public TabularData getEntityStats() {
        ArrayList<CompositeData> result = new ArrayList<CompositeData>();
        for (String entity : this.statistics.getEntityNames()) {
            EntityStats entityStats = new EntityStats(entity, this.statistics.getEntityStatistics(entity));
            result.add(entityStats.toCompositeData());
        }
        TabularData td = EntityStats.newTabularDataInstance();
        td.putAll(result.toArray(new CompositeData[result.size()]));
        return td;
    }

    public TabularData getCollectionStats() {
        ArrayList<CompositeData> result = new ArrayList<CompositeData>();
        for (String roleName : this.statistics.getCollectionRoleNames()) {
            CollectionStats collectionStats = new CollectionStats(roleName, this.statistics.getCollectionStatistics(roleName));
            result.add(collectionStats.toCompositeData());
        }
        TabularData td = CollectionStats.newTabularDataInstance();
        td.putAll(result.toArray(new CompositeData[result.size()]));
        return td;
    }

    public TabularData getQueryStats() {
        ArrayList<CompositeData> result = new ArrayList<CompositeData>();
        for (String query : this.statistics.getQueries()) {
            QueryStats queryStats = new QueryStats(query, this.statistics.getQueryStatistics(query));
            result.add(queryStats.toCompositeData());
        }
        TabularData td = QueryStats.newTabularDataInstance();
        td.putAll(result.toArray(new CompositeData[result.size()]));
        return td;
    }

    public TabularData getCacheRegionStats() {
        ArrayList<CompositeData> result = new ArrayList<CompositeData>();
        for (String region : this.statistics.getSecondLevelCacheRegionNames()) {
            CacheRegionStats l2CacheStats = new CacheRegionStats(region, this.statistics.getSecondLevelCacheStatistics(region));
            result.add(l2CacheStats.toCompositeData());
        }
        TabularData td = CacheRegionStats.newTabularDataInstance();
        td.putAll(result.toArray(new CompositeData[result.size()]));
        return td;
    }

    public MBeanNotificationInfo[] getNotificationInfo() {
        return NOTIFICATION_INFO;
    }

    static {
        String[] notifTypes = new String[]{};
        String name = Notification.class.getName();
        String description = "Hibernate Statistics Event";
        NOTIFICATION_INFO = new MBeanNotificationInfo[]{new MBeanNotificationInfo(notifTypes, name, "Hibernate Statistics Event")};
    }
}

