/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.extensions.webscripts.bean;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import org.springframework.extensions.webscripts.DeclarativeWebScript;
import org.springframework.extensions.webscripts.PackageDescriptionDocument;
import org.springframework.extensions.webscripts.Path;
import org.springframework.extensions.webscripts.Registry;
import org.springframework.extensions.webscripts.ResourceDescription;
import org.springframework.extensions.webscripts.Status;
import org.springframework.extensions.webscripts.TypeDescription;
import org.springframework.extensions.webscripts.WebScript;
import org.springframework.extensions.webscripts.WebScriptException;
import org.springframework.extensions.webscripts.WebScriptRequest;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IndexPackageDoc
extends DeclarativeWebScript {
    protected Map<String, Object> executeImpl(WebScriptRequest req, Status status) {
        WebScript[] webscripts;
        Map templateVars = req.getServiceMatch().getTemplateVars();
        String packagePath = "/" + (String)templateVars.get("package");
        Registry registry = this.getContainer().getRegistry();
        Path path = registry.getPackage(packagePath);
        if (path == null) {
            throw new WebScriptException(404, "Web Script Package '" + packagePath + "' not found");
        }
        PackageDescriptionDocument packageDoc = registry.getPackageDescriptionDocument(packagePath);
        if (packageDoc == null) {
            throw new WebScriptException(500, "Web Script documentation for package '" + packagePath + "' not found");
        }
        HashMap<String, TypeDescription> schemas = new HashMap<String, TypeDescription>();
        for (WebScript webscript : webscripts = path.getScripts()) {
            TypeDescription[] responses;
            TypeDescription[] requests = webscript.getDescription().getRequestTypes();
            if (requests != null) {
                for (TypeDescription request : requests) {
                    if (request.getId() == null) continue;
                    schemas.put(request.getId(), request);
                }
            }
            if ((responses = webscript.getDescription().getResponseTypes()) == null) continue;
            for (TypeDescription response : responses) {
                if (response.getId() == null) continue;
                schemas.put(response.getId(), response);
            }
        }
        ArrayList<WebScript> unmappedWebScripts = new ArrayList<WebScript>(Arrays.asList(webscripts));
        ResourceDescription[] resources = packageDoc.getResourceDescriptions();
        if (resources != null) {
            for (ResourceDescription resource : resources) {
                String[] scriptIds;
                for (String scriptId : scriptIds = resource.getScriptIds()) {
                    WebScript webscript = registry.getWebScript(scriptId);
                    if (webscript == null) continue;
                    unmappedWebScripts.remove(webscript);
                }
            }
        }
        HashMap<String, Object> model = new HashMap<String, Object>(7, 1.0f);
        model.put("registry", registry);
        model.put("package", path);
        model.put("packagedoc", packageDoc);
        model.put("schemas", schemas.values());
        model.put("unmapped", unmappedWebScripts);
        return model;
    }
}

