/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.jlan.debug;

import org.alfresco.jlan.debug.Debug;
import org.alfresco.jlan.debug.DebugInterface;
import org.alfresco.jlan.server.config.ConfigSection;
import org.alfresco.jlan.server.config.InvalidConfigurationException;
import org.alfresco.jlan.server.config.ServerConfiguration;
import org.springframework.extensions.config.ConfigElement;

public class DebugConfigSection
extends ConfigSection {
    public static final String SectionName = "Debug";
    private DebugInterface m_debugDev;
    private ConfigElement m_debugParams;

    public DebugConfigSection(ServerConfiguration config) {
        super(SectionName, config);
    }

    public final DebugInterface getDebug() {
        return this.m_debugDev;
    }

    public final ConfigElement getDebugParameters() {
        return this.m_debugParams;
    }

    public final boolean hasDebug() {
        return this.m_debugDev != null;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final int setDebug(String dbgClass, ConfigElement params) throws InvalidConfigurationException {
        int sts = 0;
        try {
            if (dbgClass != null) {
                Object obj = Class.forName(dbgClass).newInstance();
                if (!(obj instanceof DebugInterface)) throw new InvalidConfigurationException("Debugclass does not implement the Debug interface");
                DebugInterface dbg = (DebugInterface)obj;
                dbg.initialize(params, this.getServerConfiguration());
                sts = this.fireConfigurationChange(589825, dbg);
                this.m_debugDev = dbg;
                this.m_debugParams = params;
                Debug.setDebugInterface(dbg);
                return sts;
            }
            this.m_debugDev = null;
            this.m_debugParams = null;
            return this.fireConfigurationChange(589825, null);
        }
        catch (ClassNotFoundException ex) {
            throw new InvalidConfigurationException("Debugclass not found, " + dbgClass);
        }
        catch (IllegalAccessException ex) {
            throw new InvalidConfigurationException("Cannot load debugclass " + dbgClass + ", access error");
        }
        catch (InstantiationException ex) {
            throw new InvalidConfigurationException("Cannot instantiate debugclass " + dbgClass);
        }
        catch (Exception ex) {
            throw new InvalidConfigurationException("Failed to initialize debug class, " + ex.toString());
        }
    }

    public void closeConfig() {
        if (this.m_debugDev != null) {
            this.m_debugDev.close();
            this.m_debugDev = null;
        }
    }
}

