/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.jlan.debug;

import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import org.alfresco.jlan.debug.DebugInterfaceBase;
import org.alfresco.jlan.server.config.ServerConfiguration;
import org.springframework.extensions.config.ConfigElement;

public class LogFileDebug
extends DebugInterfaceBase {
    private PrintStream m_out;

    public LogFileDebug() {
    }

    public LogFileDebug(String fname, boolean append) throws IOException {
        this.open(fname, append);
    }

    protected final void open(String fname, boolean append) throws IOException {
        FileOutputStream fout = new FileOutputStream(fname, append);
        this.m_out = new PrintStream(fout);
        System.setOut(this.m_out);
    }

    public void close() {
        if (this.m_out != null) {
            this.m_out.close();
            this.m_out = null;
        }
    }

    public void debugPrint(String str, int level) {
        if (level <= this.getLogLevel()) {
            this.m_out.print(str);
        }
    }

    public void debugPrintln(String str, int level) {
        if (level <= this.getLogLevel() && this.m_out != null) {
            this.m_out.println(str);
            this.m_out.flush();
        }
    }

    public void initialize(ConfigElement params, ServerConfiguration config) throws Exception {
        boolean append;
        super.initialize(params, config);
        ConfigElement logFile = params.getChild("logFile");
        boolean bl = append = params.getChild("append") != null;
        if (logFile.getValue() == null || logFile.getValue().length() == 0) {
            throw new Exception("logFile parameter not specified");
        }
        this.open(logFile.getValue(), append);
    }
}

