/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.jlan.netbios;

import java.io.IOException;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.UnknownHostException;
import org.alfresco.jlan.netbios.NetBIOSDatagramSocket;
import org.alfresco.jlan.netbios.NetBIOSName;
import org.alfresco.jlan.netbios.NetBIOSSession;
import org.alfresco.jlan.netbios.NetworkSettings;
import org.alfresco.jlan.util.DataPacker;

public class NetBIOSDatagram {
    public static final int DIRECT_UNIQUE = 16;
    public static final int DIRECT_GROUP = 17;
    public static final int BROADCAST = 18;
    public static final int DATAGRAM_ERROR = 19;
    public static final int DATAGRAM_QUERY = 20;
    public static final int POSITIVE_RESP = 21;
    public static final int NEGATIVE_RESP = 22;
    public static final int FLG_MOREFRAGMENTS = 1;
    public static final int FLG_FIRSTPKT = 2;
    public static final int DEFBUFSIZE = 4096;
    public static final int NB_MSGTYPE = 0;
    public static final int NB_FLAGS = 1;
    public static final int NB_DATAGRAMID = 2;
    public static final int NB_SOURCEIP = 4;
    public static final int NB_SOURCEPORT = 8;
    public static final int NB_DATAGRAMLEN = 10;
    public static final int NB_PKTOFFSET = 12;
    public static final int NB_FROMNAME = 14;
    public static final int NB_TONAME = 48;
    public static final int NB_USERDATA = 82;
    public static final int NB_MINLENGTH = 82;
    public static final int NB_MINSMBLEN = 100;
    protected byte[] m_buf;
    private static int m_nextId;

    public NetBIOSDatagram() {
        this.m_buf = new byte[4096];
    }

    public NetBIOSDatagram(byte[] pkt) {
        this.m_buf = pkt;
    }

    public NetBIOSDatagram(int bufSize) {
        this.m_buf = new byte[bufSize];
    }

    public static final synchronized int getNextDatagramId() {
        return m_nextId++;
    }

    public final byte[] getBuffer() {
        return this.m_buf;
    }

    public final int getDatagramId() {
        return DataPacker.getIntelShort(this.m_buf, 2);
    }

    public final NetBIOSName getDestinationName() {
        String name = NetBIOSSession.DecodeName(this.m_buf, 49);
        if (name != null) {
            NetBIOSName nbName = new NetBIOSName(name.substring(0, 14), name.charAt(15), false);
            if (this.getMessageType() == 17) {
                nbName.setGroup(true);
            }
            return nbName;
        }
        return null;
    }

    public final int getFlags() {
        return this.m_buf[1] & 0xFF;
    }

    public final int getLength() {
        return DataPacker.getShort(this.m_buf, 10);
    }

    public final int getDataLength() {
        return this.getLength() - 82;
    }

    public final int getMessageType() {
        return this.m_buf[0] & 0xFF;
    }

    public final byte[] getSourceIPAddress() {
        byte[] ipaddr = new byte[4];
        for (int i = 0; i < 4; ++i) {
            ipaddr[i] = this.m_buf[4 + i];
        }
        return ipaddr;
    }

    public final String getSourceAddress() {
        byte[] addr = this.getSourceIPAddress();
        StringBuffer addrStr = new StringBuffer();
        addrStr.append(addr[0]);
        addrStr.append(".");
        addrStr.append(addr[1]);
        addrStr.append(".");
        addrStr.append(addr[2]);
        addrStr.append(".");
        addrStr.append(addr[3]);
        return addrStr.toString();
    }

    public final NetBIOSName getSourceName() {
        String name = NetBIOSSession.DecodeName(this.m_buf, 15);
        if (name != null) {
            NetBIOSName nbName = new NetBIOSName(name.substring(0, 14), name.charAt(15), false);
            return nbName;
        }
        return null;
    }

    public final int getSourcePort() {
        return DataPacker.getIntelShort(this.m_buf, 8);
    }

    public final boolean isSMBData() {
        return this.m_buf[82] == -1 && this.m_buf[83] == 83 && this.m_buf[84] == 77 && this.m_buf[85] == 66 && this.getLength() >= 100;
    }

    public final String getMessageTypeString() {
        String typ = null;
        switch (this.getMessageType()) {
            case 17: {
                typ = "DIRECT GROUP";
                break;
            }
            case 16: {
                typ = "DIRECT UNIQUE";
                break;
            }
            case 19: {
                typ = "DATAGRAM ERROR";
                break;
            }
            case 20: {
                typ = "DATAGRAM QUERY";
                break;
            }
            case 18: {
                typ = "BROADCAST";
                break;
            }
            case 21: {
                typ = "POSITIVE RESP";
                break;
            }
            case 22: {
                typ = "NEGATIVE RESP";
                break;
            }
            default: {
                typ = "UNKNOWN";
            }
        }
        return typ;
    }

    public final void SendDatagram(int dgramTyp, String fromName, char fromNameType, String toName, char toNameType, byte[] userData, int userLen, int userOff, InetAddress addr, int port) throws IOException, UnknownHostException {
        this.setMessageType(dgramTyp);
        this.setSourceName(fromName, fromNameType);
        this.setDestinationName(toName, toNameType);
        this.setSourcePort(138);
        this.setSourceIPAddress(InetAddress.getLocalHost().getAddress());
        this.setFlags(2);
        if (m_nextId == 0) {
            m_nextId = (int)(System.currentTimeMillis() & 0x7FFFL);
        }
        this.setDatagramId(m_nextId++);
        this.setLength(userLen + 82);
        this.setUserData(userData, userLen, userOff);
        NetBIOSDatagramSocket nbSocket = NetBIOSDatagramSocket.getInstance();
        nbSocket.sendDatagram(this, addr, port);
    }

    public final void SendDatagram(int dgramTyp, String fromName, char fromNameType, String toName, char toNameType, byte[] userData, int userLen, int userOff) throws IOException, UnknownHostException {
        this.setMessageType(dgramTyp);
        this.setSourceName(fromName, fromNameType);
        this.setDestinationName(toName, toNameType);
        this.setSourcePort(138);
        this.setSourceIPAddress(InetAddress.getLocalHost().getAddress());
        this.setFlags(2);
        if (m_nextId == 0) {
            m_nextId = (int)(System.currentTimeMillis() & 0x7FFFL);
        }
        this.setDatagramId(m_nextId++);
        this.setLength(userLen + 82);
        this.setUserData(userData, userLen, userOff);
        NetBIOSDatagramSocket nbSocket = NetBIOSDatagramSocket.getInstance();
        nbSocket.sendBroadcastDatagram(this);
    }

    public final void SendDatagram(int dgramTyp, String fromName, String toName, byte[] userData, int userLen) throws IOException, UnknownHostException {
        this.SendDatagram(dgramTyp, fromName, ' ', toName, ' ', userData, userLen, 0);
    }

    public final void SendDatagram(int dgramTyp, DatagramSocket sock, String fromName, char fromNameType, String toName, char toNameType, byte[] userData, int userLen, int userOff) throws IOException {
        this.setMessageType(dgramTyp);
        this.setSourceName(fromName, fromNameType);
        this.setDestinationName(toName, toNameType);
        this.setSourcePort(138);
        this.setSourceIPAddress(InetAddress.getLocalHost().getAddress());
        this.setFlags(2);
        if (m_nextId == 0) {
            m_nextId = (int)(System.currentTimeMillis() & 0x7FFFL);
        }
        this.setDatagramId(m_nextId++);
        this.setLength(userLen + 82);
        this.setUserData(userData, userLen, userOff);
        InetAddress destAddr = InetAddress.getByName(NetworkSettings.GenerateBroadcastMask(null));
        DatagramPacket dgram = new DatagramPacket(this.m_buf, userLen + 82, destAddr, 138);
        sock.send(dgram);
    }

    public final void SendDatagram(int dgramTyp, DatagramSocket sock, String fromName, String toName, byte[] userData, int userLen) throws IOException {
        this.SendDatagram(dgramTyp, sock, fromName, ' ', toName, ' ', userData, userLen, 0);
    }

    public final void setDatagramId(int id) {
        DataPacker.putIntelShort(id, this.m_buf, 2);
    }

    public final void setDestinationName(String name) {
        this.setDestinationName(name, ' ');
    }

    public final void setDestinationName(String name, char typ) {
        NetBIOSSession.EncodeName(name, typ, this.m_buf, 48);
    }

    public final void setFlags(int flg) {
        this.m_buf[1] = (byte)(flg & 0xFF);
    }

    public final void setLength(int len) {
        DataPacker.putShort((short)len, this.m_buf, 10);
    }

    public final void setMessageType(int msg) {
        this.m_buf[0] = (byte)(msg & 0xFF);
    }

    public final void setSourceIPAddress(byte[] ipaddr) {
        for (int i = 0; i < 4; ++i) {
            this.m_buf[4 + i] = ipaddr[i];
        }
    }

    public final void setSourceName(String name) {
        NetBIOSSession.EncodeName(name, ' ', this.m_buf, 14);
    }

    public final void setSourceName(String name, char typ) {
        NetBIOSSession.EncodeName(name, typ, this.m_buf, 14);
    }

    public final void setSourcePort(int port) {
        DataPacker.putShort((short)port, this.m_buf, 8);
    }

    public final void setUserData(byte[] buf, int len) {
        System.arraycopy(buf, 0, this.m_buf, 82, len);
    }

    public final void setUserData(byte[] buf, int len, int off) {
        System.arraycopy(buf, off, this.m_buf, 82, len);
    }

    protected final void CommonInit() {
    }
}

