/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.jlan.server.auth.asn;

import java.io.IOException;
import org.alfresco.jlan.server.auth.asn.DERBuffer;
import org.alfresco.jlan.server.auth.asn.DERObject;

public class DEROctetString
extends DERObject {
    private byte[] m_string;

    public DEROctetString() {
    }

    public DEROctetString(byte[] byts) {
        this.m_string = byts;
    }

    public DEROctetString(String str) {
        this.m_string = str.getBytes();
    }

    public byte[] getValue() {
        return this.m_string;
    }

    public final String asString() {
        if (this.m_string != null) {
            return new String(this.m_string);
        }
        return null;
    }

    public void derDecode(DERBuffer buf) throws IOException {
        if (buf.unpackType() == 4) {
            int len = buf.unpackLength();
            this.m_string = (byte[])(len > 0 ? buf.unpackBytes(len) : null);
        } else {
            throw new IOException("Wrong DER type, expected OctetString");
        }
    }

    public void derEncode(DERBuffer buf) throws IOException {
        byte[] byts = this.m_string;
        buf.packByte(4);
        if (byts != null) {
            buf.packLength(byts.length);
            buf.packBytes(byts, 0, byts.length);
        } else {
            buf.packLength(0);
        }
    }

    public String toString() {
        StringBuffer str = new StringBuffer();
        str.append("[OctetString:");
        str.append(this.m_string != null ? this.m_string.length : 0);
        str.append("]");
        return str.toString();
    }
}

