/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.jlan.server.auth.kerberos;

import org.ietf.jgss.GSSName;

public class KerberosDetails {
    private String m_krbSource;
    private String m_krbTarget;
    private byte[] m_krbResponse;

    public KerberosDetails(GSSName source, GSSName target, byte[] response) {
        this.m_krbSource = ((Object)source).toString();
        this.m_krbTarget = ((Object)target).toString();
        this.m_krbResponse = response;
    }

    public final String getSourceName() {
        return this.m_krbSource;
    }

    public final String getTargetName() {
        return this.m_krbTarget;
    }

    public final byte[] getResponseToken() {
        return this.m_krbResponse;
    }

    public final void setResponseToken(byte[] tok) {
        this.m_krbResponse = tok;
    }

    public final String getUserName() {
        int pos;
        String userName = this.m_krbSource;
        if (this.m_krbSource != null && (pos = this.m_krbSource.indexOf(64)) != -1) {
            userName = this.m_krbSource.substring(0, pos);
        }
        return userName;
    }

    public final int getResponseLength() {
        return this.m_krbResponse != null ? this.m_krbResponse.length : 0;
    }

    public String toString() {
        StringBuffer str = new StringBuffer();
        str.append("[Source=");
        str.append(this.getSourceName());
        str.append(",Target=");
        str.append(this.getTargetName());
        str.append(":Response=");
        str.append(this.getResponseLength());
        str.append(" bytes]");
        return str.toString();
    }
}

