/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.jlan.server.filesys.db;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Date;
import java.util.Random;
import org.alfresco.jlan.debug.Debug;
import org.alfresco.jlan.locking.LockConflictException;
import org.alfresco.jlan.server.SrvSession;
import org.alfresco.jlan.server.core.DeviceContext;
import org.alfresco.jlan.server.core.DeviceContextException;
import org.alfresco.jlan.server.filesys.AccessDeniedException;
import org.alfresco.jlan.server.filesys.DiskDeviceContext;
import org.alfresco.jlan.server.filesys.DiskFullException;
import org.alfresco.jlan.server.filesys.DiskInterface;
import org.alfresco.jlan.server.filesys.DiskOfflineException;
import org.alfresco.jlan.server.filesys.DiskSizeInterface;
import org.alfresco.jlan.server.filesys.DiskVolumeInterface;
import org.alfresco.jlan.server.filesys.FileExistsException;
import org.alfresco.jlan.server.filesys.FileIdInterface;
import org.alfresco.jlan.server.filesys.FileInfo;
import org.alfresco.jlan.server.filesys.FileName;
import org.alfresco.jlan.server.filesys.FileNameException;
import org.alfresco.jlan.server.filesys.FileOpenParams;
import org.alfresco.jlan.server.filesys.FileSharingException;
import org.alfresco.jlan.server.filesys.FileStatus;
import org.alfresco.jlan.server.filesys.NetworkFile;
import org.alfresco.jlan.server.filesys.SearchContext;
import org.alfresco.jlan.server.filesys.SrvDiskInfo;
import org.alfresco.jlan.server.filesys.SymbolicLinkInterface;
import org.alfresco.jlan.server.filesys.TreeConnection;
import org.alfresco.jlan.server.filesys.VolumeInfo;
import org.alfresco.jlan.server.filesys.cache.FileState;
import org.alfresco.jlan.server.filesys.cache.FileStateCache;
import org.alfresco.jlan.server.filesys.db.CachedSearchContext;
import org.alfresco.jlan.server.filesys.db.DBDeviceContext;
import org.alfresco.jlan.server.filesys.db.DBException;
import org.alfresco.jlan.server.filesys.db.DBFileInfo;
import org.alfresco.jlan.server.filesys.db.DBInterface;
import org.alfresco.jlan.server.filesys.db.DBNetworkFile;
import org.alfresco.jlan.server.filesys.db.DBSearchContext;
import org.alfresco.jlan.server.filesys.db.RetentionDetails;
import org.alfresco.jlan.server.filesys.loader.NamedFileLoader;
import org.alfresco.jlan.server.filesys.quota.QuotaManager;
import org.alfresco.jlan.server.locking.FileLockingInterface;
import org.alfresco.jlan.server.locking.LockManager;
import org.alfresco.jlan.server.locking.OpLockInterface;
import org.alfresco.jlan.server.locking.OpLockManager;
import org.alfresco.jlan.smb.server.ntfs.NTFSStreamsInterface;
import org.alfresco.jlan.smb.server.ntfs.StreamInfo;
import org.alfresco.jlan.smb.server.ntfs.StreamInfoList;
import org.alfresco.jlan.util.MemorySize;
import org.alfresco.jlan.util.WildCard;
import org.springframework.extensions.config.ConfigElement;

public class DBDiskDriver
implements DiskInterface,
DiskSizeInterface,
DiskVolumeInterface,
NTFSStreamsInterface,
FileLockingInterface,
FileIdInterface,
SymbolicLinkInterface,
OpLockInterface {
    public static final String DBStreamList = "DBStreamList";
    public static final int DefaultNFSFileMode = 420;
    public static final int DefaultNFSDirMode = 493;
    public static final int MaxFileNameLen = 255;
    public static final long MaxTimestampValue = 1896134400000L;
    private boolean m_debug = false;

    public void closeFile(SrvSession sess, TreeConnection tree, NetworkFile file) throws IOException {
        DBDeviceContext dbCtx = (DBDeviceContext)tree.getContext();
        if (file.isStream()) {
            this.closeStream(sess, tree, file);
            if (file.hasDeleteOnClose()) {
                this.deleteStream(sess, tree, file.getFullNameStream());
            }
            return;
        }
        if (this.hasDebug()) {
            Debug.println("DB closeFile() file=" + file.getFullName());
        }
        dbCtx.getFileLoader().closeFile(sess, file);
        DBNetworkFile jdbcFile = null;
        if (file instanceof DBNetworkFile) {
            jdbcFile = (DBNetworkFile)file;
            FileState fstate = jdbcFile.getFileState();
            if (fstate == null) {
                fstate = this.getFileState(file.getFullName(), dbCtx, false);
            } else if (fstate.decrementOpenCount() == 0) {
                fstate.setSharedAccess(7);
            }
            if (jdbcFile.hasLocks()) {
                DBDiskDriver flIface = this;
                LockManager lockMgr = flIface.getLockManager(sess, tree);
                if (this.hasDebug()) {
                    Debug.println("Releasing locks for closed file, file=" + jdbcFile.getFullName() + ", locks=" + jdbcFile.numberOfLocks());
                }
                lockMgr.releaseLocksForFile(sess, tree, file);
            }
            if (fstate != null) {
                DBFileInfo finfo = (DBFileInfo)fstate.findAttribute("FileInfo");
                if (finfo != null && file.getWriteCount() > 0) {
                    finfo.setSize(jdbcFile.getFileSize());
                    finfo.setModifyDateTime(jdbcFile.getModifyDate());
                    if (this.hasDebug()) {
                        Debug.println("  File size=" + jdbcFile.getFileSize() + ", modifyDate=" + jdbcFile.getModifyDate());
                    }
                }
                if (this.hasDebug()) {
                    Debug.println("  Open count=" + jdbcFile.getFileState().getOpenCount());
                }
            }
            if (file.hasDeleteOnClose()) {
                if (file.isDirectory()) {
                    this.deleteDirectory(sess, tree, file.getFullName());
                } else {
                    this.deleteFile(sess, tree, file.getFullName());
                }
                if (this.hasDebug()) {
                    Debug.println("  Marked for delete");
                }
            }
        } else {
            Debug.println("closeFile() Not DBNetworkFile file=" + file);
        }
        if (file.getGrantedAccess() != 0 && !file.isDirectory() && file.getWriteCount() > 0) {
            if (this.hasDebug()) {
                Debug.println("  Update file size=" + file.getFileSize());
            }
            long modifiedTime = 0L;
            modifiedTime = file.hasModifyDate() ? file.getModifyDate() : System.currentTimeMillis();
            if (file.hasCreationDate() && modifiedTime < file.getCreationDate()) {
                modifiedTime = file.getCreationDate();
                if (this.hasDebug()) {
                    Debug.println("Close file using creation date/time for modified date/time");
                }
            }
            try {
                FileInfo finfo = new FileInfo();
                finfo.setFileSize(file.getFileSize());
                finfo.setModifyDateTime(modifiedTime);
                finfo.setFileInformationFlags(9);
                dbCtx.getDBInterface().setFileInformation(file.getDirectoryId(), file.getFileId(), finfo);
            }
            catch (DBException ex) {
                // empty catch block
            }
        }
    }

    public void createDirectory(SrvSession sess, TreeConnection tree, FileOpenParams params) throws IOException {
        int dirId;
        DBDeviceContext dbCtx = (DBDeviceContext)tree.getContext();
        if (!dbCtx.getDBInterface().isOnline()) {
            throw new DiskOfflineException("Database is offline");
        }
        FileState fstate = this.getFileState(params.getPath(), dbCtx, false);
        if (fstate != null && fstate.fileExists()) {
            throw new FileExistsException("Path " + params.getPath() + " exists");
        }
        if (fstate == null) {
            fstate = this.getFileState(params.getPath(), dbCtx, true);
            if (this.getFileDetails(params.getPath(), dbCtx, fstate) != null) {
                throw new FileExistsException("Path " + params.getPath() + " exists");
            }
        }
        if ((dirId = this.findParentDirectoryId(dbCtx, params.getPath(), true)) == -1) {
            throw new IOException("Cannot find parent directory");
        }
        try {
            RetentionDetails retDetails;
            String[] paths = FileName.splitPath(params.getPath());
            String dname = paths[1];
            if (dname != null && dname.length() > 255) {
                throw new FileNameException("Directory name too long, " + dname);
            }
            boolean retain = true;
            if (dbCtx.hasRetentionPeriod() && params.isDeleteOnClose()) {
                retain = false;
            }
            if (!params.hasMode()) {
                params.setMode(493);
            }
            if (!params.hasCreateOption(1)) {
                throw new IOException("Create directory called for non-directory");
            }
            int fid = dbCtx.getDBInterface().createFileRecord(dname, dirId, params, retain);
            fstate.setFileStatus(2);
            fstate.setFileId(fid);
            if (dbCtx.hasRetentionPeriod() && retain && (retDetails = dbCtx.getDBInterface().getFileRetentionDetails(dirId, fid)) != null) {
                fstate.setRetentionExpiryDateTime(retDetails.getEndTime());
            }
            if (fid != -1 && dbCtx.getFileLoader() instanceof NamedFileLoader) {
                NamedFileLoader namedLoader = (NamedFileLoader)((Object)dbCtx.getFileLoader());
                namedLoader.createDirectory(params.getPath(), fid);
            }
        }
        catch (Exception ex) {
            Debug.println(ex);
        }
    }

    public NetworkFile createFile(SrvSession sess, TreeConnection tree, FileOpenParams params) throws IOException {
        DBDeviceContext dbCtx = (DBDeviceContext)tree.getContext();
        if (!dbCtx.getDBInterface().isOnline()) {
            throw new DiskOfflineException("Database is offline");
        }
        params.setSession(sess);
        FileState fstate = this.getFileState(params.getPath(), dbCtx, true);
        if (params.isStream()) {
            if (this.fileExists(sess, tree, params.getPath()) == 1) {
                return this.createStream(sess, tree, params, fstate, dbCtx);
            }
            throw new FileNotFoundException("Parent file does not exist to create stream, " + params.getPath());
        }
        if (fstate.fileExists()) {
            throw new FileExistsException("File exists, " + params.getPath());
        }
        int dirId = this.findParentDirectoryId(dbCtx, params.getPath(), true);
        if (dirId == -1) {
            throw new IOException("Cannot find parent directory");
        }
        if (dbCtx.hasMaximumFileSize() && params.getAllocationSize() > dbCtx.getMaximumFileSize()) {
            throw new DiskFullException("Required allocation greater than maximum file size");
        }
        DBNetworkFile file = null;
        try {
            RetentionDetails retDetails;
            String[] paths = FileName.splitPath(params.getPath());
            String fname = paths[1];
            if (fname != null && fname.length() > 255) {
                throw new FileNameException("File name too long, " + fname);
            }
            boolean retain = true;
            if (dbCtx.hasRetentionPeriod() && params.isDeleteOnClose()) {
                retain = false;
            }
            if (!params.hasMode()) {
                params.setMode(420);
            }
            int fid = dbCtx.getDBInterface().createFileRecord(fname, dirId, params, retain);
            fstate.setFileStatus(1);
            fstate.setFileId(fid);
            if (dbCtx.hasRetentionPeriod() && retain && (retDetails = dbCtx.getDBInterface().getFileRetentionDetails(dirId, fid)) != null) {
                fstate.setRetentionExpiryDateTime(retDetails.getEndTime());
            }
            file = (DBNetworkFile)dbCtx.getFileLoader().openFile(params, fid, 0, dirId, true, false);
            file.setFullName(params.getPath());
            file.setDirectoryId(dirId);
            file.setAttributes(params.getAttributes());
            file.setFileState(fstate);
            file.openFile(true);
        }
        catch (DBException ex) {
            dbCtx.getStateCache().removeFileState(fstate.getPath());
            Debug.println("Create file error: " + ex.toString());
        }
        if (file == null) {
            throw new IOException("Failed to create file " + params.getPath());
        }
        fstate.setSharedAccess(params.getSharedAccess());
        fstate.setProcessId(params.getProcessId());
        fstate.incrementOpenCount();
        return file;
    }

    public void deleteDirectory(SrvSession sess, TreeConnection tree, String dir) throws IOException {
        DBFileInfo dinfo;
        DBDeviceContext dbCtx;
        if (this.hasDebug()) {
            Debug.println("DB deleteDirectory() dir=" + dir);
        }
        if (!(dbCtx = (DBDeviceContext)tree.getContext()).getDBInterface().isOnline()) {
            throw new DiskOfflineException("Database is offline");
        }
        FileState fstate = this.getFileState(dir, dbCtx, false);
        if (fstate != null && !fstate.fileExists()) {
            throw new FileNotFoundException("Path does not exist, " + dir);
        }
        if (fstate == null) {
            fstate = this.getFileState(dir, dbCtx, true);
        }
        if ((dinfo = this.getFileDetails(dir, dbCtx, fstate)) == null) {
            throw new FileNotFoundException(dir);
        }
        try {
            if (!dbCtx.isTrashCanEnabled() && dbCtx.getFileLoader() instanceof NamedFileLoader) {
                NamedFileLoader namedLoader = (NamedFileLoader)((Object)dbCtx.getFileLoader());
                namedLoader.deleteDirectory(dir, dinfo.getFileId());
            }
            dbCtx.getDBInterface().deleteFileRecord(dinfo.getDirectoryId(), dinfo.getFileId(), dbCtx.isTrashCanEnabled());
            fstate.setFileStatus(0);
            fstate.setFileId(-1);
            fstate.removeAttribute("FileInfo");
        }
        catch (DBException ex) {
            Debug.println(ex);
            throw new IOException();
        }
    }

    public void deleteFile(SrvSession sess, TreeConnection tree, String name) throws IOException {
        DBDeviceContext dbCtx = (DBDeviceContext)tree.getContext();
        if (!dbCtx.getDBInterface().isOnline()) {
            throw new DiskOfflineException("Database is offline");
        }
        if (FileName.containsStreamName(name)) {
            this.deleteStream(sess, tree, name);
            return;
        }
        FileState fstate = this.getFileState(name, dbCtx, false);
        if (fstate != null && !fstate.fileExists()) {
            throw new FileNotFoundException("File does not exist, " + name);
        }
        if (fstate == null) {
            fstate = this.getFileState(name, dbCtx, true);
        }
        try {
            StreamInfoList streamList;
            this.getRetentionDetailsForState(dbCtx, fstate);
            if (fstate.hasActiveRetentionPeriod()) {
                throw new AccessDeniedException("File retention active");
            }
            DBFileInfo dbInfo = this.getFileDetails(name, dbCtx, fstate);
            if (dbInfo == null) {
                throw new FileNotFoundException(name);
            }
            if (this.hasDebug()) {
                Debug.println("DBDiskDriver deleteFile() name=" + name + ", state=" + fstate);
            }
            if (!dbCtx.isTrashCanEnabled()) {
                dbCtx.getFileLoader().deleteFile(name, dbInfo.getFileId(), 0);
            }
            if (dbInfo.isFileType() == 3) {
                dbCtx.getDBInterface().deleteSymbolicLinkRecord(dbInfo.getDirectoryId(), dbInfo.getFileId());
            }
            if ((streamList = this.getStreamList(sess, tree, name)) != null && streamList.numberOfStreams() > 0) {
                StreamInfoList sList = new StreamInfoList(streamList);
                StringBuilder sPath = new StringBuilder(256);
                sPath.append(name);
                int delCnt = 0;
                for (int idx = 0; idx < sList.numberOfStreams(); ++idx) {
                    StreamInfo sInfo = sList.getStreamAt(idx);
                    if (sInfo.getName().equals("::$DATA")) continue;
                    sPath.setLength(name.length());
                    sPath.append(sInfo.getName());
                    this.deleteStream(sess, tree, sPath.toString());
                    ++delCnt;
                }
                if (this.hasDebug() && delCnt > 0) {
                    Debug.println("DBDiskDriver deleted " + delCnt + " streams for name=" + name);
                }
            }
            dbCtx.getDBInterface().deleteFileRecord(dbInfo.getDirectoryId(), dbInfo.getFileId(), dbCtx.isTrashCanEnabled());
            fstate.setFileStatus(0);
            fstate.setFileId(-1);
            fstate.removeAttribute("FileInfo");
            if (dbCtx.hasQuotaManager()) {
                dbCtx.getQuotaManager().releaseSpace(sess, tree, dbInfo.getFileId(), null, dbInfo.getSize());
            }
        }
        catch (DBException ex) {
            Debug.println(ex);
            throw new IOException();
        }
    }

    public int fileExists(SrvSession sess, TreeConnection tree, String name) {
        DBDeviceContext dbCtx = (DBDeviceContext)tree.getContext();
        int fileSts = 0;
        if (FileName.containsStreamName(name)) {
            FileInfo fInfo = null;
            try {
                fInfo = this.getFileInformation(sess, tree, name);
            }
            catch (IOException ex) {
                // empty catch block
            }
            if (fInfo != null) {
                fileSts = 1;
            }
            if (this.hasDebug()) {
                Debug.println("DB fileExists() nameWithStream=" + name + ", fileSts=" + FileStatus.asString(fileSts));
            }
        } else {
            FileState fstate = this.getFileState(name, dbCtx, true);
            fileSts = fstate.getFileStatus();
            if (fstate.getFileStatus() == -1) {
                DBFileInfo dbInfo = this.getFileDetails(name, dbCtx, fstate);
                if (dbInfo != null) {
                    fileSts = dbInfo.isDirectory() ? 2 : 1;
                } else {
                    fstate.setFileStatus(0);
                    fileSts = 0;
                }
                if (this.hasDebug()) {
                    Debug.println("DB fileExists() name=" + name + ", fileSts=" + FileStatus.asString(fileSts));
                }
            } else if (this.hasDebug()) {
                Debug.println("@@ Cache hit - fileExists() name=" + name + ", fileSts=" + FileStatus.asString(fileSts));
            }
        }
        return fileSts;
    }

    public void flushFile(SrvSession sess, TreeConnection tree, NetworkFile file) throws IOException {
        if (this.hasDebug()) {
            Debug.println("DB flushFile()");
        }
        file.flushFile();
    }

    public FileInfo getFileInformation(SrvSession sess, TreeConnection tree, String name) throws IOException {
        if (name == null) {
            return null;
        }
        DBDeviceContext dbCtx = (DBDeviceContext)tree.getContext();
        if (!dbCtx.getDBInterface().isOnline()) {
            throw new DiskOfflineException("Database is offline");
        }
        FileState fstate = null;
        FileInfo finfo = null;
        if (FileName.containsStreamName(name)) {
            fstate = this.getFileState(name, dbCtx, true);
            if (fstate != null) {
                finfo = (FileInfo)fstate.findAttribute("FileInfo");
            }
            if (finfo == null) {
                String[] paths;
                StreamInfo sInfo;
                StreamInfoList streams;
                DBFileInfo dbInfo;
                String filePath = FileName.getParentPathForStream(name);
                FileState parent = this.getFileState(filePath, dbCtx, false);
                if (parent == null) {
                    this.getFileInformation(sess, tree, filePath);
                    parent = this.getFileState(filePath, dbCtx, false);
                }
                if (parent != null && parent.fileExists() && (dbInfo = this.getFileDetails(name, dbCtx, parent)) != null && (streams = this.getStreamList(sess, tree, filePath)) != null && streams.numberOfStreams() > 0 && (sInfo = streams.findStream((paths = FileName.splitPathStream(name))[2])) != null) {
                    finfo = new DBFileInfo(paths[1], name, dbInfo.getFileId(), dbInfo.getDirectoryId());
                    finfo.setFileId(sInfo.getFileId());
                    finfo.setFileSize(sInfo.getSize());
                    finfo.setCreationDateTime(sInfo.getCreationDateTime());
                    finfo.setAccessDateTime(sInfo.getAccessDateTime());
                    finfo.setModifyDateTime(sInfo.getModifyDateTime());
                    fstate.addAttribute("FileInfo", finfo);
                    if (this.hasDebug()) {
                        Debug.println("getFileInformation() stream=" + name + ", info=" + finfo);
                    }
                }
            }
        } else {
            fstate = this.getFileState(name, dbCtx, true);
            DBFileInfo dbInfo = this.getFileDetails(name, dbCtx, fstate);
            if (dbInfo != null) {
                dbInfo.setFullName(name);
            }
            finfo = dbInfo;
        }
        if (this.hasDebug() && finfo != null) {
            Debug.println("getFileInformation info=" + finfo.toString());
        }
        return finfo;
    }

    public boolean isReadOnly(SrvSession sess, DeviceContext ctx) throws IOException {
        return false;
    }

    public NetworkFile openFile(SrvSession sess, TreeConnection tree, FileOpenParams params) throws IOException {
        DBDeviceContext dbCtx = (DBDeviceContext)tree.getContext();
        if (!dbCtx.getDBInterface().isOnline()) {
            throw new DiskOfflineException("Database is offline");
        }
        params.setSession(sess);
        FileState fstate = this.getFileState(params.getPath(), dbCtx, true);
        if (fstate != null && params.isStream()) {
            return this.openStream(sess, tree, params, fstate, dbCtx);
        }
        String[] paths = FileName.splitPath(params.getPath());
        String fname = paths[1];
        if (fname != null && fname.length() > 255) {
            throw new FileNameException("File name too long, " + fname);
        }
        DBFileInfo finfo = this.getFileDetails(params.getPath(), dbCtx, fstate);
        if (finfo == null) {
            throw new AccessDeniedException();
        }
        if (dbCtx.hasRetentionPeriod()) {
            try {
                RetentionDetails retDetails = dbCtx.getDBInterface().getFileRetentionDetails(finfo.getDirectoryId(), finfo.getFileId());
                if (retDetails != null) {
                    fstate.setRetentionExpiryDateTime(retDetails.getEndTime());
                }
            }
            catch (DBException ex) {
                throw new AccessDeniedException("Retention error, " + ex.getMessage());
            }
        }
        boolean nosharing = false;
        if (fstate.getOpenCount() > 0) {
            if (params.getSecurityLevel() == 2 && params.getProcessId() == fstate.getProcessId()) {
                nosharing = false;
            } else if (params.isReadOnlyAccess() && (fstate.getSharedAccess() & 1) != 0) {
                nosharing = false;
            } else {
                if ((params.isReadWriteAccess() || params.isWriteOnlyAccess()) && (fstate.getSharedAccess() & 2) == 0) {
                    if (this.hasDebug()) {
                        Debug.println("Sharing mode disallows write access path=" + params.getPath());
                    }
                    throw new AccessDeniedException("Sharing mode (write)");
                }
                if (fstate.getSharedAccess() == 0) {
                    nosharing = true;
                } else if ((fstate.getSharedAccess() & params.getSharedAccess()) != params.getSharedAccess()) {
                    nosharing = true;
                } else if (params.getSharedAccess() == 0) {
                    nosharing = true;
                }
            }
        }
        if (nosharing && !params.getPath().equals("\\")) {
            if (this.hasDebug()) {
                Debug.println("Sharing violation path=" + params.getPath() + ", sharing=0x" + Integer.toHexString(fstate.getSharedAccess()));
            }
            throw new FileSharingException("File already open, " + params.getPath());
        }
        fstate.setSharedAccess(params.getSharedAccess());
        fstate.setProcessId(params.getProcessId());
        if (fstate.getOpenCount() == 0 && this.hasDebug()) {
            Debug.println("Path " + params.getPath() + ", sharing=0x" + Integer.toHexString(params.getSharedAccess()) + ", PID=" + params.getProcessId());
        }
        if (this.hasDebug()) {
            Debug.println("DB openFile() name=" + params.getPath());
        }
        DBNetworkFile jdbcFile = (DBNetworkFile)dbCtx.getFileLoader().openFile(params, finfo.getFileId(), 0, finfo.getDirectoryId(), false, finfo.isDirectory());
        jdbcFile.setFileDetails(finfo);
        jdbcFile.setFileState(fstate);
        if (params.isReadOnlyAccess()) {
            jdbcFile.setGrantedAccess(0);
        } else if (params.isWriteOnlyAccess()) {
            jdbcFile.setGrantedAccess(1);
        } else {
            jdbcFile.setGrantedAccess(2);
        }
        if (sess != null) {
            jdbcFile.setOwnerSessionId(sess.getUniqueId());
        }
        fstate.setFileStatus(finfo.isDirectory() ? 2 : 1);
        fstate.incrementOpenCount();
        return jdbcFile;
    }

    public int readFile(SrvSession sess, TreeConnection tree, NetworkFile file, byte[] buf, int bufPos, int siz, long pos) throws IOException {
        DBDeviceContext dbCtx;
        if (this.hasDebug()) {
            Debug.println("DB readFile() filePos=" + pos + ", len=" + siz);
        }
        if (!(dbCtx = (DBDeviceContext)tree.getContext()).getDBInterface().isOnline()) {
            throw new DiskOfflineException("Database is offline");
        }
        int rxsiz = 0;
        if (file instanceof DBNetworkFile) {
            DBNetworkFile jfile = (DBNetworkFile)file;
            if (jfile.hasFileState() && jfile.getFileState().hasActiveLocks() && !jfile.getFileState().canReadFile(pos, siz, sess.getProcessId())) {
                throw new LockConflictException();
            }
            if (jfile.getFileState().getOpenCount() == 0) {
                Debug.println("**** readFile() Open Count Is ZERO ****");
            }
            if ((rxsiz = jfile.readFile(buf, siz, bufPos, pos)) == -1) {
                rxsiz = 0;
            }
        }
        return rxsiz;
    }

    public void renameFile(SrvSession sess, TreeConnection tree, String oldName, String newName) throws IOException {
        DBDeviceContext dbCtx;
        if (this.hasDebug()) {
            Debug.println("DB renameFile() from=" + oldName + " to=" + newName);
        }
        if (!(dbCtx = (DBDeviceContext)tree.getContext()).getDBInterface().isOnline()) {
            throw new DiskOfflineException("Database is offline");
        }
        FileState fstate = this.getFileState(oldName, dbCtx, true);
        try {
            int newDirId;
            DBFileInfo newInfo;
            String[] paths = FileName.splitPath(newName);
            String fname = paths[1];
            if (fname != null && fname.length() > 255) {
                throw new FileNameException("Destination name too long, " + fname);
            }
            this.getRetentionDetailsForState(dbCtx, fstate);
            if (fstate.hasActiveRetentionPeriod()) {
                throw new AccessDeniedException("File retention active");
            }
            int fid = fstate.getFileId();
            int dirId = -1;
            if (fid == -1) {
                dirId = this.findParentDirectoryId(dbCtx, oldName, true);
                if (dirId == -1) {
                    throw new FileNotFoundException(oldName);
                }
                String[] oldPaths = FileName.splitPath(oldName);
                fname = oldPaths[1];
                fid = this.getFileId(oldName, fname, dirId, dbCtx);
                if (fid == -1) {
                    throw new FileNotFoundException(oldName);
                }
                fstate.setFileId(fid);
            }
            DBFileInfo curInfo = this.getFileDetails(oldName, dbCtx, fstate);
            if (dirId == -1 && curInfo != null) {
                dirId = curInfo.getDirectoryId();
            }
            if ((newInfo = this.getFileDetails(newName, dbCtx)) != null) {
                throw new FileExistsException("Rename to file/folder already exists," + newName);
            }
            if (dbCtx.getFileLoader() instanceof NamedFileLoader) {
                NamedFileLoader namedLoader = (NamedFileLoader)((Object)dbCtx.getFileLoader());
                namedLoader.renameFileDirectory(oldName, fid, newName, curInfo.isDirectory());
            }
            if ((newDirId = this.findParentDirectoryId(dbCtx, newName, true)) == -1) {
                throw new FileNotFoundException(newName);
            }
            String[] newPaths = FileName.splitPath(newName);
            String newFname = newPaths[1];
            dbCtx.getDBInterface().renameFileRecord(dirId, fid, newFname, newDirId);
            dbCtx.getStateCache().renameFileState(newName, fstate, curInfo.isDirectory());
            fstate.removeAttribute("FileInfo");
        }
        catch (DBException ex) {
            throw new FileNotFoundException(oldName);
        }
    }

    public long seekFile(SrvSession sess, TreeConnection tree, NetworkFile file, long pos, int typ) throws IOException {
        if (this.hasDebug()) {
            Debug.println("DB seekFile()");
        }
        long newpos = 0L;
        if (file instanceof DBNetworkFile) {
            DBNetworkFile jfile = (DBNetworkFile)file;
            newpos = jfile.seekFile(pos, typ);
        }
        return newpos;
    }

    public void setFileInformation(SrvSession sess, TreeConnection tree, String name, FileInfo info) throws IOException {
        if (this.hasDebug()) {
            Debug.println("DB setFileInformation() name=" + name + ", info=" + info.toString());
        }
        if (info.getSetFileInformationFlags() == 1024) {
            return;
        }
        DBDeviceContext dbCtx = (DBDeviceContext)tree.getContext();
        if (!dbCtx.getDBInterface().isOnline()) {
            throw new DiskOfflineException("Database is offline");
        }
        FileState fstate = this.getFileState(name, dbCtx, true);
        DBFileInfo dbInfo = this.getFileDetails(name, dbCtx, fstate);
        if (dbInfo == null) {
            throw new FileNotFoundException(name);
        }
        try {
            int origFlags;
            this.getRetentionDetailsForState(dbCtx, fstate);
            if (fstate.hasActiveRetentionPeriod()) {
                throw new AccessDeniedException("File retention active");
            }
            if (dbCtx.getFileLoader() instanceof NamedFileLoader) {
                NamedFileLoader namedLoader = (NamedFileLoader)((Object)dbCtx.getFileLoader());
                namedLoader.setFileInformation(name, dbInfo.getFileId(), info);
            }
            int dbFlags = origFlags = info.getSetFileInformationFlags();
            if (info.hasSetFlag(32) && info.getAccessDateTime() > 1896134400000L) {
                dbFlags -= 32;
            }
            if (info.hasSetFlag(16) && info.getCreationDateTime() > 1896134400000L) {
                dbFlags -= 16;
            }
            if (info.hasSetFlag(8) && info.getModifyDateTime() > 1896134400000L) {
                dbFlags -= 8;
            }
            if (!info.hasChangeDateTime()) {
                info.setChangeDateTime(System.currentTimeMillis());
                if (!info.hasSetFlag(64)) {
                    info.setFileInformationFlags(info.getSetFileInformationFlags() + 64);
                }
            } else if (info.hasSetFlag(64) && info.getChangeDateTime() > 1896134400000L) {
                dbFlags -= 64;
            }
            info.setFileInformationFlags(dbFlags);
            if (dbFlags != 0) {
                dbCtx.getDBInterface().setFileInformation(dbInfo.getDirectoryId(), dbInfo.getFileId(), info);
            }
            info.setFileInformationFlags(origFlags);
            if (info.hasSetFlag(1)) {
                dbInfo.setFileSize(info.getSize());
            }
            if (info.hasSetFlag(2)) {
                dbInfo.setAllocationSize(info.getAllocationSize());
            }
            if (info.hasSetFlag(32)) {
                dbInfo.setAccessDateTime(info.getAccessDateTime());
            }
            if (info.hasSetFlag(16)) {
                dbInfo.setAccessDateTime(info.getCreationDateTime());
            }
            if (info.hasSetFlag(8)) {
                dbInfo.setAccessDateTime(info.getModifyDateTime());
            }
            if (info.hasSetFlag(64)) {
                dbInfo.setAccessDateTime(info.getChangeDateTime());
            }
            if (info.hasSetFlag(128)) {
                dbInfo.setGid(info.getGid());
            }
            if (info.hasSetFlag(256)) {
                dbInfo.setUid(info.getUid());
            }
            if (info.hasSetFlag(512)) {
                dbInfo.setMode(info.getMode());
            }
            if (info.hasSetFlag(4)) {
                dbInfo.setFileAttributes(info.getFileAttributes());
            }
            fstate.setFileId(dbInfo.getFileId());
        }
        catch (DBException ex) {
            throw new IOException();
        }
    }

    public SearchContext startSearch(SrvSession sess, TreeConnection tree, String searchPath, int attrib) throws FileNotFoundException {
        int dirId;
        DBDeviceContext dbCtx = (DBDeviceContext)tree.getContext();
        if (!dbCtx.getDBInterface().isOnline()) {
            throw new FileNotFoundException("Database is offline");
        }
        if (!searchPath.startsWith("\\")) {
            searchPath = "\\" + searchPath;
        }
        if ((dirId = this.findParentDirectoryId(dbCtx, searchPath, true)) == -1) {
            throw new FileNotFoundException("Invalid path");
        }
        SearchContext search = null;
        try {
            DBFileInfo finfo;
            FileState searchState;
            if (!WildCard.containsWildcards(searchPath) && (searchState = this.getFileState(searchPath, dbCtx, false)) != null && searchState.fileExists() && (finfo = (DBFileInfo)searchState.findAttribute("FileInfo")) != null) {
                search = new CachedSearchContext(finfo);
                if (this.hasDebug()) {
                    Debug.println("DB StartSearch using cached file information, path=" + searchPath + ", info=" + finfo);
                }
            }
            if (search == null) {
                DBSearchContext dbSearch = dbCtx.getDBInterface().startSearch(dirId, searchPath, attrib, 2, -1);
                dbSearch.setMarkAsOffline(dbCtx.hasOfflineFiles());
                dbSearch.setOfflineFileSize(dbCtx.getOfflineFileSize());
                search = dbSearch;
            }
        }
        catch (DBException ex) {
            throw new FileNotFoundException();
        }
        return search;
    }

    public void truncateFile(SrvSession sess, TreeConnection tree, NetworkFile file, long siz) throws IOException {
        if (this.hasDebug()) {
            Debug.println("DB truncateFile()");
        }
        if (file instanceof DBNetworkFile) {
            DBDeviceContext dbCtx = (DBDeviceContext)tree.getContext();
            DBNetworkFile jfile = (DBNetworkFile)file;
            FileState fstate = jfile.getFileState();
            DBFileInfo dbInfo = this.getFileDetails(jfile.getFullName(), dbCtx, fstate);
            if (dbInfo == null) {
                throw new FileNotFoundException(jfile.getFullName());
            }
            if (dbCtx.hasMaximumFileSize() && siz > dbCtx.getMaximumFileSize()) {
                file.setDeleteOnClose(true);
                throw new DiskFullException("Write is beyond maximum allowed file size");
            }
            long allocSize = 0L;
            long releaseSize = 0L;
            QuotaManager quotaMgr = dbCtx.getQuotaManager();
            if (dbCtx.hasQuotaManager()) {
                if (siz > dbInfo.getAllocationSize()) {
                    allocSize = siz - dbInfo.getAllocationSize();
                    quotaMgr.allocateSpace(sess, tree, file, allocSize);
                } else {
                    releaseSize = dbInfo.getAllocationSize() - siz;
                }
            }
            try {
                jfile.truncateFile(siz);
            }
            catch (IOException ex) {
                if (allocSize > 0L && quotaMgr != null) {
                    quotaMgr.releaseSpace(sess, tree, file.getFileId(), null, allocSize);
                }
                throw ex;
            }
            if (releaseSize > 0L && quotaMgr != null) {
                quotaMgr.releaseSpace(sess, tree, file.getFileId(), null, releaseSize);
            }
            if (allocSize > 0L) {
                dbInfo.setAllocationSize(dbInfo.getAllocationSize() + allocSize);
            } else if (releaseSize > 0L) {
                dbInfo.setAllocationSize(dbInfo.getAllocationSize() - releaseSize);
            }
            try {
                FileInfo finfo = new FileInfo();
                finfo.setChangeDateTime(System.currentTimeMillis());
                finfo.setFileInformationFlags(64);
                dbCtx.getDBInterface().setFileInformation(jfile.getDirectoryId(), jfile.getFileId(), finfo);
                dbInfo.setChangeDateTime(finfo.getChangeDateTime());
                dbInfo.setAllocationSize(siz);
            }
            catch (Exception ex) {
                // empty catch block
            }
        }
    }

    public int writeFile(SrvSession sess, TreeConnection tree, NetworkFile file, byte[] buf, int bufoff, int siz, long fileoff) throws IOException {
        DBDeviceContext dbCtx;
        if (this.hasDebug()) {
            Debug.println("DB writeFile()");
        }
        if (!(dbCtx = (DBDeviceContext)tree.getContext()).getDBInterface().isOnline()) {
            throw new DiskOfflineException("Database is offline");
        }
        if (file instanceof DBNetworkFile) {
            DBNetworkFile jfile = (DBNetworkFile)file;
            if (jfile.hasFileState() && jfile.getFileState().hasActiveLocks() && !jfile.getFileState().canWriteFile(fileoff, siz, sess.getProcessId())) {
                throw new LockConflictException();
            }
            if (dbCtx.hasMaximumFileSize() && fileoff + (long)siz > dbCtx.getMaximumFileSize()) {
                file.setDeleteOnClose(true);
                throw new DiskFullException("Write is beyond maximum allowed file size");
            }
            QuotaManager quotaMgr = dbCtx.getQuotaManager();
            if (quotaMgr != null) {
                DBFileInfo finfo = this.getFileDetails(jfile.getFullName(), dbCtx, jfile.getFileState());
                if (finfo == null) {
                    throw new FileNotFoundException(jfile.getFullName());
                }
                long extendSize = 0L;
                long endOfWrite = fileoff + (long)siz;
                if (endOfWrite > finfo.getSize()) {
                    extendSize = endOfWrite - finfo.getSize();
                    quotaMgr.allocateSpace(sess, tree, file, extendSize);
                }
                try {
                    jfile.writeFile(buf, siz, bufoff, fileoff);
                }
                catch (IOException ex) {
                    if (extendSize > 0L && quotaMgr != null) {
                        quotaMgr.releaseSpace(sess, tree, file.getFileId(), null, extendSize);
                    }
                    throw ex;
                }
                if (extendSize > 0L) {
                    finfo.setAllocationSize(MemorySize.roundupLongSize(endOfWrite));
                }
            } else {
                jfile.writeFile(buf, siz, bufoff, fileoff);
            }
        }
        return siz;
    }

    public DeviceContext createContext(String shareName, ConfigElement args) throws DeviceContextException {
        if (args.getChildCount() < 3) {
            throw new DeviceContextException("Not enough context arguments");
        }
        if (args.getChild("Debug") != null) {
            this.m_debug = true;
        }
        DBDeviceContext ctx = new DBDeviceContext(args);
        return ctx;
    }

    protected final DBFileInfo getFileDetails(String path, DBDeviceContext dbCtx) {
        return this.getFileDetails(path, dbCtx, null);
    }

    protected final DBFileInfo getFileDetails(String path, DBDeviceContext dbCtx, FileState fstate) {
        DBFileInfo finfo;
        if (fstate != null && (finfo = (DBFileInfo)fstate.findAttribute("FileInfo")) != null) {
            return finfo;
        }
        if (path.length() == 0 || path.compareTo("\\") == 0) {
            DBFileInfo rootDir = dbCtx.getRootDirectoryInfo();
            if (fstate != null) {
                fstate.setFileStatus(2);
            }
            return rootDir;
        }
        int dirId = this.findParentDirectoryId(dbCtx, path, true);
        if (dirId == -1) {
            return null;
        }
        String[] paths = FileName.splitPathStream(path);
        String fname = paths[1];
        String filePath = null;
        filePath = paths[0] != null && !paths[0].endsWith("\\") ? paths[0] + "\\" + paths[1] : paths[0] + paths[1];
        int fid = this.getFileId(filePath, fname, dirId, dbCtx);
        if (fid == -1) {
            return null;
        }
        DBFileInfo finfo2 = this.getFileInfo(filePath, dirId, fid, dbCtx);
        if (finfo2 != null && fstate != null) {
            fstate.setFileStatus(finfo2.isDirectory() ? 2 : 1);
            fstate.setFileId(finfo2.getFileId());
            finfo2.setFileName(fname);
            finfo2.setFullName(path);
            if (dbCtx.hasOfflineFiles() && !finfo2.hasAttribute(4096) && (dbCtx.getOfflineFileSize() == 0L || finfo2.getSize() >= dbCtx.getOfflineFileSize())) {
                finfo2.setFileAttributes(finfo2.getFileAttributes() + 4096);
            }
        }
        if (paths[2] != null) {
            finfo2 = this.getStreamInfo(fstate, paths, dbCtx);
        }
        return finfo2;
    }

    protected final int getFileId(String path, String name, int dirId, DBDeviceContext dbCtx) {
        FileStateCache cache = dbCtx.getStateCache();
        FileState state = null;
        if (cache != null && (state = cache.findFileState(path)) != null) {
            if (state.getFileId() != -1) {
                if (this.hasDebug()) {
                    Debug.println("@@ Cache hit - getFileId() name=" + name);
                }
                return state.getFileId();
            }
            if (state.getFileStatus() == 0) {
                if (this.hasDebug()) {
                    Debug.println("@@ Cache hit - getFileStatus() name=" + name + ", sts=NotExist");
                }
                return -1;
            }
        }
        int fileId = -1;
        try {
            fileId = dbCtx.getDBInterface().getFileId(dirId, name, false, false);
        }
        catch (DBException ex) {
            // empty catch block
        }
        if (state != null) {
            state.setFileId(fileId);
        }
        return fileId;
    }

    protected final void getRetentionDetailsForState(DBDeviceContext dbCtx, FileState fstate) throws DBException {
        RetentionDetails retDetails;
        if (dbCtx.hasRetentionPeriod() && (retDetails = dbCtx.getDBInterface().getFileRetentionDetails(-1, fstate.getFileId())) != null) {
            fstate.setRetentionExpiryDateTime(retDetails.getEndTime());
        }
    }

    protected final int findParentDirectoryId(DBDeviceContext ctx, String path, boolean filePath) {
        String[] paths = null;
        paths = path != null && path.startsWith("\\") ? FileName.splitPath(path) : FileName.splitPath("\\" + path);
        if (paths[0] != null && paths[0].compareTo("\\") == 0 || !paths[0].startsWith("\\")) {
            return 0;
        }
        FileStateCache cache = ctx.getStateCache();
        FileState state = null;
        if (cache != null && (state = cache.findFileState(paths[0])) != null && state.getFileId() != -1) {
            if (this.hasDebug()) {
                Debug.println("@@ Cache hit - findParentDirectoryId() path=" + paths[0]);
            }
            return state.getFileId();
        }
        int[] ids = this.findParentDirectoryIdList(ctx, path, filePath);
        if (ids == null) {
            return -1;
        }
        if (ids.length == 1) {
            return ids[0];
        }
        int idx = ids.length - 1;
        if (filePath && ids[ids.length - 1] == -1) {
            --idx;
        }
        return ids[idx];
    }

    protected final int[] findParentDirectoryIdList(DBDeviceContext ctx, String path, boolean filePath) {
        String[] paths = FileName.splitAllPaths(path);
        if (paths == null || paths.length == 0) {
            return null;
        }
        if (paths[0].compareTo("*.*") == 0 || paths[0].compareTo("*") == 0 || filePath && paths.length == 1) {
            int[] ids = new int[]{0};
            return ids;
        }
        if (paths[0].startsWith("\\")) {
            paths[0] = paths[0].substring(1);
        }
        int endIdx = paths.length - 1;
        if (filePath) {
            --endIdx;
        }
        if (endIdx <= 1 && paths[0].length() == 0) {
            int[] ids = new int[]{0};
            return ids;
        }
        int[] ids = new int[paths.length];
        for (int i = 0; i < ids.length; ++i) {
            ids[i] = -1;
        }
        StringBuffer pathStr = new StringBuffer("\\");
        FileStateCache cache = ctx.getStateCache();
        FileState fstate = null;
        int dirId = 0;
        int parentId = -1;
        try {
            for (int idx = 0; idx <= endIdx; ++idx) {
                String curPath = paths[idx];
                pathStr.append(curPath);
                fstate = cache.findFileState(pathStr.toString());
                if (fstate != null && fstate.getFileId() != -1) {
                    ids[idx] = fstate.getFileId();
                    parentId = dirId;
                    dirId = ids[idx];
                } else {
                    parentId = dirId;
                    dirId = ctx.getDBInterface().getFileId(dirId, curPath, true, true);
                    if (dirId != -1) {
                        ids[idx] = dirId;
                        if (fstate != null) {
                            fstate.setFileId(dirId);
                        } else {
                            fstate = cache.findFileState(pathStr.toString(), true);
                            DBFileInfo finfo = ctx.getDBInterface().getFileInformation(parentId, dirId, 2);
                            fstate.addAttribute("FileInfo", finfo);
                            fstate.setFileStatus(finfo.isDirectory() ? 2 : 1);
                            fstate.setFileId(dirId);
                        }
                    } else {
                        return null;
                    }
                }
                pathStr.append("\\");
            }
        }
        catch (DBException ex) {
            Debug.println(ex);
            return null;
        }
        return ids;
    }

    public DBFileInfo getFileInfo(String path, int dirId, int fid, DBDeviceContext dbCtx) {
        DBFileInfo finfo;
        FileState state = this.getFileState(path, dbCtx, true);
        if (state != null && state.getFileId() != -1) {
            if (this.hasDebug()) {
                Debug.println("@@ Cache hit - getFileInfo() path=" + path);
            }
            if ((finfo = (DBFileInfo)state.findAttribute("FileInfo")) != null) {
                return finfo;
            }
        }
        finfo = null;
        try {
            finfo = dbCtx.getDBInterface().getFileInformation(dirId, fid, 2);
        }
        catch (DBException ex) {
            Debug.println(ex);
            finfo = null;
        }
        if (finfo != null) {
            finfo.setFullName(path);
        }
        if (state != null && finfo != null) {
            state.addAttribute("FileInfo", finfo);
            state.setFileStatus(finfo.isDirectory() ? 2 : 1);
        }
        return finfo;
    }

    public DBFileInfo getStreamInfo(FileState parent, String[] paths, DBDeviceContext dbCtx) {
        DBFileInfo finfo;
        String streamPath = paths[0] + paths[1] + paths[2];
        FileState state = this.getFileState(streamPath, dbCtx, true);
        if (state != null && state.getFileId() != -1) {
            if (this.hasDebug()) {
                Debug.println("@@ Cache hit - getStreamInfo() path=" + streamPath);
            }
            if ((finfo = (DBFileInfo)state.findAttribute("FileInfo")) != null) {
                return finfo;
            }
        }
        if (this.hasDebug()) {
            Debug.println("DBDiskDriver getStreamInfo parent=" + parent.getPath() + ", stream=" + paths[2]);
        }
        finfo = null;
        try {
            StreamInfo sInfo;
            StreamInfoList sList = (StreamInfoList)parent.findAttribute(DBStreamList);
            if (sList == null) {
                sList = dbCtx.getDBInterface().getStreamsList(parent.getFileId(), 2);
                parent.addAttribute(DBStreamList, sList);
            }
            if (sList != null && (sInfo = sList.findStream(paths[2])) != null) {
                finfo = new DBFileInfo();
                finfo.setFileId(parent.getFileId());
                finfo.setFileName(sInfo.getName());
                finfo.setSize(sInfo.getSize());
                if (sInfo.hasCreationDateTime()) {
                    finfo.setCreationDateTime(sInfo.getCreationDateTime());
                }
                if (sInfo.hasModifyDateTime()) {
                    finfo.setModifyDateTime(sInfo.getModifyDateTime());
                } else if (sInfo.hasCreationDateTime()) {
                    finfo.setModifyDateTime(sInfo.getCreationDateTime());
                }
                if (sInfo.hasAccessDateTime()) {
                    finfo.setAccessDateTime(sInfo.getAccessDateTime());
                } else if (sInfo.hasCreationDateTime()) {
                    finfo.setAccessDateTime(sInfo.getCreationDateTime());
                }
            }
        }
        catch (DBException ex) {
            Debug.println(ex);
            finfo = null;
        }
        if (finfo != null) {
            finfo.setFullName(streamPath);
        }
        if (state != null && finfo != null) {
            state.addAttribute("FileInfo", finfo);
            state.setFileStatus(1);
        }
        return finfo;
    }

    protected final FileState getFileState(String path, DBDeviceContext ctx, boolean create) {
        FileStateCache cache = ctx.getStateCache();
        if (cache == null) {
            return null;
        }
        return cache.findFileState(path, create);
    }

    public void treeOpened(SrvSession sess, TreeConnection tree) {
    }

    public void treeClosed(SrvSession sess, TreeConnection tree) {
    }

    protected final boolean hasDebug() {
        return this.m_debug;
    }

    public final void getDiskInformation(DiskDeviceContext ctx, SrvDiskInfo info) throws IOException {
        DBDeviceContext dbCtx;
        if (ctx.hasDiskInformation()) {
            info.copyFrom(ctx.getDiskInformation());
        }
        if (ctx instanceof DBDeviceContext && (dbCtx = (DBDeviceContext)ctx).getFileLoader() instanceof DiskSizeInterface) {
            DiskSizeInterface sizeInterface = (DiskSizeInterface)((Object)dbCtx.getFileLoader());
            sizeInterface.getDiskInformation(ctx, info);
            if (this.hasDebug()) {
                Debug.println("DBDiskDriver getDiskInformation() handed to file loader");
            }
        }
        if (ctx.hasQuotaManager()) {
            long freeSpace = ctx.getQuotaManager().getAvailableFreeSpace();
            long freeUnits = freeSpace / info.getUnitSize();
            info.setFreeUnits(freeUnits);
        }
    }

    public boolean hasStreamsEnabled(SrvSession sess, TreeConnection tree) {
        DBDeviceContext dbCtx;
        if (tree.getContext() instanceof DBDeviceContext && (dbCtx = (DBDeviceContext)tree.getContext()).hasNTFSStreamsEnabled()) {
            return dbCtx.getFileLoader().supportsStreams();
        }
        return false;
    }

    public StreamInfo getStreamInformation(SrvSession sess, TreeConnection tree, StreamInfo streamInfo) throws IOException {
        if (this.hasDebug()) {
            Debug.println("### getStreamInformation() called ###");
        }
        return null;
    }

    public StreamInfoList getStreamList(SrvSession sess, TreeConnection tree, String fileName) throws IOException {
        DBDeviceContext dbCtx = (DBDeviceContext)tree.getContext();
        String parentPath = FileName.getParentPathForStream(fileName);
        FileState fstate = this.getFileState(parentPath, dbCtx, true);
        StreamInfoList streamList = (StreamInfoList)fstate.findAttribute(DBStreamList);
        if (streamList != null && streamList.numberOfStreams() > 0) {
            return streamList;
        }
        DBFileInfo finfo = this.getFileDetails(fileName, dbCtx, fstate);
        streamList = new StreamInfoList();
        StreamInfo sinfo = new StreamInfo("::$DATA", finfo.getFileId(), 0, finfo.getSize(), finfo.getAllocationSize());
        streamList.addStream(sinfo);
        StreamInfoList sList = this.loadStreamList(fstate, finfo, dbCtx, true);
        if (sList != null) {
            for (int i = 0; i < sList.numberOfStreams(); ++i) {
                streamList.addStream(sList.getStreamAt(i));
            }
        }
        fstate.addAttribute(DBStreamList, streamList);
        return streamList;
    }

    protected final NetworkFile createStream(SrvSession sess, TreeConnection tree, FileOpenParams params, FileState parent, DBDeviceContext dbCtx) throws IOException {
        DBNetworkFile file;
        block8: {
            DBFileInfo finfo = this.getFileDetails(params.getPath(), dbCtx, parent);
            if (finfo == null) {
                throw new AccessDeniedException();
            }
            StreamInfoList streamList = (StreamInfoList)parent.findAttribute(DBStreamList);
            if (streamList == null) {
                streamList = this.getStreamList(sess, tree, params.getPath());
            }
            if (streamList == null) {
                throw new AccessDeniedException();
            }
            if (streamList.findStream(params.getStreamName()) != null) {
                throw new FileExistsException("Stream exists, " + params.getFullPath());
            }
            file = null;
            try {
                int stid = dbCtx.getDBInterface().createStreamRecord(params.getStreamName(), finfo.getFileId());
                file = (DBNetworkFile)dbCtx.getFileLoader().openFile(params, finfo.getFileId(), stid, finfo.getDirectoryId(), true, false);
                file.setFullName(params.getFullPath());
                file.setStreamId(stid);
                file.setStreamName(params.getStreamName());
                file.setDirectoryId(finfo.getDirectoryId());
                file.setAttributes(params.getAttributes());
                FileState fstate = this.getFileState(params.getFullPath(), dbCtx, true);
                file.setFileState(fstate);
                fstate.setFileStatus(1);
                fstate.incrementOpenCount();
                file.openFile(true);
                StreamInfo stream = new StreamInfo(params.getStreamName(), file.getFileId(), stid);
                streamList.addStream(stream);
                if (this.hasDebug()) {
                    Debug.println("createStream() file=" + params.getPath() + ", stream=" + params.getStreamName() + ", fid/stid=" + file.getFileId() + "/" + stid);
                }
            }
            catch (DBException ex) {
                if (!this.hasDebug()) break block8;
                Debug.println("Error: " + ex.toString());
                Debug.println(ex);
            }
        }
        if (file == null) {
            throw new AccessDeniedException(params.getFullPath());
        }
        return file;
    }

    protected final NetworkFile openStream(SrvSession sess, TreeConnection tree, FileOpenParams params, FileState parent, DBDeviceContext dbCtx) throws IOException {
        DBFileInfo finfo = this.getFileDetails(params.getPath(), dbCtx, parent);
        if (finfo == null) {
            throw new AccessDeniedException();
        }
        StreamInfoList streamList = this.getStreamList(sess, tree, params.getPath());
        if (streamList == null) {
            throw new AccessDeniedException();
        }
        StreamInfo sInfo = streamList.findStream(params.getStreamName());
        if (sInfo == null) {
            throw new FileNotFoundException("Stream does not exist, " + params.getFullPath());
        }
        FileState fstate = this.getFileState(params.getFullPath(), dbCtx, true);
        if (params.getSharedAccess() == 0 && fstate.getOpenCount() > 0 && params.getProcessId() != fstate.getProcessId()) {
            throw new FileSharingException("File already open, " + params.getPath());
        }
        DBFileInfo sfinfo = new DBFileInfo(sInfo.getName(), params.getFullPath(), finfo.getFileId(), finfo.getDirectoryId());
        sfinfo.setFileSize(sInfo.getSize());
        sfinfo.setFileAttributes(0);
        sfinfo.setCreationDateTime(sInfo.getCreationDateTime());
        sfinfo.setModifyDateTime(sInfo.getModifyDateTime());
        sfinfo.setAccessDateTime(sInfo.getAccessDateTime());
        fstate.addAttribute("FileInfo", sfinfo);
        if (this.hasDebug()) {
            Debug.println("DB openStream() file=" + params.getPath() + ", stream=" + sInfo.getName());
        }
        DBNetworkFile jdbcFile = (DBNetworkFile)dbCtx.getFileLoader().openFile(params, finfo.getFileId(), sInfo.getStreamId(), finfo.getDirectoryId(), false, false);
        jdbcFile.setFileState(fstate);
        jdbcFile.setFileDetails(sfinfo);
        jdbcFile.openFile(false);
        fstate.setFileStatus(1);
        fstate.incrementOpenCount();
        return jdbcFile;
    }

    protected final void closeStream(SrvSession sess, TreeConnection tree, NetworkFile stream) throws IOException {
        if (this.hasDebug()) {
            Debug.println("DB closeStream() file=" + stream.getFullName() + ", stream=" + stream.getStreamName() + ", fid/stid=" + stream.getFileId() + "/" + stream.getStreamId());
        }
        DBDeviceContext dbCtx = (DBDeviceContext)tree.getContext();
        dbCtx.getFileLoader().closeFile(sess, stream);
        DBNetworkFile jdbcFile = null;
        if (stream instanceof DBNetworkFile) {
            FileInfo finfo;
            jdbcFile = (DBNetworkFile)stream;
            FileState fstate = jdbcFile.getFileState();
            if (fstate == null) {
                fstate = this.getFileState(stream.getFullName(), dbCtx, false);
            } else {
                fstate.decrementOpenCount();
            }
            if (fstate != null && (finfo = this.getFileInformation(sess, tree, fstate.getPath())) != null && stream.getWriteCount() > 0) {
                finfo.setSize(jdbcFile.getFileSize());
                finfo.setModifyDateTime(jdbcFile.getModifyDate());
                if (this.hasDebug()) {
                    Debug.println("  Stream size=" + jdbcFile.getFileSize() + ", modifyDate=" + jdbcFile.getModifyDate());
                }
            }
        } else {
            Debug.println("closeFile() Not DBNetworkFile file=" + stream);
        }
        if (stream.getGrantedAccess() != 0 && !stream.isDirectory() && stream.getWriteCount() > 0) {
            if (this.hasDebug()) {
                Debug.println("  Update stream size=" + stream.getFileSize());
            }
            long modifiedTime = 0L;
            modifiedTime = stream.hasModifyDate() ? stream.getModifyDate() : System.currentTimeMillis();
            if (stream.hasCreationDate() && modifiedTime < stream.getCreationDate()) {
                modifiedTime = stream.getCreationDate();
                if (this.hasDebug()) {
                    Debug.println("Close stream using creation date/time for modified date/time");
                }
            }
            String parentPath = FileName.getParentPathForStream(stream.getFullName());
            FileState parent = this.getFileState(parentPath, dbCtx, false);
            StreamInfo sInfo = null;
            int sattr = 0;
            if (parent != null) {
                StreamInfoList streamList = this.getStreamList(sess, tree, parentPath);
                if (streamList != null) {
                    sInfo = streamList.findStream(stream.getStreamName());
                    if (sInfo != null) {
                        sInfo.setSize(stream.getFileSize());
                        ++sattr;
                        if (this.hasDebug()) {
                            Debug.println("Updated stream file size");
                        }
                    } else {
                        Debug.println("** Failed to find details for stream " + stream.getStreamName());
                    }
                } else {
                    Debug.println("** Failed to get streams list for " + parentPath);
                }
            }
            try {
                if (sInfo == null) {
                    sInfo = new StreamInfo();
                    sInfo.setSize(stream.getFileSize());
                    sInfo.setStreamId(stream.getStreamId());
                    ++sattr;
                }
                sInfo.setModifyDateTime(System.currentTimeMillis());
                sInfo.setStreamInformationFlags(sattr += 4);
                dbCtx.getDBInterface().setStreamInformation(stream.getDirectoryId(), stream.getFileId(), stream.getStreamId(), sInfo);
            }
            catch (DBException ex) {
                // empty catch block
            }
        }
    }

    protected final void deleteStream(SrvSession sess, TreeConnection tree, String name) throws IOException {
        DBDeviceContext dbCtx = (DBDeviceContext)tree.getContext();
        String filePath = FileName.getParentPathForStream(name);
        FileState fstate = this.getFileState(filePath, dbCtx, true);
        FileState sstate = this.getFileState(name, dbCtx, false);
        if (fstate.hasActiveRetentionPeriod()) {
            throw new AccessDeniedException("File retention active");
        }
        DBFileInfo finfo = this.getFileDetails(filePath, dbCtx, fstate);
        StreamInfoList streamList = (StreamInfoList)fstate.findAttribute(DBStreamList);
        if (streamList == null) {
            streamList = this.getStreamList(sess, tree, filePath);
        }
        if (streamList == null) {
            throw new FileNotFoundException("Stream not found, " + name);
        }
        String[] paths = FileName.splitPathStream(name);
        StreamInfo sInfo = streamList.findStream(paths[2]);
        if (sInfo == null) {
            throw new FileNotFoundException("Stream not found, " + name);
        }
        try {
            dbCtx.getFileLoader().deleteFile(name, sInfo.getFileId(), sInfo.getStreamId());
            dbCtx.getDBInterface().deleteStreamRecord(sInfo.getFileId(), sInfo.getStreamId(), dbCtx.isTrashCanEnabled());
            streamList.removeStream(sInfo.getName());
            if (sstate != null) {
                sstate.setFileStatus(0);
            }
        }
        catch (DBException ex) {
            Debug.println("Error: " + ex.toString());
            Debug.println(ex);
        }
    }

    protected final StreamInfoList loadStreamList(FileState fstate, DBFileInfo finfo, DBDeviceContext dbCtx, boolean dbLoad) {
        StreamInfoList sList = (StreamInfoList)fstate.findAttribute("StreamsList");
        if (sList == null && dbLoad) {
            try {
                sList = dbCtx.getDBInterface().getStreamsList(finfo.getFileId(), 2);
                if (sList != null) {
                    fstate.addAttribute(DBStreamList, sList);
                }
            }
            catch (DBException ex) {
                // empty catch block
            }
        }
        return sList;
    }

    public void renameStream(SrvSession sess, TreeConnection tree, String oldName, String newName, boolean overWrite) throws IOException {
    }

    public VolumeInfo getVolumeInformation(DiskDeviceContext ctx) {
        VolumeInfo volInfo = ctx.getVolumeInformation();
        if (volInfo == null) {
            volInfo = new VolumeInfo(ctx.getDeviceName());
            ctx.setVolumeInformation(volInfo);
        }
        if (volInfo.getSerialNumber() == 0) {
            volInfo.setSerialNumber(new Random().nextInt());
        }
        if (!volInfo.hasCreationDateTime()) {
            volInfo.setCreationDateTime(new Date());
        }
        return volInfo;
    }

    public LockManager getLockManager(SrvSession sess, TreeConnection tree) {
        DBDeviceContext dbCtx = (DBDeviceContext)tree.getContext();
        return dbCtx.getLockManager();
    }

    public OpLockManager getOpLockManager(SrvSession sess, TreeConnection tree) {
        DBDeviceContext dbCtx = (DBDeviceContext)tree.getContext();
        return dbCtx.getLockManager();
    }

    public boolean isOpLocksEnabled(SrvSession sess, TreeConnection tree) {
        DBDeviceContext dbCtx = (DBDeviceContext)tree.getContext();
        return dbCtx.isOpLocksEnabled();
    }

    public String buildPathForFileId(SrvSession sess, TreeConnection tree, int dirid, int fileid) throws FileNotFoundException {
        DBDeviceContext dbCtx = (DBDeviceContext)tree.getContext();
        ArrayList<String> names = new ArrayList<String>(16);
        try {
            int curFid = fileid;
            int curDid = dirid;
            DBFileInfo finfo = null;
            do {
                if ((finfo = dbCtx.getDBInterface().getFileInformation(curDid, curFid, 1)) == null) {
                    throw new FileNotFoundException("" + curFid);
                }
                names.add(finfo.getFileName());
                curFid = finfo.getDirectoryId();
                curDid = -1;
            } while (curFid > 0);
        }
        catch (DBException ex) {
            Debug.println(ex);
            return null;
        }
        StringBuffer pathStr = new StringBuffer(256);
        pathStr.append("\\");
        for (int i = names.size() - 1; i >= 0; --i) {
            pathStr.append((String)names.get(i));
            pathStr.append("\\");
        }
        if (pathStr.length() > 0) {
            pathStr.setLength(pathStr.length() - 1);
        }
        return pathStr.toString();
    }

    public boolean hasSymbolicLinksEnabled(SrvSession sess, TreeConnection tree) {
        DBDeviceContext dbCtx = (DBDeviceContext)tree.getContext();
        return dbCtx.getDBInterface().supportsFeature(64);
    }

    public String readSymbolicLink(SrvSession sess, TreeConnection tree, String path) throws AccessDeniedException, FileNotFoundException {
        DBDeviceContext dbCtx = (DBDeviceContext)tree.getContext();
        DBInterface dbInterface = dbCtx.getDBInterface();
        String symLink = null;
        if (dbInterface.supportsFeature(64)) {
            FileState fstate = this.getFileState(path, dbCtx, true);
            int fid = fstate.getFileId();
            int dirId = -1;
            if (fid == -1) {
                dirId = this.findParentDirectoryId(dbCtx, path, true);
                if (dirId == -1) {
                    throw new FileNotFoundException(path);
                }
                String[] oldPaths = FileName.splitPath(path);
                String fname = oldPaths[1];
                fid = this.getFileId(path, fname, dirId, dbCtx);
                if (fid == -1) {
                    throw new FileNotFoundException(path);
                }
                fstate.setFileId(fid);
            }
            try {
                symLink = dbInterface.readSymbolicLink(dirId, fid);
            }
            catch (DBException ex) {
                throw new FileNotFoundException(path);
            }
        }
        return symLink;
    }
}

