/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.jlan.server.filesys.loader;

import java.util.LinkedList;
import org.alfresco.jlan.server.filesys.loader.FileRequest;

public class FileRequestQueue {
    private LinkedList<FileRequest> m_queue = new LinkedList();

    public final synchronized int numberOfRequests() {
        return this.m_queue.size();
    }

    public final synchronized void addRequest(FileRequest req) {
        this.m_queue.add(req);
        this.notifyAll();
    }

    public final synchronized FileRequest removeRequest() throws InterruptedException {
        this.waitWhileEmpty();
        return this.m_queue.removeFirst();
    }

    public final synchronized FileRequest removeRequestNoWait() {
        return this.m_queue.removeFirst();
    }

    public final void removeAllRequests() {
        this.m_queue.clear();
    }

    public final synchronized void waitWhileEmpty() throws InterruptedException {
        while (this.m_queue.size() == 0) {
            this.wait();
        }
    }

    public final synchronized void waitUntilEmpty() throws InterruptedException {
        while (this.m_queue.size() != 0) {
            this.wait();
        }
    }
}

