/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.jlan.server.filesys.loader;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileWriter;
import java.io.IOException;
import org.alfresco.jlan.debug.Debug;
import org.alfresco.jlan.server.SrvSession;
import org.alfresco.jlan.server.core.DeviceContext;
import org.alfresco.jlan.server.filesys.AccessDeniedException;
import org.alfresco.jlan.server.filesys.FileInfo;
import org.alfresco.jlan.server.filesys.FileName;
import org.alfresco.jlan.server.filesys.FileOpenParams;
import org.alfresco.jlan.server.filesys.NetworkFile;
import org.alfresco.jlan.server.filesys.db.DBDeviceContext;
import org.alfresco.jlan.server.filesys.db.LocalDataNetworkFile;
import org.alfresco.jlan.server.filesys.loader.FileLoader;
import org.alfresco.jlan.server.filesys.loader.FileLoaderException;
import org.alfresco.jlan.server.filesys.loader.FileProcessor;
import org.alfresco.jlan.server.filesys.loader.FileRequest;
import org.alfresco.jlan.server.filesys.loader.NamedFileLoader;
import org.springframework.extensions.config.ConfigElement;

public class SimpleFileLoader
implements FileLoader,
NamedFileLoader {
    private String m_rootPath;
    private boolean m_debug;

    public int getRequiredDBFeatures() {
        return 0;
    }

    public NetworkFile openFile(FileOpenParams params, int fid, int stid, int did, boolean create, boolean dir) throws IOException, FileNotFoundException {
        File file;
        String fullName = FileName.buildPath(this.getRootPath(), params.getPath(), null, File.separatorChar);
        if (this.m_debug) {
            Debug.println("SimpleFileLoader.openFile() fname=" + params.getPath() + ", fid=" + fid + ", did=" + did + ", fullName=" + fullName);
        }
        if (!(file = new File(fullName)).exists()) {
            String mappedPath = FileName.mapPath(this.getRootPath(), params.getPath());
            if (mappedPath == null && !create) {
                throw new FileNotFoundException("File does not exist, " + params.getPath());
            }
            file = new File(mappedPath);
            if (!file.exists() && !create) {
                throw new FileNotFoundException("File does not exist, " + params.getPath());
            }
            fullName = mappedPath;
        }
        if (create) {
            FileWriter newFile = new FileWriter(file);
            newFile.close();
        }
        file = new File(fullName);
        LocalDataNetworkFile netFile = new LocalDataNetworkFile(params.getPath(), fid, did, file);
        netFile.setGrantedAccess(2);
        return netFile;
    }

    public void closeFile(SrvSession sess, NetworkFile netFile) throws IOException {
        netFile.closeFile();
    }

    public void deleteFile(String fname, int fid, int stid) throws IOException {
        String name;
        File delFile;
        if (this.m_debug) {
            Debug.println("SimpleFileLoader.deleteFile() fname=" + fname + ", fid=" + fid);
        }
        if ((delFile = new File(name = FileName.buildPath(this.getRootPath(), fname, null, File.separatorChar))).exists() && delFile.isFile()) {
            delFile.delete();
        }
    }

    public void createDirectory(String dir, int fid) throws IOException {
        if (this.m_debug) {
            Debug.println("SimpleFileLoader.createDirectory() dir=" + dir + ", fid=" + fid);
        }
        String dirname = FileName.buildPath(this.getRootPath(), dir, null, File.separatorChar);
        File newDir = new File(dirname);
        newDir.mkdir();
    }

    public void deleteDirectory(String dir, int fid) throws IOException {
        String mappedPath;
        String dirname;
        File delDir;
        if (this.m_debug) {
            Debug.println("SimpleFileLoader.deleteDirectory() dir=" + dir + ", fid=" + fid);
        }
        if ((delDir = new File(dirname = FileName.buildPath(this.getRootPath(), dir, null, File.separatorChar))).exists() && delDir.isDirectory()) {
            String[] fileList = delDir.list();
            if (fileList != null && fileList.length > 0) {
                throw new AccessDeniedException("Directory not empty");
            }
            delDir.delete();
        } else if (!delDir.exists() && (mappedPath = FileName.mapPath(this.getRootPath(), dir)) != null && (delDir = new File(mappedPath)).isDirectory()) {
            String[] fileList = delDir.list();
            if (fileList != null && fileList.length > 0) {
                throw new AccessDeniedException("Directory not empty");
            }
            delDir.delete();
        }
    }

    public void setFileInformation(String path, int fid, FileInfo finfo) throws IOException {
    }

    public void renameFileDirectory(String curName, int fid, String newName, boolean isdir) throws IOException {
        String newPath;
        File newFile;
        String curPath;
        File curFile;
        if (this.m_debug) {
            Debug.println("SimpleFileLoader.renameFileDirectory() curName=" + curName + ", fid=" + fid + ", newName=" + newName);
        }
        if (!(curFile = new File(curPath = FileName.buildPath(this.getRootPath(), curName, null, File.separatorChar))).renameTo(newFile = new File(newPath = FileName.buildPath(this.getRootPath(), newName, null, File.separatorChar)))) {
            throw new IOException("Rename " + curPath + " to " + newPath + " failed");
        }
    }

    protected final String getRootPath() {
        return this.m_rootPath;
    }

    public void initializeLoader(ConfigElement params, DeviceContext ctx) throws FileLoaderException {
        ConfigElement nameVal;
        if (params.getChild("Debug") != null) {
            this.m_debug = true;
        }
        if ((nameVal = params.getChild("RootPath")) == null || nameVal.getValue() == null || nameVal.getValue().length() == 0) {
            throw new FileLoaderException("SimpleFileLoader RootPath parameter required");
        }
        this.m_rootPath = nameVal.getValue();
        File root = new File(this.m_rootPath);
        if (!root.exists() || root.isFile()) {
            throw new FileLoaderException("SimpleFileLoader RootPath does not exist or is not a directory, " + this.m_rootPath);
        }
    }

    public final void queueFileRequest(FileRequest fileReq) {
    }

    public void shutdownLoader(boolean immediate) {
    }

    public boolean supportsStreams() {
        return false;
    }

    public void addFileProcessor(FileProcessor fileProc) throws FileLoaderException {
        throw new FileLoaderException("File processors not supported");
    }

    public final void setContext(DBDeviceContext dbCtx) {
    }
}

